/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.render;

import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_268;
import net.minecraft.class_270;
import net.minecraft.class_5250;
import net.minecraft.class_640;
import nx.pingwheel.common.CommonClient;
import nx.pingwheel.common.config.ClientConfig;
import nx.pingwheel.common.config.PlayerInfoMode;
import nx.pingwheel.common.config.TeamColorMode;
import nx.pingwheel.common.core.PingView;
import nx.pingwheel.common.math.ScreenPos;
import nx.pingwheel.common.render.DrawContext;
import nx.pingwheel.common.resource.LanguageUtils;
import org.joml.Matrix3x2fStack;

public class PingLocationRenderer {
    private static final ClientConfig CLIENT_CONFIG = ClientConfig.HANDLER.getConfig();
    private static final int WHITE = -1;

    private PingLocationRenderer() {
    }

    public static void draw(DrawContext ctx, PingView ping) {
        boolean showVerbosePlayerInfo;
        ScreenPos screenPos = ping.getScreenPos();
        if (screenPos == null) {
            return;
        }
        Matrix3x2fStack m = ctx.getMatrices();
        float pingScale = ping.getScale();
        m.pushMatrix();
        m.translate(screenPos.x, screenPos.y);
        m.scale(pingScale, pingScale);
        boolean labelUseTeamColor = CLIENT_CONFIG.getTeamColorMode() == TeamColorMode.FULL || CLIENT_CONFIG.getTeamColorMode() == TeamColorMode.LABELS_ONLY;
        boolean pingUseTeamColor = CLIENT_CONFIG.getTeamColorMode() == TeamColorMode.FULL || CLIENT_CONFIG.getTeamColorMode() == TeamColorMode.PING_ONLY;
        int distanceColor = labelUseTeamColor ? ping.getTeamColor() : -1;
        int pingColor = pingUseTeamColor ? ping.getTeamColor() : -1;
        class_640 author = ping.getPlayerInfo();
        class_640 compactPlayerInfo = CLIENT_CONFIG.getPlayerInfoMode() == PlayerInfoMode.COMPACT ? author : null;
        class_5250 distanceText = LanguageUtils.UNIT_METERS.get("%,.1f".formatted(ping.getDistance()));
        ctx.renderLabel((class_2561)distanceText, -1.5f, compactPlayerInfo, distanceColor);
        ctx.renderPing(ping.getItemStack(), CLIENT_CONFIG.isItemIconVisible(), pingColor);
        boolean isPlayerListHeld = CLIENT_CONFIG.getPlayerInfoMode() == PlayerInfoMode.HOLD && CommonClient.Game.field_1690.field_1907.method_1434();
        boolean bl = showVerbosePlayerInfo = CLIENT_CONFIG.getPlayerInfoMode() == PlayerInfoMode.ALWAYS || isPlayerListHeld;
        if (showVerbosePlayerInfo && author != null) {
            class_5250 displayName = class_268.method_1142((class_270)author.method_2955(), (class_2561)class_2561.method_43470((String)author.method_2966().getName()));
            if (!labelUseTeamColor) {
                displayName = displayName.method_27692(class_124.field_1070);
            }
            ctx.renderLabel((class_2561)displayName, 1.75f, author, -1);
        }
        m.popMatrix();
    }
}

