/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.display;

import com.mojang.serialization.Codec;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.api.behaviour.display.DisplayHolder;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.trains.display.FlapDisplayBlock;
import com.zurrtum.create.content.trains.display.FlapDisplayLayout;
import com.zurrtum.create.content.trains.display.FlapDisplaySection;
import com.zurrtum.create.foundation.utility.DynamicComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1767;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5244;

public class FlapDisplayBlockEntity
extends KineticBlockEntity
implements DisplayHolder {
    public List<FlapDisplayLayout> lines;
    public boolean isController;
    public boolean isRunning;
    public int xSize;
    public int ySize;
    public class_1767[] colour;
    public boolean[] glowingLines;
    public boolean[] manualLines;
    private class_2487 displayLink;

    public FlapDisplayBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.FLAP_DISPLAY, pos, state);
        this.setLazyTickRate(10);
        this.isController = false;
        this.xSize = 1;
        this.ySize = 1;
        this.colour = new class_1767[2];
        this.manualLines = new boolean[2];
        this.glowingLines = new boolean[2];
    }

    @Override
    public class_2487 getDisplayLinkData() {
        return this.displayLink;
    }

    @Override
    public void setDisplayLinkData(class_2487 data) {
        this.displayLink = data;
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        this.updateControllerStatus();
    }

    public void updateControllerStatus() {
        if (this.field_11863.field_9236) {
            return;
        }
        class_2680 blockState = this.method_11010();
        if (!(blockState.method_26204() instanceof FlapDisplayBlock)) {
            return;
        }
        class_2350 leftDirection = ((class_2350)blockState.method_11654((class_2769)FlapDisplayBlock.HORIZONTAL_FACING)).method_10170();
        boolean shouldBeController = (Boolean)blockState.method_11654((class_2769)FlapDisplayBlock.UP) == false && this.field_11863.method_8320(this.field_11867.method_10093(leftDirection)) != blockState;
        int newXSize = 1;
        int newYSize = 1;
        if (shouldBeController) {
            for (int xOffset = 1; xOffset < 32 && this.field_11863.method_8320(this.field_11867.method_10079(leftDirection.method_10153(), xOffset)) == blockState; ++xOffset) {
                ++newXSize;
            }
            for (int yOffset = 0; yOffset < 32 && ((Boolean)this.field_11863.method_8320(this.field_11867.method_10079(class_2350.field_11033, yOffset)).method_61767((class_2769)FlapDisplayBlock.DOWN, (Comparable)Boolean.valueOf(false))).booleanValue(); ++yOffset) {
                ++newYSize;
            }
        }
        if (this.isController == shouldBeController && newXSize == this.xSize && newYSize == this.ySize) {
            return;
        }
        this.isController = shouldBeController;
        this.xSize = newXSize;
        this.ySize = newYSize;
        this.colour = Arrays.copyOf(this.colour, this.ySize * 2);
        this.glowingLines = Arrays.copyOf(this.glowingLines, this.ySize * 2);
        this.manualLines = new boolean[this.ySize * 2];
        this.lines = null;
        this.sendData();
    }

    @Override
    public void tick() {
        super.tick();
        this.isRunning = super.isSpeedRequirementFulfilled();
        if (!(this.field_11863.field_9236 && this.isRunning || this.isVirtual())) {
            return;
        }
        int activeFlaps = 0;
        boolean instant = Math.abs(this.getSpeed()) > 128.0f;
        for (FlapDisplayLayout line : this.lines) {
            for (FlapDisplaySection section : line.getSections()) {
                activeFlaps += section.tick(instant, this.field_11863.field_9229);
            }
        }
        if (activeFlaps == 0) {
            return;
        }
        float volume = class_3532.method_15363((float)((float)activeFlaps / 20.0f), (float)0.25f, (float)1.5f);
        float bgVolume = class_3532.method_15363((float)((float)activeFlaps / 40.0f), (float)0.25f, (float)1.0f);
        class_2338 middle = this.field_11867.method_10079(this.getDirection().method_10170(), this.xSize / 2).method_10079(class_2350.field_11033, this.ySize / 2);
        AllSoundEvents.SCROLL_VALUE.playAt(this.field_11863, (class_2382)middle, volume, 0.56f, false);
        this.field_11863.method_8486((double)middle.method_10263(), (double)middle.method_10264(), (double)middle.method_10260(), class_3417.field_26951, class_3419.field_15245, 0.35f * bgVolume, 1.95f, false);
    }

    @Override
    public boolean isNoisy() {
        return false;
    }

    @Override
    public boolean isSpeedRequirementFulfilled() {
        return this.isRunning;
    }

    public void applyTextManually(int lineIndex, class_2561 componentText) {
        List<FlapDisplayLayout> lines = this.getLines();
        if (lineIndex >= lines.size()) {
            return;
        }
        FlapDisplayLayout layout = lines.get(lineIndex);
        if (!layout.isLayout("Default")) {
            layout.loadDefault(this.getMaxCharCount());
        }
        List<FlapDisplaySection> sections = layout.getSections();
        FlapDisplaySection flapDisplaySection = sections.getFirst();
        if (componentText == null) {
            this.manualLines[lineIndex] = false;
            flapDisplaySection.setText(class_5244.field_39003);
            this.notifyUpdate();
            return;
        }
        this.manualLines[lineIndex] = true;
        class_2561 text = this.isVirtual() ? componentText : DynamicComponent.parseCustomText(this.field_11863, this.field_11867, componentText);
        flapDisplaySection.setText(text);
        if (this.isVirtual()) {
            flapDisplaySection.refresh(true);
        } else {
            this.notifyUpdate();
        }
    }

    public void setColour(int lineIndex, class_1767 color) {
        this.colour[lineIndex] = color == class_1767.field_7952 ? null : color;
        this.notifyUpdate();
    }

    public void setGlowing(int lineIndex) {
        this.glowingLines[lineIndex] = true;
        this.notifyUpdate();
    }

    public List<FlapDisplayLayout> getLines() {
        if (this.lines == null) {
            this.initDefaultSections();
        }
        return this.lines;
    }

    public void initDefaultSections() {
        this.lines = new ArrayList<FlapDisplayLayout>();
        for (int i = 0; i < this.ySize * 2; ++i) {
            this.lines.add(new FlapDisplayLayout(this.getMaxCharCount()));
        }
    }

    public int getMaxCharCount() {
        return this.getMaxCharCount(0);
    }

    public int getMaxCharCount(int gaps) {
        return (int)(((float)this.xSize * 16.0f - 2.0f - 4.0f * (float)gaps) / 3.5f);
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        int j;
        super.write(view, clientPacket);
        this.writeDisplayLink(view);
        view.method_71472("Controller", this.isController);
        view.method_71465("XSize", this.xSize);
        view.method_71465("YSize", this.ySize);
        for (j = 0; j < this.manualLines.length; ++j) {
            if (!this.manualLines[j]) continue;
            view.method_71472("CustomLine" + j, true);
        }
        for (j = 0; j < this.glowingLines.length; ++j) {
            if (!this.glowingLines[j]) continue;
            view.method_71472("GlowingLine" + j, true);
        }
        for (j = 0; j < this.colour.length; ++j) {
            if (this.colour[j] == null) continue;
            view.method_71468("Dye" + j, (Codec)class_1767.field_41600, (Object)this.colour[j]);
        }
        List<FlapDisplayLayout> lines = this.getLines();
        for (int i = 0; i < lines.size(); ++i) {
            lines.get(i).write(view.method_71461("Display" + i));
        }
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        int i;
        super.read(view, clientPacket);
        this.readDisplayLink(view);
        boolean wasActive = this.isController;
        int prevX = this.xSize;
        int prevY = this.ySize;
        this.isController = view.method_71433("Controller", false);
        this.xSize = view.method_71424("XSize", 0);
        this.ySize = view.method_71424("YSize", 0);
        this.manualLines = new boolean[this.ySize * 2];
        for (i = 0; i < this.ySize * 2; ++i) {
            this.manualLines[i] = view.method_71433("CustomLine" + i, false);
        }
        this.glowingLines = new boolean[this.ySize * 2];
        for (i = 0; i < this.ySize * 2; ++i) {
            this.glowingLines[i] = view.method_71433("GlowingLine" + i, false);
        }
        this.colour = new class_1767[this.ySize * 2];
        for (i = 0; i < this.ySize * 2; ++i) {
            this.colour[i] = view.method_71426("Dye" + i, (Codec)class_1767.field_41600).orElse(null);
        }
        if (clientPacket && wasActive != this.isController || prevX != this.xSize || prevY != this.ySize) {
            this.invalidateRenderBoundingBox();
            this.lines = null;
        }
        List<FlapDisplayLayout> lines = this.getLines();
        for (int i2 = 0; i2 < lines.size(); ++i2) {
            lines.get(i2).read(view.method_71434("Display" + i2));
        }
    }

    public int getLineIndexAt(double yCoord) {
        return (int)class_3532.method_15350((double)Math.floor(2.0 * ((double)this.field_11867.method_10264() - yCoord + 1.0)), (double)0.0, (double)(this.ySize * 2));
    }

    public FlapDisplayBlockEntity getController() {
        if (this.isController) {
            return this;
        }
        class_2680 blockState = this.method_11010();
        if (!(blockState.method_26204() instanceof FlapDisplayBlock)) {
            return null;
        }
        class_2338.class_2339 pos = this.method_11016().method_25503();
        class_2350 side = ((class_2350)blockState.method_11654((class_2769)FlapDisplayBlock.HORIZONTAL_FACING)).method_10170();
        for (int i = 0; i < 64; ++i) {
            class_2680 other = this.field_11863.method_8320((class_2338)pos);
            if (((Boolean)other.method_61767((class_2769)FlapDisplayBlock.UP, (Comparable)Boolean.valueOf(false))).booleanValue()) {
                pos.method_10098(class_2350.field_11036);
                continue;
            }
            if (!((Boolean)this.field_11863.method_8320(pos.method_10093(side)).method_61767((class_2769)FlapDisplayBlock.UP, (Comparable)Boolean.valueOf(true))).booleanValue()) {
                pos.method_10098(side);
                continue;
            }
            class_2586 found = this.field_11863.method_8321((class_2338)pos);
            if (!(found instanceof FlapDisplayBlockEntity)) break;
            FlapDisplayBlockEntity flap = (FlapDisplayBlockEntity)found;
            if (!flap.isController) break;
            return flap;
        }
        return null;
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        class_238 aabb = new class_238(this.field_11867);
        if (!this.isController) {
            return aabb;
        }
        class_2382 normal = this.getDirection().method_10170().method_62675();
        return aabb.method_1012((double)(normal.method_10263() * this.xSize), (double)(-this.ySize), (double)(normal.method_10260() * this.xSize));
    }

    public class_2350 getDirection() {
        return ((class_2350)this.method_11010().method_61767((class_2769)FlapDisplayBlock.HORIZONTAL_FACING, (Comparable)class_2350.field_11035)).method_10153();
    }

    public boolean isLineGlowing(int line) {
        return this.glowingLines[line];
    }
}

