/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.gantry;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.content.contraptions.AssemblyException;
import com.zurrtum.create.content.contraptions.ContraptionCollider;
import com.zurrtum.create.content.contraptions.gantry.GantryCarriageBlock;
import com.zurrtum.create.content.contraptions.gantry.GantryContraption;
import com.zurrtum.create.content.contraptions.gantry.GantryContraptionEntity;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.gantry.GantryShaftBlock;
import com.zurrtum.create.content.kinetics.gantry.GantryShaftBlockEntity;
import com.zurrtum.create.content.kinetics.transmission.sequencer.SequencerInstructions;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_4538;

public class GantryCarriageBlockEntity
extends KineticBlockEntity {
    boolean assembleNextTick;
    protected AssemblyException lastException;

    public GantryCarriageBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.GANTRY_PINION, pos, state);
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.CONTRAPTION_ACTORS);
    }

    @Override
    public void onSpeedChanged(float previousSpeed) {
        super.onSpeedChanged(previousSpeed);
    }

    public void checkValidGantryShaft() {
        if (this.shouldAssemble()) {
            this.queueAssembly();
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        if (!this.method_11010().method_26184((class_4538)this.field_11863, this.field_11867)) {
            this.field_11863.method_22352(this.field_11867, true);
        }
    }

    public void queueAssembly() {
        this.assembleNextTick = true;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.field_11863.field_9236) {
            return;
        }
        if (this.assembleNextTick) {
            this.tryAssemble();
            this.assembleNextTick = false;
        }
    }

    public AssemblyException getLastAssemblyException() {
        return this.lastException;
    }

    private void tryAssemble() {
        class_2350 shaftOrientation;
        class_2680 blockState = this.method_11010();
        if (!(blockState.method_26204() instanceof GantryCarriageBlock)) {
            return;
        }
        class_2350 direction = (class_2350)blockState.method_11654((class_2769)GantryCarriageBlock.FACING);
        GantryContraption contraption = new GantryContraption(direction);
        class_2586 blockEntity = this.field_11863.method_8321(this.field_11867.method_10093(direction.method_10153()));
        if (!(blockEntity instanceof GantryShaftBlockEntity)) {
            return;
        }
        GantryShaftBlockEntity shaftBE = (GantryShaftBlockEntity)blockEntity;
        class_2680 shaftState = shaftBE.method_11010();
        if (shaftState.method_26204() != AllBlocks.GANTRY_SHAFT) {
            return;
        }
        float pinionMovementSpeed = shaftBE.getPinionMovementSpeed();
        class_2350 movementDirection = shaftOrientation = (class_2350)shaftState.method_11654((class_2769)GantryShaftBlock.FACING);
        if (pinionMovementSpeed < 0.0f) {
            movementDirection = movementDirection.method_10153();
        }
        try {
            this.lastException = null;
            if (!contraption.assemble(this.field_11863, this.field_11867)) {
                return;
            }
            this.sendData();
        }
        catch (AssemblyException e) {
            this.lastException = e;
            this.sendData();
            return;
        }
        if (ContraptionCollider.isCollidingWithWorld(this.field_11863, contraption, this.field_11867.method_10093(movementDirection), movementDirection)) {
            return;
        }
        if (contraption.containsBlockBreakers()) {
            this.award(AllAdvancements.CONTRAPTION_ACTORS);
        }
        contraption.removeBlocksFromWorld(this.field_11863, class_2338.field_10980);
        GantryContraptionEntity movedContraption = GantryContraptionEntity.create(this.field_11863, contraption, shaftOrientation);
        class_2338 anchor = this.field_11867;
        movedContraption.method_23327(anchor.method_10263(), anchor.method_10264(), anchor.method_10260());
        AllSoundEvents.CONTRAPTION_ASSEMBLE.playOnServer(this.field_11863, (class_2382)this.field_11867);
        this.field_11863.method_8649((class_1297)movedContraption);
        if (shaftBE.sequenceContext != null && shaftBE.sequenceContext.instruction() == SequencerInstructions.TURN_DISTANCE) {
            movedContraption.limitMovement(shaftBE.sequenceContext.getEffectiveValue(shaftBE.getTheoreticalSpeed()));
        }
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        if (this.lastException != null) {
            view.method_71468("LastException", AssemblyException.CODEC, (Object)this.lastException);
        }
        super.write(view, clientPacket);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        this.lastException = view.method_71426("LastException", AssemblyException.CODEC).orElse(null);
        super.read(view, clientPacket);
    }

    @Override
    public float propagateRotationTo(KineticBlockEntity target, class_2680 stateFrom, class_2680 stateTo, class_2338 diff, boolean connectedViaAxes, boolean connectedViaCogs) {
        float defaultModifier = super.propagateRotationTo(target, stateFrom, stateTo, diff, connectedViaAxes, connectedViaCogs);
        if (connectedViaAxes) {
            return defaultModifier;
        }
        if (!stateTo.method_27852((class_2248)AllBlocks.GANTRY_SHAFT)) {
            return defaultModifier;
        }
        if (!((Boolean)stateTo.method_11654((class_2769)GantryShaftBlock.POWERED)).booleanValue()) {
            return defaultModifier;
        }
        class_2350 direction = class_2350.method_10147((float)diff.method_10263(), (float)diff.method_10264(), (float)diff.method_10260());
        if (stateFrom.method_11654((class_2769)GantryCarriageBlock.FACING) != direction.method_10153()) {
            return defaultModifier;
        }
        return GantryCarriageBlockEntity.getGantryPinionModifier((class_2350)stateTo.method_11654((class_2769)GantryShaftBlock.FACING), (class_2350)stateFrom.method_11654((class_2769)GantryCarriageBlock.FACING));
    }

    public static float getGantryPinionModifier(class_2350 shaft, class_2350 pinionDirection) {
        class_2350.class_2351 shaftAxis = shaft.method_10166();
        float directionModifier = shaft.method_10171().method_10181();
        if (shaftAxis == class_2350.class_2351.field_11052 && (pinionDirection == class_2350.field_11043 || pinionDirection == class_2350.field_11034)) {
            return -directionModifier;
        }
        if (shaftAxis == class_2350.class_2351.field_11048 && (pinionDirection == class_2350.field_11033 || pinionDirection == class_2350.field_11035)) {
            return -directionModifier;
        }
        if (shaftAxis == class_2350.class_2351.field_11051 && (pinionDirection == class_2350.field_11036 || pinionDirection == class_2350.field_11039)) {
            return -directionModifier;
        }
        return directionModifier;
    }

    private boolean shouldAssemble() {
        class_2680 blockState = this.method_11010();
        if (!(blockState.method_26204() instanceof GantryCarriageBlock)) {
            return false;
        }
        class_2350 facing = ((class_2350)blockState.method_11654((class_2769)GantryCarriageBlock.FACING)).method_10153();
        class_2680 shaftState = this.field_11863.method_8320(this.field_11867.method_10093(facing));
        if (!(shaftState.method_26204() instanceof GantryShaftBlock)) {
            return false;
        }
        if (((Boolean)shaftState.method_11654((class_2769)GantryShaftBlock.POWERED)).booleanValue()) {
            return false;
        }
        class_2586 be = this.field_11863.method_8321(this.field_11867.method_10093(facing));
        return be instanceof GantryShaftBlockEntity && ((GantryShaftBlockEntity)be).canAssembleOn();
    }
}

