/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.trains.display;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.flywheel.lib.transform.PoseTransformStack;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.foundation.utility.DyeHelper;
import com.zurrtum.create.content.trains.display.FlapDisplayBlock;
import com.zurrtum.create.content.trains.display.FlapDisplayBlockEntity;
import com.zurrtum.create.content.trains.display.FlapDisplayLayout;
import com.zurrtum.create.content.trains.display.FlapDisplaySection;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1767;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_377;
import net.minecraft.class_379;
import net.minecraft.class_382;
import net.minecraft.class_384;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5223;
import net.minecraft.class_5224;
import net.minecraft.class_5251;
import net.minecraft.class_5614;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class FlapDisplayRenderer
extends KineticBlockEntityRenderer<FlapDisplayBlockEntity> {
    public FlapDisplayRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    protected void renderSafe(FlapDisplayBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        super.renderSafe(be, partialTicks, ms, buffer, light, overlay);
        class_327 fontRenderer = class_310.method_1551().field_1772;
        class_377 fontSet = fontRenderer.method_27526(class_2583.field_24359);
        float scale = 0.03125f;
        if (!be.isController) {
            return;
        }
        List<FlapDisplayLayout> lines = be.getLines();
        ms.method_22903();
        ((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)TransformStack.of(ms).center()).rotateYDegrees(AngleHelper.horizontalAngle((class_2350)be.method_11010().method_11654((class_2769)FlapDisplayBlock.HORIZONTAL_FACING)))).uncenter()).translate(0.0f, 0.0f, -0.1875f);
        ms.method_46416(0.0f, 1.0f, 1.0f);
        ms.method_22905(scale, scale, scale);
        ms.method_22905(1.0f, -1.0f, 1.0f);
        ms.method_46416(0.0f, 0.0f, 0.5f);
        for (int j = 0; j < lines.size(); ++j) {
            List<FlapDisplaySection> line = lines.get(j).getSections();
            int color = FlapDisplayRenderer.getLineColor(be, j);
            ms.method_22903();
            float w = 0.0f;
            for (FlapDisplaySection section : line) {
                w += section.getSize() + (float)(section.hasGap ? 8 : 1);
            }
            ms.method_46416((float)(be.xSize * 16) - w / 2.0f + 1.0f, 4.5f, 0.0f);
            class_4587.class_4665 transform = ms.method_23760();
            FlapDisplayRenderOutput renderOutput = new FlapDisplayRenderOutput(fontSet, buffer, color, transform.method_23761(), light, j, !be.isSpeedRequirementFulfilled(), be.method_10997(), be.isLineGlowing(j));
            for (int i = 0; i < line.size(); ++i) {
                FlapDisplaySection section = line.get(i);
                renderOutput.nextSection(section);
                int ticks = AnimationTickHolder.getTicks((class_1936)be.method_10997());
                String text = section.renderCharsIndividually() || !section.spinning[0] ? section.text : section.cyclingOptions[(ticks / 3 + i * 13) % section.cyclingOptions.length];
                class_5223.method_27479((String)text, (class_2583)class_2583.field_24360, (class_5224)renderOutput);
                ms.method_46416(section.getSize() + (float)(section.hasGap ? 8 : 1), 0.0f, 0.0f);
            }
            if (buffer instanceof class_4597.class_4598) {
                class_4597.class_4598 bs = (class_4597.class_4598)buffer;
                class_382 texturedglyph = fontSet.method_22943();
                bs.method_22994(texturedglyph.method_24045(class_327.class_6415.field_33993));
            }
            ms.method_22909();
            ms.method_46416(0.0f, 16.0f, 0.0f);
        }
        ms.method_22909();
    }

    public static int getLineColor(FlapDisplayBlockEntity be, int line) {
        class_1767 color = be.colour[line];
        return color == null ? -2898246 : (Integer)DyeHelper.getDyeColors(color).getFirst() | 0xFF000000;
    }

    @Override
    protected SuperByteBuffer getRotatedModel(FlapDisplayBlockEntity be, class_2680 state) {
        return CachedBuffers.partialFacingVertical(AllPartialModels.SHAFTLESS_COGWHEEL, state, (class_2350)state.method_11654((class_2769)FlapDisplayBlock.HORIZONTAL_FACING));
    }

    public boolean method_3563() {
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    static class FlapDisplayRenderOutput
    implements class_5224 {
        final class_377 fontSet;
        final class_4597 bufferSource;
        final int color;
        final int r;
        final int g;
        final int b;
        final int a;
        final Matrix4f pose;
        final int light;
        final boolean paused;
        FlapDisplaySection section;
        float x;
        private int lineIndex;
        private class_1937 level;

        public FlapDisplayRenderOutput(class_377 fontSet, class_4597 buffer, int color, Matrix4f pose, int light, int lineIndex, boolean paused, class_1937 level, boolean glowing) {
            this.fontSet = fontSet;
            this.bufferSource = buffer;
            this.lineIndex = lineIndex;
            this.level = level;
            this.a = glowing ? -134217728 : -671088640;
            this.r = color >> 16 & 0xFF;
            this.g = color >> 8 & 0xFF;
            this.b = color & 0xFF;
            this.color = color;
            this.pose = pose;
            this.light = glowing ? 0xF000F0 : light;
            this.paused = paused;
        }

        public void nextSection(FlapDisplaySection section) {
            this.section = section;
            this.x = 0.0f;
        }

        public boolean accept(int charIndex, class_2583 style, int glyph) {
            float standardWidth;
            int ticks = this.paused ? 0 : AnimationTickHolder.getTicks((class_1936)this.level);
            float time = this.paused ? 0.0f : AnimationTickHolder.getRenderTime((class_1936)this.level);
            class_5251 textcolor = style.method_10973();
            boolean canDim = textcolor == null;
            boolean dim = false;
            if (this.section.renderCharsIndividually() && this.section.spinning[Math.min(charIndex, this.section.spinning.length)]) {
                float speed = this.section.spinningTicks > 5 && this.section.spinningTicks < 20 ? 1.75f : 2.5f;
                float cycle = time / speed + (float)charIndex * 16.83f + (float)this.lineIndex * 0.75f;
                float partial = cycle % 1.0f;
                int cyclingGlyph = this.section.cyclingOptions[(int)cycle % this.section.cyclingOptions.length].charAt(0);
                glyph = this.paused ? cyclingGlyph : (partial > 0.5f ? (partial > 0.75f ? 95 : 45) : cyclingGlyph);
                if (canDim) {
                    dim = true;
                }
            }
            class_379 glyphinfo = this.fontSet.method_2011(glyph, false);
            float glyphWidth = glyphinfo.method_16798(false);
            if (!this.section.renderCharsIndividually() && this.section.spinning[0]) {
                int n = ticks % 3 == 0 ? (glyphWidth == 6.0f ? 45 : (glyphWidth == 1.0f ? 39 : glyph)) : (glyph = glyph);
                int n2 = ticks % 3 == 2 ? (glyphWidth == 6.0f ? 95 : (glyphWidth == 1.0f ? 46 : glyph)) : (glyph = glyph);
                if (canDim && ticks % 3 != 1) {
                    dim = true;
                }
            }
            class_382 bakedglyph = style.method_10987() && glyph != 32 ? this.fontSet.method_2013(glyphinfo) : this.fontSet.method_2014(glyph);
            int drawColor = this.a;
            drawColor = textcolor != null ? (drawColor |= textcolor.method_27716()) : (dim ? (drawColor |= this.r * 192 >> 8 << 16 | this.g * 192 >> 8 << 8 | this.b * 192 >> 8) : (drawColor |= this.color));
            float f = standardWidth = this.section.wideFlaps ? 9.0f : 7.0f;
            if (this.section.renderCharsIndividually()) {
                this.x += (standardWidth - glyphWidth) / 2.0f;
            }
            if (this.isNotEmpty(bakedglyph)) {
                class_4588 vertexconsumer = this.bufferSource.getBuffer(this.renderTypeOf(bakedglyph));
                bakedglyph.method_2025(style.method_10966(), this.x, 0.0f, 0.0f, this.pose, vertexconsumer, drawColor, false, this.light);
            }
            this.x = this.section.renderCharsIndividually() ? (this.x += standardWidth - (standardWidth - glyphWidth) / 2.0f) : (this.x += glyphWidth);
            return true;
        }

        public float finish(int bgColor) {
            if (bgColor == 0) {
                return this.x;
            }
            class_382 bakedglyph = this.fontSet.method_22943();
            class_4588 vertexconsumer = this.bufferSource.getBuffer(this.renderTypeOf(bakedglyph));
            bakedglyph.method_22944(new class_382.class_328(-1.0f, -2.0f, this.section.getSize(), 9.0f, 0.01f, bgColor, 0, 0.0f), this.pose, vertexconsumer, this.light, true);
            return this.x;
        }

        private class_1921 renderTypeOf(class_382 bakedglyph) {
            return bakedglyph.method_24045(class_327.class_6415.field_33993);
        }

        private boolean isNotEmpty(class_382 bakedglyph) {
            return !(bakedglyph instanceof class_384);
        }
    }
}

