/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.logistics.depot;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.ShaftRenderer;
import com.zurrtum.create.client.content.logistics.depot.DepotRenderer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.lib.transform.PoseTransformStack;
import com.zurrtum.create.client.flywheel.lib.transform.Rotate;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.flywheel.lib.transform.Translate;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.logistics.depot.DepotBehaviour;
import com.zurrtum.create.content.logistics.depot.EjectorBlock;
import com.zurrtum.create.content.logistics.depot.EjectorBlockEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2769;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;

@Environment(value=EnvType.CLIENT)
public class EjectorRenderer
extends ShaftRenderer<EjectorBlockEntity> {
    static final class_243 pivot = VecHelper.voxelSpace(0.0, 11.25, 0.75);

    public EjectorRenderer(class_5614.class_5615 context) {
        super(context);
    }

    public boolean method_3563() {
        return true;
    }

    @Override
    protected void renderSafe(EjectorBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        super.renderSafe(be, partialTicks, ms, buffer, light, overlay);
        float lidProgress = be.getLidProgress(partialTicks);
        float angle = lidProgress * 70.0f;
        if (!VisualizationManager.supportsVisualization((class_1936)be.method_10997())) {
            SuperByteBuffer model = CachedBuffers.partial(AllPartialModels.EJECTOR_TOP, be.method_11010());
            EjectorRenderer.applyLidAngle(be, angle, model);
            model.light(light).renderInto(ms, buffer.getBuffer(class_1921.method_23577()));
        }
        PoseTransformStack msr = TransformStack.of(ms);
        DepotBehaviour behaviour = be.getBehaviour(DepotBehaviour.TYPE);
        if (behaviour == null || behaviour.isEmpty()) {
            return;
        }
        ms.method_22903();
        EjectorRenderer.applyLidAngle(be, angle, msr);
        ((PoseTransformStack)((PoseTransformStack)msr.center()).rotateYDegrees(-180.0f - AngleHelper.horizontalAngle((class_2350)be.method_11010().method_11654((class_2769)EjectorBlock.HORIZONTAL_FACING)))).uncenter();
        DepotRenderer.renderItemsOf(be, partialTicks, ms, buffer, light, overlay, behaviour);
        ms.method_22909();
    }

    static <T extends Translate<T> & Rotate<T>> void applyLidAngle(KineticBlockEntity be, float angle, T tr) {
        EjectorRenderer.applyLidAngle(be, pivot, angle, tr);
    }

    static <T extends Translate<T> & Rotate<T>> void applyLidAngle(KineticBlockEntity be, class_243 rotationOffset, float angle, T tr) {
        ((Translate)((Rotate)((Translate)((Rotate)tr.center()).rotateYDegrees(180.0f + AngleHelper.horizontalAngle((class_2350)be.method_11010().method_11654((class_2769)EjectorBlock.HORIZONTAL_FACING)))).uncenter().translate(rotationOffset)).rotateXDegrees(-angle)).translateBack(rotationOffset);
    }
}

