/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render.renderer.generic;

import com.google.common.cache.CacheBuilder;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.Logger;

public class RenderBoxArrayCache {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    public static final int ARRAY_LENGTH_WIDTH = 24;
    public static final int ARRAY_ID_WIDTH = 8;
    public static final int ARRAY_LENGTH_OFFSET = 0;
    public static final int ARRAY_ID_OFFSET = 24;
    public static final int ARRAY_LENGTH_MASK = (int)Math.pow(2.0, 24.0) - 1;
    public static final int ARRAY_ID_MASK = (int)Math.pow(2.0, 8.0) - 1;
    private static final ConcurrentMap<Integer, float[]> FLOAT_ARRAY_BY_KEY = CacheBuilder.newBuilder().maximumSize(512L).removalListener(notification -> {}).build().asMap();
    private static final ConcurrentMap<Integer, int[]> INT_ARRAY_BY_KEY = CacheBuilder.newBuilder().maximumSize(512L).removalListener(notification -> {}).build().asMap();

    public static float[] getCachedFloatArray(int length, int id) {
        int key = RenderBoxArrayCache.encodeKey(length, id);
        return FLOAT_ARRAY_BY_KEY.computeIfAbsent(key, newKey -> {
            int newLength = RenderBoxArrayCache.getLengthFromKey(newKey);
            return new float[newLength];
        });
    }

    public static int[] getCachedIntArray(int length, int id) {
        int key = RenderBoxArrayCache.encodeKey(length, id);
        return INT_ARRAY_BY_KEY.computeIfAbsent(key, newKey -> {
            int newLength = RenderBoxArrayCache.getLengthFromKey(newKey);
            return new int[newLength];
        });
    }

    private static int encodeKey(int arrayLength, int id) {
        if (id > 127) {
            throw new IndexOutOfBoundsException("The array's ID can only be 8 bytes long.");
        }
        int data = 0;
        data |= arrayLength & ARRAY_LENGTH_MASK;
        return data |= (id & ARRAY_ID_MASK) << 24;
    }

    private static int getLengthFromKey(int key) {
        return key & ARRAY_LENGTH_MASK;
    }

    private static int getIdFromKey(int key) {
        return key >> 24 & ARRAY_ID_MASK;
    }
}

