/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render.glObject;

import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.render.glObject.GLEnums;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftGLWrapper;
import org.lwjgl.opengl.GL32;

public class GLState {
    private static final IMinecraftGLWrapper GLMC = SingletonInjector.INSTANCE.get(IMinecraftGLWrapper.class);
    private static final int FBO_MAX = 4;
    public int program;
    public int vao;
    public int vbo;
    public int ebo;
    public int fbo;
    public int texture2D;
    public int activeTextureNumber;
    public int texture0;
    public int texture1;
    public int texture2;
    public int texture3;
    public int frameBufferTexture0;
    public int frameBufferTexture1;
    public int frameBufferDepthTexture;
    public boolean blend;
    public boolean scissor;
    public int blendEqRGB;
    public int blendEqAlpha;
    public int blendSrcColor;
    public int blendSrcAlpha;
    public int blendDstColor;
    public int blendDstAlpha;
    public boolean depth;
    public boolean writeToDepthBuffer;
    public int depthFunc;
    public boolean stencil;
    public int stencilFunc;
    public int stencilRef;
    public int stencilMask;
    public int[] view;
    public boolean cull;
    public int cullMode;
    public int polyMode;

    public GLState() {
        this.saveState();
    }

    public void saveState() {
        this.program = GL32.glGetInteger((int)35725);
        this.vao = GL32.glGetInteger((int)34229);
        this.vbo = GL32.glGetInteger((int)34964);
        this.ebo = GL32.glGetInteger((int)34965);
        this.fbo = GL32.glGetInteger((int)36006);
        this.texture2D = GL32.glGetInteger((int)32873);
        this.activeTextureNumber = GL32.glGetInteger((int)34016);
        GLMC.glActiveTexture(33984);
        this.texture0 = GL32.glGetInteger((int)32873);
        GLMC.glActiveTexture(33985);
        this.texture1 = GL32.glGetInteger((int)32873);
        GLMC.glActiveTexture(33986);
        this.texture2 = GL32.glGetInteger((int)32873);
        GLMC.glActiveTexture(33987);
        this.texture3 = GL32.glGetInteger((int)32873);
        GLMC.glActiveTexture(this.activeTextureNumber);
        if (this.fbo != 0) {
            this.frameBufferTexture0 = GL32.glGetFramebufferAttachmentParameteri((int)36160, (int)36064, (int)36049);
            this.frameBufferTexture1 = GL32.glGetFramebufferAttachmentParameteri((int)36160, (int)36065, (int)36049);
            this.frameBufferDepthTexture = GL32.glGetFramebufferAttachmentParameteri((int)36160, (int)36096, (int)36049);
        } else {
            this.frameBufferTexture0 = 0;
            this.frameBufferTexture1 = 0;
            this.frameBufferDepthTexture = 0;
        }
        this.blend = GL32.glIsEnabled((int)3042);
        this.scissor = GL32.glIsEnabled((int)3089);
        this.blendEqRGB = GL32.glGetInteger((int)32777);
        this.blendEqAlpha = GL32.glGetInteger((int)34877);
        this.blendSrcColor = GL32.glGetInteger((int)32969);
        this.blendSrcAlpha = GL32.glGetInteger((int)32971);
        this.blendDstColor = GL32.glGetInteger((int)32968);
        this.blendDstAlpha = GL32.glGetInteger((int)32970);
        this.depth = GL32.glIsEnabled((int)2929);
        this.writeToDepthBuffer = GL32.glGetInteger((int)2930) == 1;
        this.depthFunc = GL32.glGetInteger((int)2932);
        this.stencil = GL32.glIsEnabled((int)2960);
        this.stencilFunc = GL32.glGetInteger((int)2962);
        this.stencilRef = GL32.glGetInteger((int)2967);
        this.stencilMask = GL32.glGetInteger((int)2963);
        this.view = new int[4];
        GL32.glGetIntegerv((int)2978, (int[])this.view);
        this.cull = GL32.glIsEnabled((int)2884);
        this.cullMode = GL32.glGetInteger((int)2885);
        this.polyMode = GL32.glGetInteger((int)2880);
    }

    public String toString() {
        return "GLState{program=" + this.program + ", vao=" + this.vao + ", vbo=" + this.vbo + ", ebo=" + this.ebo + ", fbo=" + this.fbo + ", text=" + GLEnums.getString(this.texture2D) + "@" + this.activeTextureNumber + ", text0=" + GLEnums.getString(this.texture0) + ", FB text0=" + this.frameBufferTexture0 + ", FB text1=" + this.frameBufferTexture1 + ", FB depth=" + this.frameBufferDepthTexture + ", blend=" + this.blend + ", scissor=" + this.scissor + ", blendMode=" + GLEnums.getString(this.blendSrcColor) + "," + GLEnums.getString(this.blendDstColor) + ", depth=" + this.depth + ", depthFunc=" + GLEnums.getString(this.depthFunc) + ", stencil=" + this.stencil + ", stencilFunc=" + GLEnums.getString(this.stencilFunc) + ", stencilRef=" + this.stencilRef + ", stencilMask=" + this.stencilMask + ", view={x:" + this.view[0] + ", y:" + this.view[1] + ", w:" + this.view[2] + ", h:" + this.view[3] + "}, cull=" + this.cull + ", cullMode=" + GLEnums.getString(this.cullMode) + ", polyMode=" + GLEnums.getString(this.polyMode) + '}';
    }

    public void restore() {
        GLMC.glBindFramebuffer(36160, 0);
        boolean frameBufferSet = false;
        if (this.fbo != 0 && GL32.glIsFramebuffer((int)this.fbo)) {
            GLMC.glBindFramebuffer(36160, this.fbo);
            frameBufferSet = true;
        }
        if (this.blend) {
            GLMC.enableBlend();
        } else {
            GLMC.disableBlend();
        }
        if (this.scissor) {
            GLMC.enableScissorTest();
        } else {
            GLMC.disableScissorTest();
        }
        GLMC.glActiveTexture(33984);
        GLMC.glBindTexture(GL32.glIsTexture((int)this.texture0) ? this.texture0 : 0);
        GLMC.glActiveTexture(33985);
        GLMC.glBindTexture(GL32.glIsTexture((int)this.texture1) ? this.texture1 : 0);
        GLMC.glActiveTexture(33986);
        GLMC.glBindTexture(GL32.glIsTexture((int)this.texture2) ? this.texture2 : 0);
        GLMC.glActiveTexture(33987);
        GLMC.glBindTexture(GL32.glIsTexture((int)this.texture3) ? this.texture3 : 0);
        GLMC.glActiveTexture(this.activeTextureNumber);
        GLMC.glBindTexture(GL32.glIsTexture((int)this.texture2D) ? this.texture2D : 0);
        if (frameBufferSet) {
            GL32.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.frameBufferTexture0, (int)0);
            GL32.glFramebufferTexture2D((int)36160, (int)36065, (int)3553, (int)this.frameBufferTexture1, (int)0);
            GL32.glFramebufferTexture2D((int)36160, (int)36096, (int)3553, (int)this.frameBufferDepthTexture, (int)0);
        }
        GL32.glBindVertexArray((int)(GL32.glIsVertexArray((int)this.vao) ? this.vao : 0));
        GL32.glBindBuffer((int)34962, (int)(GL32.glIsBuffer((int)this.vbo) ? this.vbo : 0));
        GL32.glBindBuffer((int)34963, (int)(GL32.glIsBuffer((int)this.ebo) ? this.ebo : 0));
        GL32.glUseProgram((int)(GL32.glIsProgram((int)this.program) ? this.program : 0));
        if (this.writeToDepthBuffer) {
            GLMC.enableDepthMask();
        } else {
            GLMC.disableDepthMask();
        }
        GLMC.glBlendFunc(this.blendSrcColor, this.blendDstColor);
        GL32.glBlendEquationSeparate((int)this.blendEqRGB, (int)this.blendEqAlpha);
        GLMC.glBlendFuncSeparate(this.blendSrcColor, this.blendDstColor, this.blendSrcAlpha, this.blendDstAlpha);
        if (this.depth) {
            GLMC.enableDepthTest();
        } else {
            GLMC.disableDepthTest();
        }
        GLMC.glDepthFunc(this.depthFunc);
        if (this.stencil) {
            GL32.glEnable((int)2960);
        } else {
            GL32.glDisable((int)2960);
        }
        GL32.glStencilFunc((int)this.stencilFunc, (int)this.stencilRef, (int)this.stencilMask);
        GL32.glViewport((int)this.view[0], (int)this.view[1], (int)this.view[2], (int)this.view[3]);
        if (this.cull) {
            GLMC.enableFaceCulling();
        } else {
            GLMC.disableFaceCulling();
        }
        GL32.glCullFace((int)this.cullMode);
        GL32.glPolygonMode((int)1032, (int)this.polyMode);
    }
}

