/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import me.chrr.camerapture.config.DeprecatedConfigOption;

public class Config {
    public static Config DEFAULT = new Config();
    public Client client = new Client();
    public Server server = new Server();

    public static class Client {
        public int version = 3;
        public boolean cachePictures = false;
        public boolean saveScreenshot = false;
        public boolean simpleCameraHud = false;
        public float zoomMouseSensitivity = 0.5f;

        public void upgrade() {
            this.version = Config.DEFAULT.client.version;
        }
    }

    public static class Server {
        public int version = 5;
        public int maxImageBytes = 500000;
        public int maxImageResolution = 1920;
        public int msPerPicture = 20;
        public boolean canRotatePictures = true;
        public boolean checkFramePosition = false;
        public PermissionLevels permissionLevels = new PermissionLevels();
        @DeprecatedConfigOption
        private boolean allowUploading = true;

        public void upgrade() {
            if (this.version < 5) {
                this.permissionLevels.upload = this.allowUploading ? 0 : 4;
            }
            this.version = Config.DEFAULT.server.version;
        }

        public static class PermissionLevels {
            public static Codec<PermissionLevels> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("takePicture").forGetter(p -> p.takePicture), (App)Codec.INT.fieldOf("upload").forGetter(p -> p.upload)).apply((Applicative)instance, PermissionLevels::new));
            public int takePicture = 0;
            public int upload = 0;

            public PermissionLevels() {
            }

            public PermissionLevels(int takePicture, int upload) {
                this.takePicture = takePicture;
                this.upload = upload;
            }

            public String toString() {
                return "{takePicture=" + this.takePicture + ", upload=" + this.upload + "}";
            }
        }
    }
}

