/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.blockentity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_3542;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import reborncore.api.recipe.IRecipeCrafterProvider;
import reborncore.common.blockentity.MachineBaseBlockEntity;

public record RedstoneConfiguration(Map<Element, State> stateMap) {
    public static class_1799 powerStack = new class_1799((class_1935)class_1802.field_8184);
    public static class_1799 fluidStack = new class_1799((class_1935)class_1802.field_8550);
    public static final MapCodec<RedstoneConfiguration> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.unboundedMap(Element.CODEC, State.CODEC).fieldOf("elements").forGetter(RedstoneConfiguration::stateMap)).apply((Applicative)instance, RedstoneConfiguration::new));
    private static final class_9139<ByteBuf, Map<Element, State>> STATE_MAP_CODEC = class_9135.method_56377(HashMap::new, Element.PACKET_CODEC, State.PACKET_CODEC);
    public static final class_9139<ByteBuf, RedstoneConfiguration> PACKET_CODEC = STATE_MAP_CODEC.method_56432(RedstoneConfiguration::new, RedstoneConfiguration::stateMap);

    public RedstoneConfiguration() {
        this(Collections.emptyMap());
    }

    public static List<Element> getValidElements(MachineBaseBlockEntity blockEntity) {
        return Element.ELEMENTS.stream().filter(element -> element.isApplicable(blockEntity)).collect(Collectors.toList());
    }

    public State getState(Element element) {
        State state = this.stateMap.get(element);
        if (state == null) {
            return State.IGNORED;
        }
        return state;
    }

    public RedstoneConfiguration withState(Element element, State state) {
        HashMap<Element, State> elements = new HashMap<Element, State>(this.stateMap);
        elements.put(element, state);
        return new RedstoneConfiguration(Collections.unmodifiableMap(elements));
    }

    public boolean isActive(Element element, MachineBaseBlockEntity blockEntity) {
        State state = this.getState(element);
        if (state == State.IGNORED) {
            return true;
        }
        boolean hasRedstonePower = blockEntity.method_10997().method_49803(blockEntity.method_11016());
        boolean enabledState = state == State.ENABLED_ON;
        return enabledState == hasRedstonePower;
    }

    public record Element(String name, Predicate<MachineBaseBlockEntity> isApplicable, Supplier<class_1799> icon) implements class_3542
    {
        public static Element ITEM_IO = new Element("item_io", () -> new class_1799((class_1935)class_2246.field_10312));
        public static Element POWER_IO = new Element("power_io", () -> powerStack);
        public static Element FLUID_IO = new Element("fluid_io", type -> type.getTank() != null, () -> fluidStack);
        public static Element RECIPE_PROCESSING = new Element("recipe_processing", type -> type instanceof IRecipeCrafterProvider, () -> new class_1799((class_1935)class_2246.field_9980));
        private static final List<Element> ELEMENTS = List.of(ITEM_IO, POWER_IO, FLUID_IO, RECIPE_PROCESSING);
        private static final Map<String, Element> ELEMENT_MAP = ELEMENTS.stream().collect(Collectors.toMap(Element::name, Function.identity()));
        public static final Codec<Element> CODEC = class_3542.method_53955(() -> (Element[])ELEMENTS.toArray(Element[]::new));
        public static final class_9139<ByteBuf, Element> PACKET_CODEC = class_9135.field_48554.method_56432(ELEMENT_MAP::get, Element::name);

        public Element(String name, Supplier<class_1799> icon) {
            this(name, be -> true, icon);
        }

        public boolean isApplicable(MachineBaseBlockEntity blockEntity) {
            return this.isApplicable.test(blockEntity);
        }

        public String method_15434() {
            return this.name;
        }
    }

    public static enum State implements class_3542
    {
        IGNORED,
        ENABLED_ON,
        ENABLED_OFF;

        public static final Codec<State> CODEC;
        public static final class_9139<ByteBuf, State> PACKET_CODEC;

        public String method_15434() {
            return this.name();
        }

        static {
            CODEC = class_3542.method_28140(State::values);
            PACKET_CODEC = class_9135.field_49675.method_56432(integer -> State.values()[integer], Enum::ordinal);
        }
    }
}

