/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.integration;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_7225;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiControlDistHandler;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.integration.IGuiIntegratedParent;
import team.creative.creativecore.common.gui.manager.GuiManager;
import team.creative.creativecore.common.gui.manager.GuiManagerDist;
import team.creative.creativecore.common.gui.packet.LayerClosePacket;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.creativecore.common.util.math.geo.Rect;

public class ContainerIntegration
extends class_1703
implements IGuiIntegratedParent {
    public static GuiLayer EMPTY_CLIENT;
    public static GuiLayer EMPTY_SERVER;
    private List<GuiLayer> layers = new ArrayList<GuiLayer>();
    private final class_1657 player;
    private IGuiIntegratedParent screen;

    public ContainerIntegration(class_3917<ContainerIntegration> type, int id, class_1657 player, GuiLayer layer) {
        super(type, id);
        this.player = player;
        layer.setParent(this);
        this.layers.add(layer);
    }

    public ContainerIntegration(class_3917<ContainerIntegration> type, int id, class_1657 player) {
        super(type, id);
        this.player = player;
    }

    public void setScreen(IGuiIntegratedParent screen) {
        this.screen = screen;
    }

    public void method_7623() {
        super.method_7623();
        this.tick();
    }

    public void tick() {
        for (GuiLayer layer : this.layers) {
            layer.tick();
        }
    }

    @Override
    public List<GuiLayer> getLayers() {
        return this.layers;
    }

    @Override
    public GuiLayer getTopLayer() {
        if (this.layers.isEmpty()) {
            return this.isClient() ? EMPTY_CLIENT : EMPTY_SERVER;
        }
        return this.layers.get(this.layers.size() - 1);
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    public void method_7595(class_1657 playerIn) {
        super.method_7595(playerIn);
        for (GuiLayer layer : this.layers) {
            layer.closed();
        }
    }

    public boolean method_7597(class_1657 playerIn) {
        return true;
    }

    @Override
    public class_1657 getPlayer() {
        return this.player;
    }

    @Override
    public boolean isClient() {
        return this.player.method_37908().field_9236;
    }

    @Override
    public void openLayer(GuiLayer layer) {
        layer.setParent(this);
        this.layers.add(layer);
        layer.init();
    }

    @Override
    public void closeTopLayer() {
        int index = this.layers.size() - 1;
        if (index != -1) {
            this.closeLayer(index);
        }
    }

    @Override
    public void closeLayer(GuiLayer layer) {
        int index = this.layers.indexOf(layer);
        if (index != -1) {
            this.closeLayer(index);
        }
    }

    @Override
    public void closeLayer(int layer) {
        for (int i = layer; i < this.layers.size(); ++i) {
            this.layers.get(i).closed();
        }
        this.send(new LayerClosePacket(layer));
        this.layers = this.layers.subList(0, layer);
        if (this.layers.isEmpty()) {
            if (this.isClient()) {
                class_310.method_1551().method_1507(null);
            } else {
                ((class_3222)this.player).method_7346();
            }
        } else {
            this.getTopLayer().becameTopLayer();
        }
    }

    @Override
    public void send(CreativePacket packet) {
        if (this.isClient()) {
            CreativeCore.NETWORK.sendToServer(packet);
        } else {
            CreativeCore.NETWORK.sendToClient(packet, (class_3222)this.player);
        }
    }

    public class_1799 method_7601(class_1657 p_38941_, int p_38942_) {
        return null;
    }

    @Override
    public class_7225.class_7874 provider() {
        return this.player.method_56673();
    }

    @Override
    public GuiControlDistHandler createDist(GuiControl control) {
        return (this.isClient() ? GuiLayer.CLIENT : GuiLayer.SERVER).createDist(control);
    }

    @Override
    public <T extends GuiManagerDist> T createDist(GuiManager<T> manager) {
        return (this.isClient() ? GuiLayer.CLIENT : GuiLayer.SERVER).createDist(manager);
    }

    @Override
    public Rect toScreenRect(GuiControl control, Rect rect) {
        if (this.screen != null) {
            return this.screen.toScreenRect(control, rect);
        }
        throw new UnsupportedOperationException();
    }

    static {
        EMPTY_SERVER = new GuiLayer(false, "empty"){

            @Override
            public void create() {
            }
        };
    }
}

