/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blockentity.machine.iron;

import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_9135;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.crafting.RebornRecipe;
import reborncore.common.crafting.RecipeUtils;
import reborncore.common.crafting.SizedIngredient;
import reborncore.common.screen.BuiltScreenHandler;
import reborncore.common.screen.BuiltScreenHandlerProvider;
import reborncore.common.screen.builder.ScreenHandlerBuilder;
import reborncore.common.util.RebornInventory;
import techreborn.blockentity.machine.iron.AbstractIronMachineBlockEntity;
import techreborn.config.TechRebornConfig;
import techreborn.init.ModRecipes;
import techreborn.init.TRBlockEntities;
import techreborn.init.TRContent;

public class IronAlloyFurnaceBlockEntity
extends AbstractIronMachineBlockEntity
implements BuiltScreenHandlerProvider {
    public static final int INPUT_SLOT_1 = 0;
    public static final int INPUT_SLOT_2 = 1;
    public static final int OUTPUT_SLOT = 2;
    public static final int FUEL_SLOT = 3;
    public int recipeCookingTime = 200;

    public IronAlloyFurnaceBlockEntity(class_2338 pos, class_2680 state) {
        super(TRBlockEntities.IRON_ALLOY_FURNACE, pos, state, 3, TRContent.Machine.IRON_ALLOY_FURNACE.block);
        this.inventory = new RebornInventory(4, "IronAlloyFurnaceBlockEntity", 64, (MachineBaseBlockEntity)this);
    }

    public boolean hasAllInputs(RebornRecipe recipeType) {
        if (recipeType == null) {
            return false;
        }
        for (SizedIngredient ingredient : recipeType.ingredients()) {
            boolean hasItem = false;
            for (int inputSlot = 0; inputSlot < 2; ++inputSlot) {
                if (!ingredient.test(this.inventory.method_5438(inputSlot))) continue;
                hasItem = true;
            }
            if (hasItem) continue;
            return false;
        }
        return true;
    }

    private RebornRecipe getRecipe() {
        for (RebornRecipe recipeType : RecipeUtils.getRecipes((class_1937)this.field_11863, ModRecipes.ALLOY_SMELTER)) {
            if (!this.hasAllInputs(recipeType)) continue;
            return recipeType;
        }
        return null;
    }

    @Override
    protected boolean canSmelt() {
        if (this.inventory.method_5438(0).method_7960() || this.inventory.method_5438(1).method_7960()) {
            return false;
        }
        class_1799 itemstack = null;
        for (RebornRecipe recipeType : RecipeUtils.getRecipes((class_1937)this.field_11863, ModRecipes.ALLOY_SMELTER)) {
            if (!this.hasAllInputs(recipeType)) continue;
            List outputs = recipeType.outputs();
            this.recipeCookingTime = recipeType.time();
            if (outputs.isEmpty()) continue;
            itemstack = (class_1799)outputs.get(0);
            break;
        }
        if (itemstack == null) {
            return false;
        }
        if (this.inventory.method_5438(2).method_7960()) {
            return true;
        }
        if (!this.inventory.method_5438(2).method_31574(itemstack.method_7909())) {
            return false;
        }
        int result = this.inventory.method_5438(2).method_7947() + itemstack.method_7947();
        return result <= this.inventory.getStackLimit() && result <= this.inventory.method_5438(2).method_7914();
    }

    @Override
    protected void smelt() {
        if (!this.canSmelt()) {
            return;
        }
        RebornRecipe currentRecipe = this.getRecipe();
        if (currentRecipe == null) {
            return;
        }
        class_1799 outputStack = (class_1799)currentRecipe.outputs().get(0);
        if (outputStack.method_7960()) {
            return;
        }
        if (this.inventory.method_5438(2).method_7960()) {
            this.inventory.method_5447(2, outputStack.method_7972());
        } else if (this.inventory.method_5438(2).method_7909() == outputStack.method_7909()) {
            this.inventory.shrinkSlot(2, -outputStack.method_7947());
        }
        block0: for (SizedIngredient ingredient : currentRecipe.ingredients()) {
            for (int inputSlot = 0; inputSlot < 2; ++inputSlot) {
                if (!ingredient.test(this.inventory.method_5438(inputSlot))) continue;
                this.inventory.shrinkSlot(inputSlot, ingredient.count());
                continue block0;
            }
        }
    }

    @Override
    protected int cookingTime() {
        return (int)((double)this.recipeCookingTime / TechRebornConfig.cookingScale);
    }

    public int getRecipeCookingTime() {
        return this.recipeCookingTime;
    }

    public void setRecipeCookingTime(int recipeCookingTime) {
        this.recipeCookingTime = recipeCookingTime;
    }

    public BuiltScreenHandler createScreenHandler(int syncID, class_1657 player) {
        return new ScreenHandlerBuilder("alloyfurnace").player(player.method_31548()).inventory().hotbar().addInventory().blockEntity((class_2586)this).slot(0, 47, 17).slot(1, 65, 17).outputSlot(2, 116, 35).fuelSlot(3, 56, 53).sync(class_9135.field_49675, this::getBurnTime, this::setBurnTime).sync(class_9135.field_49675, this::getProgress, this::setProgress).sync(class_9135.field_49675, this::getTotalBurnTime, this::setTotalBurnTime).sync(class_9135.field_49675, this::getRecipeCookingTime, this::setRecipeCookingTime).addInventory().create((MachineBaseBlockEntity)this, syncID);
    }

    public boolean isStackValid(int slotID, class_1799 stack) {
        return RecipeUtils.getRecipes((class_1937)this.field_11863, ModRecipes.ALLOY_SMELTER).stream().anyMatch(rebornRecipe -> rebornRecipe.ingredients().stream().anyMatch(ingredient -> ingredient.test(stack)));
    }

    public int[] getInputSlots() {
        return new int[]{0, 1};
    }
}

