/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.infrastructure.transfer;

import com.google.common.collect.MapMaker;
import com.zurrtum.create.infrastructure.fluids.FluidInventory;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import com.zurrtum.create.infrastructure.transfer.FluidInventoryStorageImpl;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.impl.transfer.DebugMessages;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_9326;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public interface FluidInventoryStorage
extends SlottedStorage<FluidVariant> {
    public static final Map<FluidVariant, FluidStack> CACHE = new MapMaker().weakKeys().makeMap();

    public static FluidStack getCachedStack(FluidVariant variant) {
        return CACHE.computeIfAbsent(variant, FluidInventoryStorage::toStack);
    }

    public static FluidStack toStack(FluidVariant variant) {
        return new FluidStack(variant.getFluid(), 1, variant.getComponents());
    }

    public static FluidInventoryStorage of(FluidInventory inventory) {
        Objects.requireNonNull(inventory, "Null fluid inventory is not supported.");
        return FluidInventoryStorageImpl.of(inventory);
    }

    public static FluidInventoryStorage of(FluidInventory inventory, @Nullable class_2350 direction) {
        Objects.requireNonNull(inventory, "Null fluid inventory is not supported.");
        return FluidInventoryStorageImpl.of(inventory, direction);
    }

    public static boolean matches(FluidVariant variant, FluidStack stack) {
        class_9326 variantComponents;
        if (!variant.isOf((Object)stack.getFluid())) {
            return false;
        }
        class_9326 stackComponents = stack.getComponentChanges();
        if (stackComponents == (variantComponents = variant.getComponents())) {
            return true;
        }
        return stackComponents.field_49591.reference2ObjectEntrySet().containsAll((Collection)variantComponents.field_49591.reference2ObjectEntrySet());
    }

    public @UnmodifiableView List<SingleSlotStorage<FluidVariant>> getSlots();

    default public int getSlotCount() {
        return this.getSlots().size();
    }

    default public SingleSlotStorage<FluidVariant> getSlot(int slot) {
        return this.getSlots().get(slot);
    }

    public static String toString(FluidInventory inventory) {
        if (inventory == null) {
            return "~~NULL~~";
        }
        Object result = inventory.toString();
        if (inventory instanceof class_2586) {
            class_2586 blockEntity = (class_2586)inventory;
            result = (String)result + " (%s, %s)".formatted(blockEntity.method_11010(), DebugMessages.forGlobalPos((class_1937)blockEntity.method_10997(), (class_2338)blockEntity.method_11016()));
        }
        return result;
    }
}

