/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.entity;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.ListBuilder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.Create;
import com.zurrtum.create.api.behaviour.movement.MovementBehaviour;
import com.zurrtum.create.api.contraption.storage.fluid.MountedFluidStorageWrapper;
import com.zurrtum.create.api.contraption.storage.item.MountedItemStorageWrapper;
import com.zurrtum.create.catnip.codecs.stream.CatnipLargerStreamCodecs;
import com.zurrtum.create.catnip.codecs.stream.CatnipStreamCodecBuilders;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.content.logistics.filter.FilterItemStack;
import com.zurrtum.create.content.trains.bogey.AbstractBogeyBlockEntity;
import com.zurrtum.create.content.trains.entity.Carriage;
import com.zurrtum.create.content.trains.entity.CarriageBogey;
import com.zurrtum.create.content.trains.entity.CarriageContraption;
import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;
import com.zurrtum.create.content.trains.entity.Navigation;
import com.zurrtum.create.content.trains.entity.TrainIconType;
import com.zurrtum.create.content.trains.entity.TrainMigration;
import com.zurrtum.create.content.trains.entity.TrainStatus;
import com.zurrtum.create.content.trains.entity.TravellingPoint;
import com.zurrtum.create.content.trains.graph.DimensionPalette;
import com.zurrtum.create.content.trains.graph.DiscoveredPath;
import com.zurrtum.create.content.trains.graph.EdgeData;
import com.zurrtum.create.content.trains.graph.EdgePointType;
import com.zurrtum.create.content.trains.graph.TrackEdge;
import com.zurrtum.create.content.trains.graph.TrackGraph;
import com.zurrtum.create.content.trains.graph.TrackGraphLocation;
import com.zurrtum.create.content.trains.graph.TrackNode;
import com.zurrtum.create.content.trains.observer.TrackObserver;
import com.zurrtum.create.content.trains.schedule.ScheduleRuntime;
import com.zurrtum.create.content.trains.signal.SignalBlock;
import com.zurrtum.create.content.trains.signal.SignalBoundary;
import com.zurrtum.create.content.trains.signal.SignalEdgeGroup;
import com.zurrtum.create.content.trains.station.GlobalStation;
import com.zurrtum.create.content.trains.station.StationBlockEntity;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import com.zurrtum.create.infrastructure.items.CombinedInvWrapper;
import com.zurrtum.create.infrastructure.packet.s2c.RemoveTrainPacket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2688;
import net.minecraft.class_3222;
import net.minecraft.class_3499;
import net.minecraft.class_3532;
import net.minecraft.class_4844;
import net.minecraft.class_5244;
import net.minecraft.class_5321;
import net.minecraft.class_8824;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9895;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;

public class Train {
    public static final class_9139<class_9129, Train> STREAM_CODEC = CatnipLargerStreamCodecs.composite(class_4844.field_48453, train -> train.id, CatnipStreamCodecBuilders.nullable(class_4844.field_48453), train -> train.owner, CatnipStreamCodecBuilders.list(Carriage.STREAM_CODEC), train -> train.carriages, CatnipStreamCodecBuilders.list(class_9135.field_48550), train -> train.carriageSpacing, class_9135.field_48547, train -> train.doubleEnded, class_8824.field_49668, train -> train.name, TrainIconType.STREAM_CODEC, train -> train.icon, class_9135.field_49675, train -> train.mapColorIndex, Train::new);
    public static final Random RANDOM = new Random();
    public double speed = 0.0;
    public double targetSpeed = 0.0;
    public Double speedBeforeStall = null;
    public int carriageWaitingForChunks = -1;
    public double throttle = 1.0;
    public boolean honk = false;
    public UUID id;
    @Nullable
    public UUID owner;
    public TrackGraph graph;
    public Navigation navigation;
    public ScheduleRuntime runtime;
    public TrainIconType icon;
    public int mapColorIndex;
    public class_2561 name;
    public TrainStatus status;
    public boolean invalid;
    public TravellingPoint.SteerDirection manualSteer;
    public boolean manualTick;
    public UUID currentStation;
    public boolean currentlyBackwards;
    public boolean doubleEnded;
    public List<Carriage> carriages;
    public List<Integer> carriageSpacing;
    public boolean updateSignalBlocks;
    public Map<UUID, UUID> occupiedSignalBlocks;
    public Set<UUID> reservedSignalBlocks;
    public Set<UUID> occupiedObservers;
    public Map<UUID, Pair<Integer, Boolean>> cachedObserverFiltering;
    List<TrainMigration> migratingPoints;
    public int migrationCooldown;
    public boolean derailed;
    public int fuelTicks;
    public int honkTicks;
    public Boolean lowHonk;
    public int honkPitch;
    public float accumulatedSteamRelease;
    int tickOffset;
    int ticksSinceLastMailTransfer;
    double[] stress;
    public class_1657 backwardsDriver;

    private Train(UUID id, UUID owner, List<Carriage> carriages, List<Integer> carriageSpacing, boolean doubleEnded, class_2561 name, TrainIconType icon, int mapColorIndex) {
        this(id, owner, null, carriages, carriageSpacing, doubleEnded, name, icon, mapColorIndex);
    }

    public Train(UUID id, UUID owner, TrackGraph graph, List<Carriage> carriages, List<Integer> carriageSpacing, boolean doubleEnded, int mapColorIndex) {
        this(id, owner, graph, carriages, carriageSpacing, doubleEnded, (class_2561)class_2561.method_43471((String)"create.train.unnamed"), TrainIconType.TRADITIONAL, mapColorIndex);
    }

    public Train(UUID id, UUID owner, TrackGraph graph, List<Carriage> carriages, List<Integer> carriageSpacing, boolean doubleEnded, class_2561 name, TrainIconType icon, int mapColorIndex) {
        this.id = id;
        this.owner = owner;
        this.graph = graph;
        this.carriages = carriages;
        this.carriageSpacing = carriageSpacing;
        this.icon = icon;
        this.mapColorIndex = mapColorIndex;
        this.stress = new double[carriageSpacing.size()];
        this.name = name;
        this.status = new TrainStatus(this);
        this.doubleEnded = doubleEnded;
        carriages.forEach(c -> c.setTrain(this));
        this.navigation = new Navigation(this);
        this.runtime = new ScheduleRuntime(this);
        this.migratingPoints = new ArrayList<TrainMigration>();
        this.currentStation = null;
        this.manualSteer = TravellingPoint.SteerDirection.NONE;
        this.occupiedSignalBlocks = new HashMap<UUID, UUID>();
        this.reservedSignalBlocks = new HashSet<UUID>();
        this.occupiedObservers = new HashSet<UUID>();
        this.cachedObserverFiltering = new HashMap<UUID, Pair<Integer, Boolean>>();
        this.tickOffset = RANDOM.nextInt(100);
    }

    public void earlyTick(class_1937 level) {
        this.status.tick(level);
        if (this.graph == null && !this.migratingPoints.isEmpty()) {
            this.reattachToTracks(level);
        }
        if (this.graph == null) {
            this.addToSignalGroups(this.occupiedSignalBlocks.keySet());
            return;
        }
        if (this.updateSignalBlocks) {
            this.updateSignalBlocks = false;
            this.collectInitiallyOccupiedSignalBlocks();
        }
        this.addToSignalGroups(this.occupiedSignalBlocks.keySet());
        this.addToSignalGroups(this.reservedSignalBlocks);
        if (this.occupiedObservers.isEmpty()) {
            return;
        }
        this.tickOccupiedObservers(level);
    }

    private void tickOccupiedObservers(class_1937 level) {
        int storageVersion = 0;
        for (Carriage carriage : this.carriages) {
            storageVersion += carriage.storage.getVersion();
        }
        for (UUID uuid : this.occupiedObservers) {
            TrackObserver observer = this.graph.getPoint(EdgePointType.OBSERVER, uuid);
            if (observer == null) continue;
            FilterItemStack filter = observer.getFilter();
            if (filter.isEmpty()) {
                observer.keepAlive(this);
                continue;
            }
            Pair cachedMatch = this.cachedObserverFiltering.computeIfAbsent(uuid, $ -> Pair.of(-1, false));
            boolean shouldActivate = (Boolean)cachedMatch.getSecond();
            if ((Integer)cachedMatch.getFirst() == storageVersion) {
                if (!shouldActivate) continue;
                observer.keepAlive(this);
                continue;
            }
            shouldActivate = false;
            for (Carriage carriage : this.carriages) {
                FluidStack find;
                class_1799 find2;
                CombinedInvWrapper inv = carriage.storage.getAllItems();
                if (inv != null && !(find2 = inv.count(stack -> filter.test(level, (class_1799)stack), 1)).method_7960()) {
                    shouldActivate = true;
                    break;
                }
                MountedFluidStorageWrapper tank = carriage.storage.getFluids();
                if (tank == null || (find = tank.count(stack -> filter.test(level, (FluidStack)stack), 1)).isEmpty()) continue;
                shouldActivate = true;
                break;
            }
            this.cachedObserverFiltering.put(uuid, Pair.of(storageVersion, shouldActivate));
            if (!shouldActivate) continue;
            observer.keepAlive(this);
        }
    }

    private void addToSignalGroups(Collection<UUID> groups) {
        Map<UUID, SignalEdgeGroup> groupMap = Create.RAILWAYS.signalEdgeGroups;
        Iterator<UUID> iterator = groups.iterator();
        while (iterator.hasNext()) {
            SignalEdgeGroup signalEdgeGroup = groupMap.get(iterator.next());
            if (signalEdgeGroup == null) {
                iterator.remove();
                continue;
            }
            signalEdgeGroup.trains.add(this);
        }
    }

    public void tick(class_1937 level) {
        Create.RAILWAYS.markTracksDirty();
        if (this.graph == null) {
            this.carriages.forEach(c -> c.manageEntities(level));
            this.updateConductors();
            return;
        }
        GlobalStation currentStation = this.getCurrentStation();
        if (currentStation != null) {
            ++this.ticksSinceLastMailTransfer;
            if (this.ticksSinceLastMailTransfer > 20) {
                currentStation.runMailTransfer();
                this.ticksSinceLastMailTransfer = 0;
            }
        }
        this.updateConductors();
        this.runtime.tick(level);
        this.navigation.tick(level);
        this.tickPassiveSlowdown();
        if (this.derailed) {
            this.tickDerailedSlowdown();
        }
        double distance = this.speed;
        Carriage previousCarriage = null;
        int carriageCount = this.carriages.size();
        boolean stalled = false;
        double maxStress = 0.0;
        if (this.carriageWaitingForChunks != -1) {
            distance = 0.0;
        }
        for (int i = 0; i < carriageCount; ++i) {
            Carriage carriage = this.carriages.get(i);
            if (previousCarriage != null) {
                int target = this.carriageSpacing.get(i - 1);
                double actual = target;
                TravellingPoint leadingPoint = carriage.getLeadingPoint();
                TravellingPoint trailingPoint = previousCarriage.getTrailingPoint();
                int entries = 0;
                double total = 0.0;
                if (leadingPoint.node1 != null && trailingPoint.node1 != null || leadingPoint.edge == null || trailingPoint.edge == null) {
                    class_5321<class_1937> d1 = leadingPoint.node1.getLocation().dimension;
                    class_5321<class_1937> d2 = trailingPoint.node1.getLocation().dimension;
                    for (boolean b : Iterate.trueAndFalse) {
                        class_5321<class_1937> d;
                        class_5321<class_1937> class_53212 = d = b ? d1 : d2;
                        if (!b && d1.equals(d2) || !d1.equals(d2)) continue;
                        Carriage.DimensionalCarriageEntity dimensional = carriage.getDimensionalIfPresent(d);
                        Carriage.DimensionalCarriageEntity dimensional2 = previousCarriage.getDimensionalIfPresent(d);
                        if (dimensional == null || dimensional2 == null) continue;
                        class_243 leadingAnchor = dimensional.leadingAnchor();
                        class_243 trailingAnchor = dimensional2.trailingAnchor();
                        if (leadingAnchor == null || trailingAnchor == null) continue;
                        double distanceTo = leadingAnchor.method_1025(trailingAnchor);
                        distanceTo = carriage.leadingBogey().isUpsideDown() != previousCarriage.trailingBogey().isUpsideDown() ? Math.sqrt(distanceTo - 4.0) : Math.sqrt(distanceTo);
                        total += distanceTo;
                        ++entries;
                    }
                }
                if (entries > 0) {
                    actual = total / (double)entries;
                }
                this.stress[i - 1] = (double)target - actual;
                maxStress = Math.max(maxStress, Math.abs((double)target - actual));
            }
            previousCarriage = carriage;
            if (!carriage.stalled) continue;
            if (this.speedBeforeStall == null) {
                this.speedBeforeStall = this.speed;
            }
            distance = 0.0;
            this.speed = 0.0;
            stalled = true;
        }
        if (!stalled && this.speedBeforeStall != null) {
            this.speed = class_3532.method_15350((double)this.speedBeforeStall, (double)-1.0, (double)1.0);
            this.speedBeforeStall = null;
        }
        boolean approachingStation = this.navigation.distanceToDestination < 5.0;
        double leadingModifier = approachingStation ? 0.75 : 0.5;
        double trailingModifier = approachingStation ? 0.0 : 0.125;
        boolean blocked = false;
        boolean iterateFromBack = this.speed < 0.0;
        for (int index = 0; index < carriageCount; ++index) {
            boolean last;
            double leadingStress;
            int i;
            int n = i = iterateFromBack ? carriageCount - 1 - index : index;
            double d = i == 0 ? 0.0 : (leadingStress = this.stress[i - 1] * -(iterateFromBack ? trailingModifier : leadingModifier));
            double trailingStress = i == this.stress.length ? 0.0 : this.stress[i] * (iterateFromBack ? leadingModifier : trailingModifier);
            Carriage carriage = this.carriages.get(i);
            TravellingPoint toFollowForward = i == 0 ? null : this.carriages.get(i - 1).getTrailingPoint();
            TravellingPoint toFollowBackward = i == carriageCount - 1 ? null : this.carriages.get(i + 1).getLeadingPoint();
            double totalStress = this.derailed ? 0.0 : leadingStress + trailingStress;
            boolean first = i == 0;
            boolean bl = last = i == carriageCount - 1;
            int carriageType = first ? (last ? 3 : 0) : (last ? 2 : 1);
            double actualDistance = carriage.travel(level, this.graph, distance + totalStress, toFollowForward, toFollowBackward, carriageType);
            blocked |= carriage.blocked || carriage.isOnIncompatibleTrack();
            boolean onTwoBogeys = carriage.isOnTwoBogeys();
            maxStress = Math.max(maxStress, onTwoBogeys ? (double)carriage.bogeySpacing - carriage.getAnchorDiff() : 0.0);
            maxStress = Math.max(maxStress, carriage.leadingBogey().getStress());
            if (onTwoBogeys) {
                maxStress = Math.max(maxStress, carriage.trailingBogey().getStress());
            }
            if (index != 0) continue;
            distance = actualDistance;
            this.collideWithOtherTrains(level, carriage);
            this.backwardsDriver = null;
            if (this.graph != null) continue;
            return;
        }
        if (blocked) {
            this.speed = 0.0;
            this.navigation.cancelNavigation();
            this.runtime.tick(level);
            this.status.endOfTrack();
        } else if (maxStress > 4.0) {
            this.speed = 0.0;
            this.navigation.cancelNavigation();
            this.runtime.tick(level);
            this.derailed = true;
            this.status.highStress();
        } else if (this.speed != 0.0) {
            this.status.trackOK();
        }
        this.updateNavigationTarget(level, distance);
    }

    public TravellingPoint.IEdgePointListener frontSignalListener() {
        return (distance, couple) -> {
            Object patt0$temp = couple.getFirst();
            if (patt0$temp instanceof GlobalStation) {
                GlobalStation station = (GlobalStation)patt0$temp;
                if (!station.canApproachFrom((TrackNode)((Couple)couple.getSecond()).getSecond()) || this.navigation.destination != station) {
                    return false;
                }
                this.speed = 0.0;
                this.navigation.distanceToDestination = 0.0;
                this.navigation.currentPath.clear();
                this.arriveAt(this.navigation.destination);
                this.navigation.destination = null;
                return true;
            }
            Object patt1$temp = couple.getFirst();
            if (patt1$temp instanceof TrackObserver) {
                TrackObserver observer = (TrackObserver)patt1$temp;
                this.occupiedObservers.add(observer.getId());
                return false;
            }
            Object patt2$temp = couple.getFirst();
            if (!(patt2$temp instanceof SignalBoundary)) {
                return false;
            }
            SignalBoundary signal = (SignalBoundary)patt2$temp;
            if (this.navigation.waitingForSignal != null && this.navigation.waitingForSignal.getFirst().equals(signal.getId())) {
                this.speed = 0.0;
                this.navigation.distanceToSignal = 0.0;
                return true;
            }
            UUID groupId = signal.getGroup((TrackNode)((Couple)couple.getSecond()).getSecond());
            SignalEdgeGroup signalEdgeGroup = Create.RAILWAYS.signalEdgeGroups.get(groupId);
            if (signalEdgeGroup == null) {
                return false;
            }
            if ((this.runtime.getSchedule() == null || this.runtime.paused) && signalEdgeGroup.isOccupiedUnless(this)) {
                this.carriages.forEach(c -> c.forEachPresentEntity(cce -> cce.getControllingPlayer().map(uuid -> {
                    class_3222 player;
                    class_1657 patt0$temp = cce.method_37908().method_18470(uuid);
                    return patt0$temp instanceof class_3222 ? (player = (class_3222)patt0$temp) : null;
                }).ifPresent(AllAdvancements.RED_SIGNAL::trigger)));
            }
            signalEdgeGroup.reserved = signal;
            this.occupy(groupId, signal.id);
            return false;
        };
    }

    public void cancelStall() {
        this.speedBeforeStall = null;
        this.carriages.forEach(c -> {
            c.stalled = false;
            c.forEachPresentEntity(cce -> cce.getContraption().getActors().forEach(pair -> {
                MovementBehaviour behaviour = MovementBehaviour.REGISTRY.get((class_2688<class_2248, ?>)((class_3499.class_3501)pair.getKey()).comp_1342());
                if (behaviour != null) {
                    behaviour.cancelStall((MovementContext)pair.getValue());
                }
            }));
        });
    }

    private boolean occupy(UUID groupId, @Nullable UUID boundaryId) {
        this.reservedSignalBlocks.remove(groupId);
        if (boundaryId != null && this.occupiedSignalBlocks.containsKey(groupId) && boundaryId.equals(this.occupiedSignalBlocks.get(groupId))) {
            return false;
        }
        return this.occupiedSignalBlocks.put(groupId, boundaryId) == null;
    }

    public TravellingPoint.IEdgePointListener backSignalListener() {
        return (distance, couple) -> {
            Object patt0$temp = couple.getFirst();
            if (patt0$temp instanceof TrackObserver) {
                TrackObserver observer = (TrackObserver)patt0$temp;
                this.occupiedObservers.remove(observer.getId());
                this.cachedObserverFiltering.remove(observer.getId());
                return false;
            }
            Object patt1$temp = couple.getFirst();
            if (!(patt1$temp instanceof SignalBoundary)) {
                return false;
            }
            SignalBoundary signal = (SignalBoundary)patt1$temp;
            UUID groupId = signal.getGroup((TrackNode)((Couple)couple.getSecond()).getFirst());
            this.occupiedSignalBlocks.remove(groupId);
            return false;
        };
    }

    private void updateNavigationTarget(class_1937 level, double distance) {
        DiscoveredPath preferredPath;
        if (this.navigation.destination == null) {
            return;
        }
        Pair<UUID, Boolean> blockingSignal = this.navigation.waitingForSignal;
        boolean fullRefresh = this.navigation.distanceToDestination > 100.0 && this.navigation.distanceToDestination % 100.0 > 20.0;
        boolean signalRefresh = blockingSignal != null && this.navigation.distanceToSignal % 50.0 > 5.0;
        boolean partialRefresh = this.navigation.distanceToDestination < 100.0 && this.navigation.distanceToDestination % 50.0 > 5.0;
        double toSubstract = this.navigation.destinationBehindTrain ? -distance : distance;
        boolean navigatingManually = this.runtime.paused;
        this.navigation.distanceToDestination -= toSubstract;
        if (blockingSignal != null) {
            this.navigation.distanceToSignal -= toSubstract;
            signalRefresh &= this.navigation.distanceToSignal % 50.0 < 5.0;
        }
        fullRefresh &= this.navigation.distanceToDestination % 100.0 <= 20.0;
        partialRefresh &= this.navigation.distanceToDestination % 50.0 <= 5.0;
        if (blockingSignal != null && this.navigation.ticksWaitingForSignal % 100 == 50) {
            SignalBoundary signal = this.graph.getPoint(EdgePointType.SIGNAL, blockingSignal.getFirst());
            fullRefresh |= signal != null && signal.types.get(blockingSignal.getSecond()) == SignalBlock.SignalType.CROSS_SIGNAL;
        }
        if (signalRefresh) {
            this.navigation.waitingForSignal = null;
        }
        if (!fullRefresh && !partialRefresh) {
            return;
        }
        if (!this.reservedSignalBlocks.isEmpty()) {
            return;
        }
        if (!navigatingManually && fullRefresh && (preferredPath = this.runtime.startCurrentInstruction(level)) != null) {
            this.navigation.startNavigation(preferredPath);
        }
    }

    private void tickDerailedSlowdown() {
        this.speed /= 3.0;
        if (class_3532.method_20390((double)this.speed, (double)0.0)) {
            this.speed = 0.0;
        }
    }

    private void tickPassiveSlowdown() {
        if (!this.manualTick && this.navigation.destination == null && this.speed != 0.0) {
            double acceleration = this.acceleration();
            this.speed = this.speed > 0.0 ? Math.max(this.speed - acceleration, 0.0) : Math.min(this.speed + acceleration, 0.0);
        }
        this.manualTick = false;
    }

    private void updateConductors() {
        for (Carriage carriage : this.carriages) {
            carriage.updateConductors();
        }
    }

    public boolean hasForwardConductor() {
        for (Carriage carriage : this.carriages) {
            if (!((Boolean)carriage.presentConductors.getFirst()).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean hasBackwardConductor() {
        for (Carriage carriage : this.carriages) {
            if (!((Boolean)carriage.presentConductors.getSecond()).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private void collideWithOtherTrains(class_1937 level, Carriage carriage) {
        class_243 end;
        if (this.derailed) {
            return;
        }
        TravellingPoint trailingPoint = carriage.getTrailingPoint();
        TravellingPoint leadingPoint = carriage.getLeadingPoint();
        if (leadingPoint.node1 == null || trailingPoint.node1 == null) {
            return;
        }
        class_5321<class_1937> dimension = leadingPoint.node1.getLocation().dimension;
        if (!dimension.equals(trailingPoint.node1.getLocation().dimension)) {
            return;
        }
        class_243 start = (this.speed < 0.0 ? trailingPoint : leadingPoint).getPosition(this.graph);
        Pair<Train, class_243> collision = this.findCollidingTrain(level, start, end = (this.speed < 0.0 ? leadingPoint : trailingPoint).getPosition(this.graph), dimension);
        if (collision == null) {
            return;
        }
        Train train = collision.getFirst();
        double combinedSpeed = Math.abs(this.speed) + Math.abs(train.speed);
        if (combinedSpeed > (double)0.2f) {
            class_243 v = collision.getSecond();
            level.method_8437(null, v.field_1352, v.field_1351, v.field_1350, (float)Math.min(3.0 * combinedSpeed, 5.0), class_1937.class_7867.field_40888);
        }
        this.crash();
        train.crash();
    }

    public Pair<Train, class_243> findCollidingTrain(class_1937 level, class_243 start, class_243 end, class_5321<class_1937> dimension) {
        class_243 diff = end.method_1020(start);
        double maxDistanceSqr = Math.pow(((Integer)AllConfigs.server().trains.maxAssemblyLength.get()).intValue(), 2.0);
        block0: for (Train train : Create.RAILWAYS.sided((class_1936)level).trains.values()) {
            if (train == this || train.graph != null && train.graph != this.graph) continue;
            class_243 lastPoint = null;
            for (Carriage otherCarriage : train.carriages) {
                for (boolean betweenBits : Iterate.trueAndFalse) {
                    class_243 normedDiff2;
                    class_5321<class_1937> otherDimension;
                    if (betweenBits && lastPoint == null) continue;
                    TravellingPoint otherLeading = otherCarriage.getLeadingPoint();
                    TravellingPoint otherTrailing = otherCarriage.getTrailingPoint();
                    if (otherLeading.edge == null || otherTrailing.edge == null || !(otherDimension = otherLeading.node1.getLocation().dimension).equals(otherTrailing.node1.getLocation().dimension) || !otherDimension.equals(dimension)) continue;
                    class_243 start2 = otherLeading.getPosition(train.graph);
                    class_243 end2 = otherTrailing.getPosition(train.graph);
                    if (Math.min(start2.method_1025(start), end2.method_1025(start)) > maxDistanceSqr) continue block0;
                    if (betweenBits) {
                        end2 = start2;
                        start2 = lastPoint;
                    }
                    lastPoint = end2;
                    if ((end.field_1351 < end2.field_1351 - 3.0 || end2.field_1351 < end.field_1351 - 3.0) && (start.field_1351 < start2.field_1351 - 3.0 || start2.field_1351 < start.field_1351 - 3.0)) continue;
                    class_243 diff2 = end2.method_1020(start2);
                    class_243 normedDiff = diff.method_1029();
                    double[] intersect = VecHelper.intersect(start, start2, normedDiff, normedDiff2 = diff2.method_1029(), class_2350.class_2351.field_11052);
                    if (intersect == null) {
                        class_243 intersectSphere = VecHelper.intersectSphere(start2, normedDiff2, start, 0.125);
                        if (intersectSphere == null || !class_3532.method_20390((double)normedDiff2.method_1026(intersectSphere.method_1020(start2).method_1029()), (double)1.0)) continue;
                        intersect = new double[]{intersectSphere.method_1022(start) - 0.125, intersectSphere.method_1022(start2) - 0.125};
                    }
                    if (intersect[0] > diff.method_1033() || intersect[1] > diff2.method_1033() || intersect[0] < 0.0 || intersect[1] < 0.0) continue;
                    return Pair.of(train, start.method_1019(normedDiff.method_1021(intersect[0])));
                }
            }
        }
        return null;
    }

    public void crash() {
        this.navigation.cancelNavigation();
        if (this.derailed) {
            return;
        }
        this.speed = -class_3532.method_15350((double)this.speed, (double)-0.5, (double)0.5);
        this.derailed = true;
        this.graph = null;
        this.status.crash();
        for (Carriage carriage : this.carriages) {
            carriage.forEachPresentEntity(e -> e.method_5736().forEach(entity -> {
                if (!(entity instanceof class_3222)) {
                    return;
                }
                class_3222 p = (class_3222)entity;
                Optional<UUID> controllingPlayer = e.getControllingPlayer();
                if (controllingPlayer.isPresent() && controllingPlayer.get().equals(p.method_5667())) {
                    return;
                }
                AllAdvancements.TRAIN_CRASH.trigger(p);
            }));
        }
        if (this.backwardsDriver != null) {
            AllAdvancements.TRAIN_CRASH_BACKWARDS.trigger((class_3222)this.backwardsDriver);
        }
    }

    public boolean disassemble(class_3222 sender, class_2350 assemblyDirection, class_2338 pos) {
        if (!this.canDisassemble()) {
            return false;
        }
        int offset = 1;
        boolean backwards = this.currentlyBackwards;
        class_1937 level = null;
        for (int i = 0; i < this.carriages.size(); ++i) {
            Carriage carriage = this.carriages.get(backwards ? this.carriages.size() - i - 1 : i);
            CarriageContraptionEntity entity = carriage.anyAvailableEntity();
            if (entity == null) {
                return false;
            }
            level = entity.method_37908();
            Contraption contraption = entity.getContraption();
            if (contraption instanceof CarriageContraption) {
                CarriageContraption cc = (CarriageContraption)contraption;
                cc.returnStorageForDisassembly(carriage.storage);
            }
            entity.method_33574(class_243.method_24954((class_2382)pos.method_10079(assemblyDirection, backwards ? offset + carriage.bogeySpacing : offset).method_10087(carriage.leadingBogey().isUpsideDown() ? 2 : 0)));
            entity.disassemble();
            for (CarriageBogey bogey : carriage.bogeys) {
                class_2586 be;
                class_243 bogeyPosition;
                if (bogey == null || (bogeyPosition = bogey.getAnchorPosition()) == null || !((be = level.method_8321(class_2338.method_49638((class_2374)bogeyPosition))) instanceof AbstractBogeyBlockEntity)) continue;
                AbstractBogeyBlockEntity sbbe = (AbstractBogeyBlockEntity)be;
                sbbe.setBogeyData(bogey.bogeyData);
            }
            offset += carriage.bogeySpacing;
            if (i >= this.carriageSpacing.size()) continue;
            offset += this.carriageSpacing.get(backwards ? this.carriageSpacing.size() - i - 1 : i).intValue();
        }
        GlobalStation currentStation = this.getCurrentStation();
        if (currentStation != null) {
            currentStation.cancelReservation(this);
            class_2338 blockEntityPos = currentStation.getBlockEntityPos();
            class_2586 class_25862 = level.method_8321(blockEntityPos);
            if (class_25862 instanceof StationBlockEntity) {
                StationBlockEntity sbe = (StationBlockEntity)class_25862;
                sbe.lastDisassembledTrainName = this.name.method_27661();
                sbe.lastDisassembledMapColorIndex = this.mapColorIndex;
            }
        }
        Create.RAILWAYS.removeTrain(this.id);
        sender.method_5682().method_3760().method_14581((class_2596)new RemoveTrainPacket(this));
        return true;
    }

    public boolean canDisassemble() {
        for (Carriage carriage : this.carriages) {
            if (carriage.presentInMultipleDimensions()) {
                return false;
            }
            CarriageContraptionEntity entity = carriage.anyAvailableEntity();
            if (entity == null) {
                return false;
            }
            if (!class_3532.method_15347((float)entity.pitch, (float)0.0f)) {
                return false;
            }
            if (class_3532.method_15347((float)((entity.yaw % 90.0f + 360.0f) % 90.0f), (float)0.0f)) continue;
            return false;
        }
        return true;
    }

    public boolean isTravellingOn(TrackNode node) {
        MutableBoolean affected = new MutableBoolean(false);
        this.forEachTravellingPoint(tp -> {
            if (tp.node1 == node || tp.node2 == node) {
                affected.setTrue();
            }
        });
        return affected.booleanValue();
    }

    public void detachFromTracks() {
        this.migratingPoints.clear();
        this.navigation.cancelNavigation();
        this.forEachTravellingPoint(tp -> this.migratingPoints.add(new TrainMigration((TravellingPoint)tp)));
        this.graph = null;
    }

    public void forEachTravellingPoint(Consumer<TravellingPoint> callback) {
        for (Carriage c : this.carriages) {
            c.leadingBogey().points.forEach(callback::accept);
            if (!c.isOnTwoBogeys()) continue;
            c.trailingBogey().points.forEach(callback::accept);
        }
    }

    public void forEachTravellingPointBackwards(BiConsumer<TravellingPoint, Double> callback) {
        double lastWheelOffset = 0.0;
        for (int i = 0; i < this.carriages.size(); ++i) {
            int index = this.carriages.size() - i - 1;
            Carriage carriage = this.carriages.get(index);
            CarriageBogey trailingBogey = carriage.trailingBogey();
            double trailSpacing = trailingBogey.type.getWheelPointSpacing();
            callback.accept(trailingBogey.trailing(), i == 0 ? 0.0 : (double)this.carriageSpacing.get(index).intValue() - lastWheelOffset - trailSpacing / 2.0);
            callback.accept(trailingBogey.leading(), trailSpacing);
            lastWheelOffset = trailSpacing / 2.0;
            if (!carriage.isOnTwoBogeys()) continue;
            CarriageBogey leadingBogey = carriage.leadingBogey();
            double leadSpacing = carriage.leadingBogey().type.getWheelPointSpacing();
            callback.accept(leadingBogey.trailing(), (double)carriage.bogeySpacing - lastWheelOffset - leadSpacing / 2.0);
            callback.accept(trailingBogey.leading(), leadSpacing);
            lastWheelOffset = leadSpacing / 2.0;
        }
    }

    public void reattachToTracks(class_1937 level) {
        if (this.migrationCooldown > 0) {
            --this.migrationCooldown;
            return;
        }
        HashSet<Map.Entry<UUID, TrackGraph>> entrySet = new HashSet<Map.Entry<UUID, TrackGraph>>(Create.RAILWAYS.trackNetworks.entrySet());
        HashMap<UUID, List> successfulMigrations = new HashMap<UUID, List>();
        for (TrainMigration md : this.migratingPoints) {
            Iterator iterator = entrySet.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                TrackGraphLocation gl = md.tryMigratingTo((TrackGraph)entry.getValue());
                if (gl == null) {
                    iterator.remove();
                    continue;
                }
                successfulMigrations.computeIfAbsent((UUID)entry.getKey(), uuid -> new ArrayList()).add(gl);
            }
        }
        if (entrySet.isEmpty()) {
            this.migrationCooldown = 40;
            this.status.failedMigration();
            this.derailed = true;
            return;
        }
        Iterator<TrainMigration> iterator = entrySet.iterator();
        if (iterator.hasNext()) {
            GlobalStation currentStation;
            Map.Entry entry = (Map.Entry)((Object)iterator.next());
            this.graph = (TrackGraph)entry.getValue();
            List locations = (List)successfulMigrations.get(entry.getKey());
            this.forEachTravellingPoint(tp -> tp.migrateTo(locations));
            this.migratingPoints.clear();
            if (this.derailed) {
                this.status.successfulMigration();
            }
            this.derailed = false;
            if (this.runtime.getSchedule() != null && this.runtime.state == ScheduleRuntime.State.IN_TRANSIT) {
                this.runtime.state = ScheduleRuntime.State.PRE_TRANSIT;
            }
            if ((currentStation = this.getCurrentStation()) != null) {
                currentStation.reserveFor(this);
            }
            this.updateSignalBlocks = true;
            this.migrationCooldown = 0;
            return;
        }
    }

    public int getTotalLength() {
        int length = 0;
        for (int i = 0; i < this.carriages.size(); ++i) {
            Carriage carriage = this.carriages.get(i);
            if (i == 0) {
                length = (int)((double)length + carriage.leadingBogey().type.getWheelPointSpacing() / 2.0);
            }
            if (i == this.carriages.size() - 1) {
                length = (int)((double)length + carriage.trailingBogey().type.getWheelPointSpacing() / 2.0);
            }
            length += carriage.bogeySpacing;
            if (i >= this.carriageSpacing.size()) continue;
            length += this.carriageSpacing.get(i).intValue();
        }
        return length;
    }

    public void leaveStation() {
        GlobalStation currentStation = this.getCurrentStation();
        if (currentStation != null) {
            currentStation.trainDeparted(this);
        }
        this.currentStation = null;
    }

    public void arriveAt(GlobalStation station) {
        this.setCurrentStation(station);
        this.reservedSignalBlocks.clear();
        this.runtime.destinationReached();
        station.runMailTransfer();
        this.ticksSinceLastMailTransfer = 0;
    }

    public void setCurrentStation(GlobalStation station) {
        this.currentStation = station.id;
    }

    public GlobalStation getCurrentStation() {
        if (this.currentStation == null) {
            return null;
        }
        if (this.graph == null) {
            return null;
        }
        return this.graph.getPoint(EdgePointType.STATION, this.currentStation);
    }

    @Nullable
    public class_1309 getOwner(class_1937 level) {
        if (level.method_8503() == null) {
            return null;
        }
        try {
            UUID uuid = this.owner;
            return uuid == null ? null : level.method_8503().method_3760().method_14602(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    public void approachTargetSpeed(float accelerationMod) {
        double actualTarget = this.targetSpeed;
        if (class_3532.method_20390((double)actualTarget, (double)this.speed)) {
            return;
        }
        if (this.manualTick) {
            this.leaveStation();
        }
        double acceleration = this.acceleration();
        if (this.speed < actualTarget) {
            this.speed = Math.min(this.speed + acceleration * (double)accelerationMod, actualTarget);
        } else if (this.speed > actualTarget) {
            this.speed = Math.max(this.speed - acceleration * (double)accelerationMod, actualTarget);
        }
    }

    public void collectInitiallyOccupiedSignalBlocks() {
        TravellingPoint trailingPoint = this.carriages.get(this.carriages.size() - 1).getTrailingPoint();
        TrackNode node1 = trailingPoint.node1;
        TrackNode node2 = trailingPoint.node2;
        TrackEdge edge = trailingPoint.edge;
        if (edge == null) {
            return;
        }
        double position = trailingPoint.position;
        EdgeData signalData = edge.getEdgeData();
        this.occupiedSignalBlocks.clear();
        this.reservedSignalBlocks.clear();
        this.occupiedObservers.clear();
        this.cachedObserverFiltering.clear();
        TravellingPoint signalScout = new TravellingPoint(node1, node2, edge, position, false);
        Map<UUID, SignalEdgeGroup> allGroups = Create.RAILWAYS.signalEdgeGroups;
        MutableObject prevGroup = new MutableObject(null);
        if (signalData.hasSignalBoundaries()) {
            SignalBoundary nextBoundary = signalData.next(EdgePointType.SIGNAL, position);
            if (nextBoundary == null) {
                UUID group;
                double d2 = 0.0;
                SignalBoundary prev = null;
                SignalBoundary current = signalData.next(EdgePointType.SIGNAL, 0.0);
                while (current != null) {
                    prev = current;
                    d2 = current.getLocationOn(edge);
                    current = signalData.next(EdgePointType.SIGNAL, d2);
                }
                if (prev != null && Create.RAILWAYS.signalEdgeGroups.containsKey(group = prev.getGroup(node2))) {
                    this.occupy(group, null);
                    prevGroup.setValue((Object)group);
                }
            } else {
                UUID group = nextBoundary.getGroup(node1);
                if (Create.RAILWAYS.signalEdgeGroups.containsKey(group)) {
                    this.occupy(group, null);
                    prevGroup.setValue((Object)group);
                }
            }
        } else {
            UUID groupId = signalData.getEffectiveEdgeGroupId(this.graph);
            if (allGroups.containsKey(groupId)) {
                this.occupy(groupId, null);
                prevGroup.setValue((Object)groupId);
            }
        }
        this.forEachTravellingPointBackwards((tp, d) -> signalScout.travel(this.graph, (double)d, signalScout.follow((TravellingPoint)tp), (distance, couple) -> {
            Object patt0$temp = couple.getFirst();
            if (patt0$temp instanceof TrackObserver) {
                TrackObserver observer = (TrackObserver)patt0$temp;
                this.occupiedObservers.add(observer.getId());
                return false;
            }
            Object patt1$temp = couple.getFirst();
            if (!(patt1$temp instanceof SignalBoundary)) {
                return false;
            }
            SignalBoundary signal = (SignalBoundary)patt1$temp;
            ((Couple)couple.getSecond()).map(signal::getGroup).forEach(id -> {
                if (!Create.RAILWAYS.signalEdgeGroups.containsKey(id)) {
                    return;
                }
                if (id.equals(prevGroup.getValue())) {
                    return;
                }
                this.occupy((UUID)id, null);
                prevGroup.setValue(id);
            });
            return false;
        }, signalScout.ignoreTurns()));
    }

    public boolean shouldCarriageSyncThisTick(long gameTicks, int updateInterval) {
        return (gameTicks + (long)this.tickOffset) % (long)updateInterval == 0L;
    }

    public Couple<Couple<TrackNode>> getEndpointEdges() {
        return Couple.create(this.carriages.get(0).getLeadingPoint(), this.carriages.get(this.carriages.size() - 1).getTrailingPoint()).map(tp -> Couple.create(tp.node1, tp.node2));
    }

    public int getNavigationPenalty() {
        if (this.manualTick) {
            return 200;
        }
        if (this.runtime.getSchedule() == null || this.runtime.paused) {
            return 700;
        }
        if (this.navigation.waitingForSignal != null && this.navigation.ticksWaitingForSignal > 0) {
            return 50 + Math.min(this.navigation.ticksWaitingForSignal / 20, 1000);
        }
        if (this.navigation.destination != null && this.navigation.distanceToDestination < 50.0 || this.navigation.distanceToSignal < 20.0) {
            return 50;
        }
        return 25;
    }

    public void burnFuel(class_1937 world) {
        if (this.fuelTicks > 0) {
            --this.fuelTicks;
            return;
        }
        boolean iterateFromBack = this.speed < 0.0;
        int carriageCount = this.carriages.size();
        class_9895 fuelRegistry = world.method_61269();
        for (int index = 0; index < carriageCount; ++index) {
            MutableInt burnTime;
            class_1799 extract;
            int i = iterateFromBack ? carriageCount - 1 - index : index;
            Carriage carriage = this.carriages.get(i);
            MountedItemStorageWrapper fuelItems = carriage.storage.getFuelItems();
            if (fuelItems == null || (extract = fuelItems.extract(arg_0 -> Train.lambda$burnFuel$31(fuelRegistry, burnTime = new MutableInt(), arg_0), 1)).method_7960()) continue;
            this.fuelTicks += burnTime.getValue().intValue();
            class_1799 remainder = extract.method_7909().method_7858();
            if (!remainder.method_7960()) {
                fuelItems.insertExist(remainder);
            }
            return;
        }
    }

    public float maxSpeed() {
        return (this.fuelTicks > 0 ? AllConfigs.server().trains.poweredTrainTopSpeed.getF() : AllConfigs.server().trains.trainTopSpeed.getF()) / 20.0f;
    }

    public float maxTurnSpeed() {
        return (this.fuelTicks > 0 ? AllConfigs.server().trains.poweredTrainTurningTopSpeed.getF() : AllConfigs.server().trains.trainTurningTopSpeed.getF()) / 20.0f;
    }

    public float acceleration() {
        return (this.fuelTicks > 0 ? AllConfigs.server().trains.poweredTrainAcceleration.getF() : AllConfigs.server().trains.trainAcceleration.getF()) / 400.0f;
    }

    public void write(class_11372 view, DimensionPalette dimensions) {
        view.method_71468("Id", class_4844.field_25122, (Object)this.id);
        if (this.owner != null) {
            view.method_71468("Owner", class_4844.field_25122, (Object)this.owner);
        }
        if (this.graph != null) {
            view.method_71468("Graph", class_4844.field_25122, (Object)this.graph.id);
        }
        class_11372.class_11374 carriageList = view.method_71476("Carriages");
        this.carriages.forEach(carriage -> carriage.write(carriageList.method_71480(), dimensions));
        view.method_71473("CarriageSpacing", this.carriageSpacing.stream().mapToInt(Integer::intValue).toArray());
        view.method_71472("DoubleEnded", this.doubleEnded);
        view.method_71463("Speed", this.speed);
        view.method_71463("Throttle", this.throttle);
        if (this.speedBeforeStall != null) {
            view.method_71468("SpeedBeforeStall", (Codec)Codec.DOUBLE, (Object)this.speedBeforeStall);
        }
        view.method_71465("Fuel", this.fuelTicks);
        view.method_71463("TargetSpeed", this.targetSpeed);
        view.method_71468("IconType", TrainIconType.CODEC, (Object)this.icon);
        view.method_71465("MapColorIndex", this.mapColorIndex);
        view.method_71468("Name", class_8824.field_46597, (Object)this.name);
        if (this.currentStation != null) {
            view.method_71468("Station", class_4844.field_25122, (Object)this.currentStation);
        }
        view.method_71472("Backwards", this.currentlyBackwards);
        view.method_71472("Derailed", this.derailed);
        view.method_71472("UpdateSignals", this.updateSignalBlocks);
        class_11372.class_11374 occupiedSignalBlockList = view.method_71476("SignalBlocks");
        this.occupiedSignalBlocks.forEach((id, boundary) -> {
            class_11372 item = occupiedSignalBlockList.method_71480();
            item.method_71468("Id", class_4844.field_25122, id);
            if (boundary != null) {
                item.method_71468("Boundary", class_4844.field_25122, boundary);
            }
        });
        view.method_71468("ReservedSignalBlocks", CreateCodecs.UUID_SET_CODEC, this.reservedSignalBlocks);
        view.method_71468("OccupiedObservers", CreateCodecs.UUID_SET_CODEC, this.occupiedObservers);
        class_11372.class_11374 migratingPointList = view.method_71476("MigratingPoints");
        this.migratingPoints.forEach(tm -> tm.write(migratingPointList.method_71480(), dimensions));
        this.runtime.write(view.method_71461("Runtime"));
        this.navigation.write(view.method_71461("Navigation"), dimensions);
    }

    public static <T> DataResult<T> encode(Train input, DynamicOps<T> ops, T empty, DimensionPalette dimensions) {
        RecordBuilder map = ops.mapBuilder();
        map.add("Id", (Object)input.id, (Encoder)class_4844.field_25122);
        if (input.owner != null) {
            map.add("Owner", (Object)input.owner, (Encoder)class_4844.field_25122);
        }
        if (input.graph != null) {
            map.add("Graph", (Object)input.graph.id, (Encoder)class_4844.field_25122);
        }
        ListBuilder carriageList = ops.listBuilder();
        input.carriages.forEach(carriage -> carriageList.add(Carriage.encode(carriage, ops, empty, dimensions)));
        map.add("Carriages", carriageList.build(empty));
        map.add("CarriageSpacing", ops.createIntList(input.carriageSpacing.stream().mapToInt(Integer::intValue)));
        map.add("DoubleEnded", ops.createBoolean(input.doubleEnded));
        map.add("Speed", ops.createDouble(input.speed));
        map.add("Throttle", ops.createDouble(input.throttle));
        if (input.speedBeforeStall != null) {
            map.add("SpeedBeforeStall", ops.createDouble(input.speedBeforeStall.doubleValue()));
        }
        map.add("Fuel", ops.createInt(input.fuelTicks));
        map.add("TargetSpeed", ops.createDouble(input.targetSpeed));
        map.add("IconType", (Object)input.icon, TrainIconType.CODEC);
        map.add("MapColorIndex", ops.createInt(input.mapColorIndex));
        map.add("Name", (Object)input.name, (Encoder)class_8824.field_46597);
        if (input.currentStation != null) {
            map.add("Station", (Object)input.currentStation, (Encoder)class_4844.field_25122);
        }
        map.add("Backwards", ops.createBoolean(input.currentlyBackwards));
        map.add("Derailed", ops.createBoolean(input.derailed));
        map.add("UpdateSignals", ops.createBoolean(input.updateSignalBlocks));
        ListBuilder occupiedSignalBlockList = ops.listBuilder();
        input.occupiedSignalBlocks.forEach((id, boundary) -> {
            RecordBuilder item = ops.mapBuilder();
            item.add("Id", id, (Encoder)class_4844.field_25122);
            if (boundary != null) {
                item.add("Boundary", boundary, (Encoder)class_4844.field_25122);
            }
            occupiedSignalBlockList.add(item.build(empty));
        });
        map.add("SignalBlocks", occupiedSignalBlockList.build(empty));
        map.add("ReservedSignalBlocks", input.reservedSignalBlocks, CreateCodecs.UUID_SET_CODEC);
        map.add("OccupiedObservers", input.occupiedObservers, CreateCodecs.UUID_SET_CODEC);
        ListBuilder migratingPointList = ops.listBuilder();
        input.migratingPoints.forEach(tm -> migratingPointList.add(TrainMigration.encode(tm, ops, empty, dimensions)));
        map.add("MigratingPoints", migratingPointList.build(empty));
        map.add("Runtime", ScheduleRuntime.encode(input.runtime, ops, empty));
        map.add("Navigation", Navigation.encode(input.navigation, ops, empty, dimensions));
        return map.build(empty);
    }

    public static Train read(class_11368 view, Map<UUID, TrackGraph> trackNetworks, DimensionPalette dimensions) {
        UUID id = view.method_71426("Id", class_4844.field_25122).orElse(null);
        UUID owner = view.method_71426("Owner", class_4844.field_25122).orElse(null);
        UUID graphId = view.method_71426("Graph", class_4844.field_25122).orElse(null);
        TrackGraph graph = graphId == null ? null : trackNetworks.get(graphId);
        List<Carriage> carriages = view.method_71438("Carriages").method_71447().map(item -> Carriage.read(item, graph, dimensions)).collect(Collectors.toList());
        ArrayList<Integer> carriageSpacing = new ArrayList<Integer>();
        view.method_71442("CarriageSpacing").ifPresent(array -> {
            for (int i : array) {
                carriageSpacing.add(i);
            }
        });
        boolean doubleEnded = view.method_71433("DoubleEnded", false);
        int mapColorIndex = view.method_71424("MapColorIndex", 0);
        Train train = new Train(id, owner, graph, carriages, carriageSpacing, doubleEnded, mapColorIndex);
        train.speed = view.method_71422("Speed", 0.0);
        train.throttle = view.method_71422("Throttle", 0.0);
        view.method_71426("SpeedBeforeStall", (Codec)Codec.DOUBLE).ifPresent(value -> {
            train.speedBeforeStall = value;
        });
        train.targetSpeed = view.method_71422("TargetSpeed", 0.0);
        train.icon = (TrainIconType)view.method_71426("IconType", TrainIconType.CODEC).orElseThrow();
        train.name = view.method_71426("Name", class_8824.field_46597).orElse(class_5244.field_39003);
        train.currentStation = view.method_71426("Station", class_4844.field_25122).orElse(null);
        train.currentlyBackwards = view.method_71433("Backwards", false);
        train.derailed = view.method_71433("Derailed", false);
        train.updateSignalBlocks = view.method_71433("UpdateSignals", false);
        train.fuelTicks = view.method_71424("Fuel", 0);
        view.method_71438("SignalBlocks").forEach(item -> train.occupiedSignalBlocks.put((UUID)item.method_71426("Id", class_4844.field_25122).orElseThrow(), item.method_71426("Boundary", class_4844.field_25122).orElse(null)));
        view.method_71426("ReservedSignalBlocks", CreateCodecs.UUID_SET_CODEC).ifPresent(set -> train.reservedSignalBlocks.addAll((Collection<UUID>)set));
        view.method_71426("OccupiedObservers", CreateCodecs.UUID_SET_CODEC).ifPresent(set -> train.occupiedObservers.addAll((Collection<UUID>)set));
        view.method_71438("MigratingPoints").forEach(item -> train.migratingPoints.add(TrainMigration.read(item, dimensions)));
        train.runtime.read(view.method_71434("Runtime"));
        train.navigation.read(view.method_71434("Navigation"), graph, dimensions);
        if (train.getCurrentStation() != null) {
            train.getCurrentStation().reserveFor(train);
        }
        return train;
    }

    public static <T> Train decode(DynamicOps<T> ops, T input, Map<UUID, TrackGraph> trackNetworks, DimensionPalette dimensions) {
        MapLike map = (MapLike)ops.getMap(input).getOrThrow();
        UUID id = class_4844.field_25122.parse(ops, map.get("Id")).result().orElse(null);
        UUID owner = class_4844.field_25122.parse(ops, map.get("Owner")).result().orElse(null);
        UUID graphId = class_4844.field_25122.parse(ops, map.get("Graph")).result().orElse(null);
        TrackGraph graph = graphId == null ? null : trackNetworks.get(graphId);
        List carriages = (List)ops.getStream(map.get("Carriages")).mapOrElse(stream -> stream.map(item -> Carriage.decode(ops, item, graph, dimensions)).collect(Collectors.toList()), e -> new ArrayList());
        List carriageSpacing = (List)ops.getIntStream(map.get("CarriageSpacing")).mapOrElse(stream -> stream.boxed().collect(Collectors.toList()), e -> new ArrayList());
        boolean doubleEnded = ops.getBooleanValue(map.get("DoubleEnded")).result().orElse(false);
        int mapColorIndex = ops.getNumberValue(map.get("MapColorIndex"), (Number)0).intValue();
        Train train = new Train(id, owner, graph, carriages, carriageSpacing, doubleEnded, mapColorIndex);
        train.speed = ops.getNumberValue(map.get("Speed"), (Number)0).doubleValue();
        train.throttle = ops.getNumberValue(map.get("Throttle"), (Number)0).doubleValue();
        Optional.ofNullable(map.get("SpeedBeforeStall")).ifPresent(value -> {
            train.speedBeforeStall = ops.getNumberValue(value, (Number)0).doubleValue();
        });
        train.targetSpeed = ops.getNumberValue(map.get("TargetSpeed"), (Number)0).doubleValue();
        train.icon = (TrainIconType)TrainIconType.CODEC.parse(ops, map.get("IconType")).getOrThrow();
        train.name = class_8824.field_46597.parse(ops, map.get("Name")).result().orElse(class_5244.field_39003);
        train.currentStation = class_4844.field_25122.parse(ops, map.get("Station")).result().orElse(null);
        train.currentlyBackwards = ops.getBooleanValue(map.get("Backwards")).result().orElse(false);
        train.derailed = ops.getBooleanValue(map.get("Derailed")).result().orElse(false);
        train.updateSignalBlocks = ops.getBooleanValue(map.get("UpdateSignals")).result().orElse(false);
        train.fuelTicks = ops.getNumberValue(map.get("Fuel"), (Number)0).intValue();
        ((Consumer)ops.getList(map.get("SignalBlocks")).getOrThrow()).accept(item -> {
            MapLike data = (MapLike)ops.getMap(item).getOrThrow();
            train.occupiedSignalBlocks.put((UUID)class_4844.field_25122.parse(ops, data.get("Id")).getOrThrow(), class_4844.field_25122.parse(ops, data.get("Boundary")).result().orElse(null));
        });
        CreateCodecs.UUID_SET_CODEC.parse(ops, map.get("ReservedSignalBlocks")).ifSuccess(set -> train.reservedSignalBlocks.addAll((Collection<UUID>)set));
        CreateCodecs.UUID_SET_CODEC.parse(ops, map.get("OccupiedObservers")).ifSuccess(set -> train.occupiedObservers.addAll((Collection<UUID>)set));
        ((Consumer)ops.getList(map.get("MigratingPoints")).getOrThrow()).accept(item -> train.migratingPoints.add(TrainMigration.decode(ops, item, dimensions)));
        train.runtime.decode(ops, map.get("Runtime"));
        train.navigation.decode(ops, map.get("Navigation"), graph, dimensions);
        if (train.getCurrentStation() != null) {
            train.getCurrentStation().reserveFor(train);
        }
        return train;
    }

    public int countPlayerPassengers() {
        AtomicInteger count = new AtomicInteger();
        for (Carriage carriage : this.carriages) {
            carriage.forEachPresentEntity(e -> e.method_5736().forEach(p -> {
                if (p instanceof class_1657) {
                    count.incrementAndGet();
                }
            }));
        }
        return count.intValue();
    }

    public void determineHonk(class_1937 level) {
        if (this.lowHonk != null) {
            return;
        }
        for (Carriage carriage : this.carriages) {
            Contraption contraption;
            Carriage.DimensionalCarriageEntity dimensional = carriage.getDimensionalIfPresent((class_5321<class_1937>)level.method_27983());
            if (dimensional == null) {
                return;
            }
            CarriageContraptionEntity entity = (CarriageContraptionEntity)((Object)dimensional.entity.get());
            if (entity == null || !((contraption = entity.getContraption()) instanceof CarriageContraption)) break;
            CarriageContraption otherCC = (CarriageContraption)contraption;
            Pair<Boolean, Integer> first = otherCC.soundQueue.getFirstWhistle(entity);
            if (first == null) continue;
            this.lowHonk = first.getFirst();
            this.honkPitch = first.getSecond();
        }
    }

    public float distanceToLocationSqr(class_1937 level, class_243 location) {
        float distance = Float.MAX_VALUE;
        for (Carriage carriage : this.carriages) {
            Carriage.DimensionalCarriageEntity dce = carriage.getDimensionalIfPresent((class_5321<class_1937>)level.method_27983());
            if (dce == null || dce.positionAnchor == null) continue;
            distance = Math.min(distance, (float)dce.positionAnchor.method_1025(location));
        }
        return distance;
    }

    public List<class_5321<class_1937>> getPresentDimensions() {
        return this.carriages.stream().flatMap(carriage -> carriage.getPresentDimensions().stream()).distinct().toList();
    }

    public Optional<class_2338> getPositionInDimension(class_5321<class_1937> dimension) {
        return this.carriages.stream().map(carriage -> carriage.getPositionInDimension(dimension)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    private static /* synthetic */ boolean lambda$burnFuel$31(class_9895 fuelRegistry, MutableInt burnTime, class_1799 stack) {
        int ticks = fuelRegistry.method_61755(stack);
        if (ticks > 0) {
            burnTime.setValue(ticks);
            return true;
        }
        return false;
    }

    public static class Penalties {
        static final int STATION = 50;
        static final int STATION_WITH_TRAIN = 300;
        static final int MANUAL_TRAIN = 200;
        static final int IDLE_TRAIN = 700;
        static final int ARRIVING_TRAIN = 50;
        static final int WAITING_TRAIN = 50;
        static final int ANY_TRAIN = 25;
        static final int RED_SIGNAL = 25;
        static final int REDSTONE_RED_SIGNAL = 400;
    }
}

