/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.deployer;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.catnip.nbt.NBTHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.contraptions.render.ContraptionMatrices;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.flywheel.lib.transform.PoseTransformStack;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.filtering.FilteringRenderer;
import com.zurrtum.create.client.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.zurrtum.create.client.foundation.virtualWorld.VirtualRenderWorld;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.content.kinetics.base.DirectionalAxisKineticBlock;
import com.zurrtum.create.content.kinetics.base.DirectionalKineticBlock;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.deployer.DeployerBlockEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1747;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_761;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_918;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class DeployerRenderer
extends SafeBlockEntityRenderer<DeployerBlockEntity> {
    public DeployerRenderer(class_5614.class_5615 context) {
    }

    @Override
    protected void renderSafe(DeployerBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        this.renderItem(be, partialTicks, ms, buffer, light, overlay);
        FilteringRenderer.renderOnBlockEntity(be, partialTicks, ms, buffer, light, overlay);
        if (VisualizationManager.supportsVisualization((class_1936)be.method_10997())) {
            return;
        }
        this.renderComponents(be, partialTicks, ms, buffer, light);
    }

    protected void renderItem(DeployerBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        boolean isBlockItem;
        if (be.heldItem.method_7960()) {
            return;
        }
        class_2680 deployerState = be.method_11010();
        class_243 offset = this.getHandOffset(be, partialTicks, deployerState).method_1019(VecHelper.getCenterOf(class_2338.field_11176));
        ms.method_22903();
        ms.method_22904(offset.field_1352, offset.field_1351, offset.field_1350);
        class_2350 facing = (class_2350)deployerState.method_11654(DirectionalKineticBlock.FACING);
        boolean punching = be.mode == DeployerBlockEntity.Mode.PUNCH;
        float yRot = AngleHelper.horizontalAngle(facing) + 180.0f;
        float xRot = facing == class_2350.field_11036 ? 90.0f : (facing == class_2350.field_11033 ? 270.0f : 0.0f);
        boolean displayMode = facing == class_2350.field_11036 && be.getSpeed() == 0.0f && !punching;
        ms.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(yRot));
        if (!displayMode) {
            ms.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(xRot));
            ms.method_46416(0.0f, 0.0f, -0.6875f);
        }
        if (punching) {
            ms.method_46416(0.0f, 0.125f, -0.0625f);
        }
        class_918 itemRenderer = class_310.method_1551().method_1480();
        class_811 transform = displayMode ? class_811.field_4318 : (punching ? class_811.field_4320 : class_811.field_4319);
        itemRenderer.field_55296.method_65598(itemRenderer.field_55297, be.heldItem, transform, be.method_10997(), null, 0);
        boolean bl = isBlockItem = be.heldItem.method_7909() instanceof class_1747 && itemRenderer.field_55297.method_65608();
        if (displayMode) {
            float scale = isBlockItem ? 1.25f : 1.0f;
            ms.method_46416(0.0f, isBlockItem ? 0.5625f : 0.6875f, 0.0f);
            ms.method_22905(scale, scale, scale);
            ms.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(AnimationTickHolder.getRenderTime((class_1936)be.method_10997())));
        } else {
            float scale = punching ? 0.75f : (isBlockItem ? 0.734375f : 0.5f);
            ms.method_22905(scale, scale, scale);
        }
        itemRenderer.field_55297.method_65604(ms, buffer, light, overlay);
        ms.method_22909();
    }

    protected void renderComponents(DeployerBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light) {
        class_4588 vb = buffer.getBuffer(class_1921.method_23577());
        if (!VisualizationManager.supportsVisualization((class_1936)be.method_10997())) {
            KineticBlockEntityRenderer.renderRotatingKineticBlock(be, this.getRenderedBlockState(be), ms, vb, light);
        }
        class_2680 blockState = be.method_11010();
        class_243 offset = this.getHandOffset(be, partialTicks, blockState);
        SuperByteBuffer pole = CachedBuffers.partial(AllPartialModels.DEPLOYER_POLE, blockState);
        SuperByteBuffer hand = CachedBuffers.partial(DeployerRenderer.getHandPose(be), blockState);
        DeployerRenderer.transform((SuperByteBuffer)pole.translate(offset.field_1352, offset.field_1351, offset.field_1350), blockState, true).light(light).renderInto(ms, vb);
        DeployerRenderer.transform((SuperByteBuffer)hand.translate(offset.field_1352, offset.field_1351, offset.field_1350), blockState, false).light(light).renderInto(ms, vb);
    }

    public static PartialModel getHandPose(DeployerBlockEntity be) {
        return be.mode == DeployerBlockEntity.Mode.PUNCH ? AllPartialModels.DEPLOYER_HAND_PUNCHING : (be.heldItem.method_7960() ? AllPartialModels.DEPLOYER_HAND_POINTING : AllPartialModels.DEPLOYER_HAND_HOLDING);
    }

    protected class_243 getHandOffset(DeployerBlockEntity be, float partialTicks, class_2680 blockState) {
        float distance = DeployerRenderer.getHandOffset(be, partialTicks);
        return class_243.method_24954((class_2382)((class_2350)blockState.method_11654(DirectionalKineticBlock.FACING)).method_62675()).method_1021((double)distance);
    }

    public static float getHandOffset(DeployerBlockEntity be, float partialTicks) {
        if (be.isVirtual()) {
            return be.animatedOffset.getValue(partialTicks);
        }
        float progress = 0.0f;
        int timerSpeed = be.getTimerSpeed();
        PartialModel handPose = DeployerRenderer.getHandPose(be);
        if (be.state == DeployerBlockEntity.State.EXPANDING) {
            progress = 1.0f - ((float)be.timer - partialTicks * (float)timerSpeed) / 1000.0f;
            if (be.fistBump) {
                progress *= progress;
            }
        }
        if (be.state == DeployerBlockEntity.State.RETRACTING) {
            progress = ((float)be.timer - partialTicks * (float)timerSpeed) / 1000.0f;
        }
        float handLength = handPose == AllPartialModels.DEPLOYER_HAND_POINTING ? 0.0f : (handPose == AllPartialModels.DEPLOYER_HAND_HOLDING ? 0.25f : 0.1875f);
        return Math.min(class_3532.method_15363((float)progress, (float)0.0f, (float)1.0f) * (be.reach + handLength), 1.3125f);
    }

    protected class_2680 getRenderedBlockState(KineticBlockEntity be) {
        return KineticBlockEntityRenderer.shaft(KineticBlockEntityRenderer.getRotationAxisOf(be));
    }

    private static SuperByteBuffer transform(SuperByteBuffer buffer, class_2680 deployerState, boolean axisDirectionMatters) {
        float xRot;
        class_2350 facing = (class_2350)deployerState.method_11654(DirectionalKineticBlock.FACING);
        float yRot = AngleHelper.horizontalAngle(facing);
        float f = facing == class_2350.field_11036 ? 270.0f : (xRot = facing == class_2350.field_11033 ? 90.0f : 0.0f);
        float zRot = axisDirectionMatters && (Boolean)deployerState.method_11654((class_2769)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE) ^ facing.method_10166() == class_2350.class_2351.field_11051 ? 90.0f : 0.0f;
        buffer.rotateCentered((float)((double)(yRot / 180.0f) * Math.PI), class_2350.field_11036);
        buffer.rotateCentered((float)((double)(xRot / 180.0f) * Math.PI), class_2350.field_11034);
        buffer.rotateCentered((float)((double)(zRot / 180.0f) * Math.PI), class_2350.field_11035);
        return buffer;
    }

    public static void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, class_4597 buffer) {
        double factor;
        class_4588 builder = buffer.getBuffer(class_1921.method_23577());
        class_2680 blockState = context.state;
        DeployerBlockEntity.Mode mode = NBTHelper.readEnum(context.blockEntityData, "Mode", DeployerBlockEntity.Mode.class);
        PartialModel handPose = DeployerRenderer.getHandPose(mode);
        float speed = context.getAnimationSpeed();
        if (context.contraption.stalled) {
            speed = 0.0f;
        }
        SuperByteBuffer shaft = CachedBuffers.block(AllBlocks.SHAFT.method_9564());
        SuperByteBuffer pole = CachedBuffers.partial(AllPartialModels.DEPLOYER_POLE, blockState);
        SuperByteBuffer hand = CachedBuffers.partial(handPose, blockState);
        if (context.contraption.stalled || context.position == null || context.data.method_10545("StationaryTimer")) {
            factor = class_3532.method_15374((float)(AnimationTickHolder.getRenderTime() * 0.5f)) * 0.25f + 0.25f;
        } else {
            class_243 center = VecHelper.getCenterOf((class_2382)class_2338.method_49638((class_2374)context.position));
            double distance = context.position.method_1022(center);
            double nextDistance = context.position.method_1019(context.motion).method_1022(center);
            factor = 0.5 - class_3532.method_15350((double)class_3532.method_16436((double)AnimationTickHolder.getPartialTicks(), (double)distance, (double)nextDistance), (double)0.0, (double)1.0);
        }
        class_243 offset = class_243.method_24954((class_2382)((class_2350)blockState.method_11654(DirectionalKineticBlock.FACING)).method_62675()).method_1021(factor);
        class_4587 m = matrices.getModel();
        m.method_22903();
        m.method_22903();
        class_2350.class_2351 axis = class_2350.class_2351.field_11052;
        class_2248 class_22482 = context.state.method_26204();
        if (class_22482 instanceof IRotate) {
            IRotate def = (IRotate)class_22482;
            axis = def.getRotationAxis(context.state);
        }
        float time = AnimationTickHolder.getRenderTime((class_1936)context.world) / 20.0f;
        float angle = time * speed % 360.0f;
        ((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)TransformStack.of(m).center()).rotateYDegrees(axis == class_2350.class_2351.field_11051 ? 90.0f : 0.0f)).rotateZDegrees(axis.method_10179() ? 90.0f : 0.0f)).uncenter();
        shaft.transform(m);
        shaft.rotateCentered(angle, class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)class_2350.class_2351.field_11052));
        m.method_22909();
        if (!context.disabled) {
            m.method_22904(offset.field_1352, offset.field_1351, offset.field_1350);
        }
        pole.transform(m);
        hand.transform(m);
        DeployerRenderer.transform(pole, blockState, true);
        DeployerRenderer.transform(hand, blockState, false);
        shaft.light(class_761.method_23794((class_1920)renderWorld, (class_2338)context.localPos)).useLevelLight((class_1920)context.world, matrices.getWorld()).renderInto(matrices.getViewProjection(), builder);
        pole.light(class_761.method_23794((class_1920)renderWorld, (class_2338)context.localPos)).useLevelLight((class_1920)context.world, matrices.getWorld()).renderInto(matrices.getViewProjection(), builder);
        hand.light(class_761.method_23794((class_1920)renderWorld, (class_2338)context.localPos)).useLevelLight((class_1920)context.world, matrices.getWorld()).renderInto(matrices.getViewProjection(), builder);
        m.method_22909();
    }

    static PartialModel getHandPose(DeployerBlockEntity.Mode mode) {
        return mode == DeployerBlockEntity.Mode.PUNCH ? AllPartialModels.DEPLOYER_HAND_PUNCHING : AllPartialModels.DEPLOYER_HAND_POINTING;
    }
}

