/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.compat.rei.category;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.client.compat.rei.CreateCategory;
import com.zurrtum.create.client.compat.rei.widget.JunkWidget;
import com.zurrtum.create.client.compat.rei.widget.TooltipWidget;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.render.DeployerRenderState;
import com.zurrtum.create.client.foundation.gui.render.PressRenderState;
import com.zurrtum.create.client.foundation.gui.render.SpoutRenderState;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.compat.rei.ReiCommonPlugin;
import com.zurrtum.create.compat.rei.display.SequencedAssemblyDisplay;
import com.zurrtum.create.content.processing.recipe.ChanceOutput;
import dev.architectury.fluid.FluidStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11256;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3956;
import net.minecraft.class_5250;
import net.minecraft.class_9326;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;
import org.joml.Matrix3x2fc;

@Environment(value=EnvType.CLIENT)
public class SequencedAssemblyCategory
extends CreateCategory<SequencedAssemblyDisplay> {
    public static String[] ROMANS = new String[]{"I", "II", "III", "IV", "V", "VI", "-"};
    public static Map<class_3956<?>, SequencedRenderer> DRAW = new IdentityHashMap();

    public static void registerDraw(class_3956<?> type, SequencedRenderer draw) {
        DRAW.put(type, draw);
    }

    public CategoryIdentifier<? extends SequencedAssemblyDisplay> getCategoryIdentifier() {
        return ReiCommonPlugin.SEQUENCED_ASSEMBLY;
    }

    public class_2561 getTitle() {
        return CreateLang.translateDirect("recipe.sequenced_assembly", new Object[0]);
    }

    public Renderer getIcon() {
        return EntryStacks.of((class_1935)AllItems.PRECISION_MECHANISM);
    }

    @Override
    public void addWidgets(List<Widget> widgets, SequencedAssemblyDisplay display, Rectangle bounds) {
        ChanceOutput chanceOutput = display.output();
        boolean randomOutput = chanceOutput.chance() != 1.0f;
        boolean willRepeat = display.loop() > 1;
        int xOffset = randomOutput ? bounds.x - 7 : bounds.x;
        Point input = new Point(xOffset + 32, bounds.y + 96);
        Point output = new Point(xOffset + 137, bounds.y + 96);
        SequencedAssemblyDisplay.SequenceData sequences = display.sequences();
        List<EntryIngredient> ingredients = sequences.ingredients();
        List<List<class_2561>> tooltips = sequences.tooltip();
        List<class_3956<?>> types = sequences.types();
        ArrayList<Point> points = new ArrayList<Point>();
        int size = ingredients.size();
        boolean[] noBackground = new boolean[size];
        int left = bounds.x + 99 - 14 * size;
        int top = bounds.y;
        for (int i = 0; i < size; ++i) {
            points.add(new Point(left + i * 28, top + 20));
            if (!ingredients.get(i).isEmpty()) continue;
            noBackground[i] = true;
        }
        widgets.add(Widgets.createDrawableWidget((graphics, mouseX, mouseY, delta) -> {
            for (int i = 0; i < size; ++i) {
                if (noBackground[i]) continue;
                Point point = (Point)points.get(i);
                AllGuiTextures.JEI_SLOT.render(graphics, point.x - 1, point.y - 1);
            }
        }));
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (int i = 0; i < size; ++i) {
            Point point = (Point)points.get(i);
            List<class_2561> step = tooltips.get(i);
            if (noBackground[i]) {
                widgets.add(new TooltipWidget(point.x, point.y - 14, 16, 86, step));
                slots.add(null);
                continue;
            }
            Slot slot = SequencedAssemblyCategory.createInputSlot(point).disableTooltips().entries((Collection)SequencedAssemblyCategory.getRenderEntryStack(ingredients.get(i)));
            widgets.add(new TooltipWidget(point.x, point.y - 14, 16, 86, mc -> {
                Tooltip tooltip = slot.getCurrentTooltip(TooltipContext.ofMouse((class_1792.class_9635)class_1792.class_9635.method_59528((class_1937)mc.field_1687)));
                if (tooltip == null) {
                    return Tooltip.create((Collection)step);
                }
                List entries = tooltip.entries();
                Tooltip.Entry first = (Tooltip.Entry)entries.getFirst();
                int len = step.size();
                if (first.isText()) {
                    entries.set(0, Tooltip.entry((class_2561)((class_2561)step.get(len - 1)).method_27661().method_27693(first.getAsText().getString())));
                } else {
                    entries.addFirst(Tooltip.entry((class_2561)((class_2561)step.get(len - 1))));
                }
                for (int j = len - 2; j >= 0; --j) {
                    entries.addFirst(Tooltip.entry((class_2561)((class_2561)step.get(j))));
                }
                return tooltip;
            }));
            widgets.add((Widget)slot);
            slots.add(slot);
        }
        widgets.add(Widgets.createDrawableWidget((graphics, mouseX, mouseY, delta) -> {
            class_327 textRenderer = graphics.field_44656.field_1772;
            for (int i = 0; i < size; ++i) {
                Point point = (Point)points.get(i);
                String text = ROMANS[Math.min(i, ROMANS.length)];
                graphics.method_51433(textRenderer, text, point.x + 8 - textRenderer.method_1727(text) / 2, point.y - 13, -7829368, false);
                SequencedRenderer draw = DRAW.get(types.get(i));
                if (draw == null) continue;
                Slot slot = (Slot)slots.get(i);
                EntryStack stack = null;
                if (slot != null) {
                    stack = slot.getCurrentEntry();
                }
                draw.render(graphics, i, point, stack);
            }
            SequencedAssemblyCategory.drawSlotBackground(graphics, input);
            if (randomOutput) {
                SequencedAssemblyCategory.drawChanceSlotBackground(graphics, output);
            } else {
                SequencedAssemblyCategory.drawSlotBackground(graphics, output);
            }
            AllGuiTextures.JEI_LONG_ARROW.render(graphics, xOffset + 57, bounds.y + 99);
            if (willRepeat) {
                AllIcons.I_SEQ_REPEAT.render(graphics, xOffset + 70, bounds.y + 104);
                class_5250 repeat = class_2561.method_43470((String)("x" + display.loop()));
                graphics.method_51439(textRenderer, (class_2561)repeat, xOffset + 86, bounds.y + 109, -7829368, false);
            }
        }));
        widgets.add((Widget)SequencedAssemblyCategory.createInputSlot(input).entries((Collection)display.input()));
        widgets.add((Widget)SequencedAssemblyCategory.createOutputSlot(output).entries((Collection)SequencedAssemblyCategory.getRenderEntryStack(chanceOutput)));
        if (randomOutput) {
            widgets.add(new JunkWidget(xOffset + 156, bounds.y + 96, 1.0f - chanceOutput.chance()));
        }
        if (willRepeat) {
            widgets.add(new TooltipWidget(xOffset + 57, bounds.y + 99, 71, 18, new class_2561[]{CreateLang.translateDirect("recipe.assembly.repeat", display.loop())}));
        }
    }

    public int getDisplayHeight() {
        return 125;
    }

    static {
        DRAW.put(AllRecipeTypes.PRESSING, (graphics, i, point, stack) -> {
            float scale = 0.6333333f;
            Matrix3x2fStack matrices = graphics.method_51448();
            matrices.pushMatrix();
            matrices.translate((float)point.x, (float)point.y);
            matrices.scale(scale, scale);
            matrices.translate((float)(-point.x), (float)(-point.y));
            graphics.field_59826.method_70922((class_11256)new PressRenderState(i, new Matrix3x2f((Matrix3x2fc)matrices), point.x - 3, point.y + 18, i));
            matrices.popMatrix();
        });
        DRAW.put(AllRecipeTypes.DEPLOYING, (graphics, i, point, stack) -> {
            float scale = 0.75641024f;
            Matrix3x2fStack matrices = graphics.method_51448();
            matrices.pushMatrix();
            matrices.translate((float)point.x, (float)point.y);
            matrices.scale(scale, scale);
            matrices.translate((float)(-point.x), (float)(-point.y));
            graphics.field_59826.method_70922((class_11256)new DeployerRenderState(i, new Matrix3x2f((Matrix3x2fc)matrices), point.x - 3, point.y + 18, i));
            matrices.popMatrix();
        });
        DRAW.put(AllRecipeTypes.FILLING, (graphics, i, point, stack) -> {
            float scale = 0.76086956f;
            Matrix3x2fStack matrices = graphics.method_51448();
            matrices.pushMatrix();
            matrices.translate((float)point.x, (float)point.y);
            matrices.scale(scale, scale);
            matrices.translate((float)(-point.x), (float)(-point.y));
            class_3611 fluid = class_3612.field_15906;
            class_9326 components = class_9326.field_49588;
            if (stack != null) {
                FluidStack fluidStack = (FluidStack)stack.castValue();
                fluid = fluidStack.getFluid();
                components = fluidStack.getComponents().method_57940();
            }
            graphics.field_59826.method_70922((class_11256)new SpoutRenderState(i, new Matrix3x2f((Matrix3x2fc)matrices), fluid, components, point.x - 2, point.y + 24, i));
            matrices.popMatrix();
        });
    }

    @Environment(value=EnvType.CLIENT)
    public static interface SequencedRenderer {
        public void render(class_332 var1, int var2, Point var3, @Nullable EntryStack<?> var4);
    }
}

