/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.entity.sync;

import com.mrcrayfish.framework.api.sync.SyncSignal;
import com.mrcrayfish.framework.api.sync.SyncedDataKey;
import com.mrcrayfish.framework.entity.sync.DataHolder;
import com.mrcrayfish.framework.entity.sync.SyncedEntityData;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_9129;
import org.apache.commons.lang3.Validate;

public class DataEntry<E extends class_1297, T> {
    private final SyncSignal signal;
    private final DataHolder holder;
    private final SyncedDataKey<E, T> key;
    private T value;
    private boolean pendingSync;

    DataEntry(DataHolder holder, SyncedDataKey<E, T> key) {
        this.holder = holder;
        this.key = key;
        this.value = key.defaultValueSupplier().get();
        this.signal = new SyncSignal(this::markForSync);
        this.updateSignal();
    }

    SyncedDataKey<E, T> getKey() {
        return this.key;
    }

    T getValue() {
        return this.value;
    }

    void setValue(T value) {
        this.removeSignal();
        this.value = value;
        this.updateSignal();
        this.markForSync();
    }

    public void markForSync() {
        if (this.key.syncMode().willSync() && this.holder != null && this.holder.markForSync()) {
            this.pendingSync = true;
        }
    }

    boolean isPendingSync() {
        return this.pendingSync;
    }

    void clearSync() {
        this.pendingSync = false;
    }

    public void write(class_9129 buffer) {
        int id = SyncedEntityData.instance().getInternalId(this.key);
        buffer.method_10804(id);
        this.key.serializer().streamCodec().encode((Object)buffer, this.value);
    }

    public static DataEntry<?, ?> read(class_9129 buffer) {
        SyncedDataKey<?, ?> key = SyncedEntityData.instance().getKey(buffer.method_10816());
        Validate.notNull(key, (String)"Synced key does not exist for id", (Object[])new Object[0]);
        DataEntry entry = new DataEntry(null, key);
        entry.readValue(buffer);
        return entry;
    }

    private void readValue(class_9129 buffer) {
        this.value = this.getKey().serializer().streamCodec().decode((Object)buffer);
    }

    public void write(class_11372 output) {
        output.method_71468("Value", this.key.serializer().codec(), this.value);
    }

    public void read(class_11368 input) {
        this.removeSignal();
        input.method_71426("Value", this.key.serializer().codec()).ifPresent(value -> {
            this.value = value;
        });
        this.updateSignal();
    }

    private void updateSignal() {
        T t = this.value;
        if (t instanceof SyncSignal.Consumer) {
            SyncSignal.Consumer consumer = (SyncSignal.Consumer)t;
            consumer.accept(this.signal);
        }
    }

    private void removeSignal() {
        T t = this.value;
        if (t instanceof SyncSignal.Consumer) {
            SyncSignal.Consumer consumer = (SyncSignal.Consumer)t;
            consumer.accept(null);
        }
    }
}

