/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.screen;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1712;
import net.minecraft.class_1715;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_3917;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.apache.commons.lang3.Range;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.network.NetworkManager;
import reborncore.common.network.clientbound.ScreenHandlerUpdatePayload;
import reborncore.common.screen.ServerPlayerEntityScreenHandlerHelper;
import reborncore.common.screen.builder.SyncedObject;
import reborncore.common.util.ItemUtils;
import reborncore.common.util.RangeUtil;

public class BuiltScreenHandler
extends class_1703 {
    private final String name;
    private final Predicate<class_1657> canInteract;
    private final List<Range<Integer>> playerSlotRanges;
    private final List<Range<Integer>> blockEntitySlotRanges;
    private final Map<IdentifiedSyncedObject<?>, Object> syncPairCache = new HashMap();
    private final Int2ObjectMap<IdentifiedSyncedObject<?>> syncPairIdLookup = new Int2ObjectOpenHashMap();
    private List<Consumer<class_1715>> craftEvents;
    private final MachineBaseBlockEntity blockEntity;
    class_3917<BuiltScreenHandler> type = null;

    public BuiltScreenHandler(int syncID, String name, Predicate<class_1657> canInteract, List<Range<Integer>> playerSlotRange, List<Range<Integer>> blockEntitySlotRange, MachineBaseBlockEntity blockEntity) {
        super(null, syncID);
        this.name = name;
        this.canInteract = canInteract;
        this.playerSlotRanges = RangeUtil.joinAdjacent(playerSlotRange);
        this.blockEntitySlotRanges = RangeUtil.joinAdjacent(blockEntitySlotRange);
        this.blockEntity = blockEntity;
    }

    public void addObjectSync(List<SyncedObject<?>> syncedObjects) {
        for (SyncedObject<?> syncedObject : syncedObjects) {
            int id = this.syncPairCache.size() + 1;
            IdentifiedSyncedObject syncPair = new IdentifiedSyncedObject(syncedObject, id);
            this.syncPairCache.put(syncPair, null);
            this.syncPairIdLookup.put(id, syncPair);
        }
    }

    public void addCraftEvents(List<Consumer<class_1715>> craftEvents) {
        this.craftEvents = craftEvents;
    }

    public boolean method_7597(class_1657 playerIn) {
        return this.canInteract.test(playerIn);
    }

    public final void method_7609(class_1263 inv) {
        if (!this.craftEvents.isEmpty()) {
            this.craftEvents.forEach(consumer -> consumer.accept((class_1715)inv));
        }
    }

    public void method_7623() {
        super.method_7623();
        for (class_1712 listener : this.field_7765) {
            this.sendContentUpdatePacketToListener(listener);
        }
    }

    public void method_7596(class_1712 listener) {
        super.method_7596(listener);
        this.sendContentUpdatePacketToListener(listener);
    }

    private void sendContentUpdatePacketToListener(class_1712 listener) {
        HashMap updatedValues = new HashMap();
        this.syncPairCache.replaceAll((identifiedSyncedObject, cached) -> {
            Object value = identifiedSyncedObject.get();
            if (!value.equals(cached)) {
                updatedValues.put((IdentifiedSyncedObject<?>)identifiedSyncedObject, value);
                return value;
            }
            return null;
        });
        if (updatedValues.isEmpty()) {
            return;
        }
        byte[] data = this.writeScreenHandlerData(updatedValues);
        ServerPlayerEntityScreenHandlerHelper.getServerPlayerEntity(listener).ifPresent(serverPlayerEntity -> NetworkManager.sendToPlayer(new ScreenHandlerUpdatePayload(data), serverPlayerEntity));
    }

    private byte[] writeScreenHandlerData(Map<IdentifiedSyncedObject<?>, Object> updatedValues) {
        class_9129 byteBuf = new class_9129((ByteBuf)PacketByteBufs.create(), this.blockEntity.method_10997().method_30349());
        byteBuf.method_53002(updatedValues.size());
        for (Map.Entry<IdentifiedSyncedObject<?>, Object> entry : updatedValues.entrySet()) {
            class_9139<class_9129, ?> codec = entry.getKey().object().codec();
            byteBuf.method_53002(entry.getKey().id());
            codec.encode((Object)byteBuf, entry.getValue());
        }
        return byteBuf.array();
    }

    public void applyScreenHandlerData(byte[] data) {
        class_9129 byteBuf = new class_9129((ByteBuf)new class_2540(Unpooled.wrappedBuffer((byte[])data)), this.blockEntity.method_10997().method_30349());
        int size = byteBuf.readInt();
        for (int i = 0; i < size; ++i) {
            int id = byteBuf.readInt();
            IdentifiedSyncedObject syncedObject = (IdentifiedSyncedObject)this.syncPairIdLookup.get(id);
            Object value = syncedObject.object().codec().decode((Object)byteBuf);
            syncedObject.set(value);
        }
    }

    public class_1799 method_7601(class_1657 player, int index) {
        class_1799 originalStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot != null && slot.method_7681()) {
            class_1799 stackInSlot = slot.method_7677();
            originalStack = stackInSlot.method_7972();
            boolean shifted = false;
            for (Range<Integer> range : this.playerSlotRanges) {
                if (!range.contains((Object)index)) continue;
                if (!this.shiftToBlockEntity(stackInSlot)) break;
                shifted = true;
                break;
            }
            if (!shifted) {
                for (Range<Integer> range : this.blockEntitySlotRanges) {
                    if (!range.contains((Object)index)) continue;
                    if (!this.shiftToPlayer(stackInSlot)) break;
                    shifted = true;
                    break;
                }
            }
            slot.method_7670(stackInSlot, originalStack);
            if (stackInSlot.method_7947() <= 0) {
                slot.method_53512(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
            if (stackInSlot.method_7947() == originalStack.method_7947()) {
                return class_1799.field_8037;
            }
            slot.method_7667(player, stackInSlot);
        }
        return originalStack;
    }

    protected boolean shiftItemStack(class_1799 stackToShift, int start, int end) {
        int maxCount;
        class_1799 stackInSlot;
        class_1735 slot;
        int slotIndex;
        if (stackToShift.method_7960()) {
            return false;
        }
        int inCount = stackToShift.method_7947();
        for (slotIndex = start; stackToShift.method_7947() > 0 && slotIndex < end; ++slotIndex) {
            int freeStackSpace;
            slot = (class_1735)this.field_7761.get(slotIndex);
            stackInSlot = slot.method_7677();
            maxCount = Math.min(stackToShift.method_7914(), slot.method_7675());
            if (stackToShift.method_7960() || !slot.method_7680(stackToShift) || !ItemUtils.isItemEqual(stackInSlot, stackToShift, true, false) || (freeStackSpace = maxCount - stackInSlot.method_7947()) <= 0) continue;
            int transferAmount = Math.min(freeStackSpace, stackToShift.method_7947());
            stackInSlot.method_7933(transferAmount);
            stackToShift.method_7934(transferAmount);
        }
        for (slotIndex = start; stackToShift.method_7947() > 0 && slotIndex < end; ++slotIndex) {
            slot = (class_1735)this.field_7761.get(slotIndex);
            stackInSlot = slot.method_7677();
            if (!stackInSlot.method_7960() || !slot.method_7680(stackToShift)) continue;
            maxCount = Math.min(stackToShift.method_7914(), slot.method_7675());
            int moveCount = Math.min(maxCount, stackToShift.method_7947());
            class_1799 moveStack = stackToShift.method_7972();
            moveStack.method_7939(moveCount);
            slot.method_53512(moveStack);
            stackToShift.method_7934(moveCount);
        }
        if (!stackToShift.method_7960() && stackToShift.method_7947() != inCount) {
            this.shiftItemStack(stackToShift, start, end);
        }
        return stackToShift.method_7947() != inCount;
    }

    private boolean shiftToBlockEntity(class_1799 stackToShift) {
        if (!this.blockEntity.getOptionalInventory().isPresent()) {
            return false;
        }
        for (Range<Integer> range : this.blockEntitySlotRanges) {
            if (!this.shiftItemStack(stackToShift, (Integer)range.getMinimum(), (Integer)range.getMaximum() + 1)) continue;
            return true;
        }
        return false;
    }

    private boolean shiftToPlayer(class_1799 stackToShift) {
        for (Range<Integer> range : this.playerSlotRanges) {
            if (!this.shiftItemStack(stackToShift, (Integer)range.getMinimum(), (Integer)range.getMaximum() + 1)) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public class_1735 method_7621(class_1735 slotIn) {
        return super.method_7621(slotIn);
    }

    public MachineBaseBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public class_2338 getPos() {
        return this.getBlockEntity().method_11016();
    }

    public void setType(class_3917<BuiltScreenHandler> type) {
        this.type = type;
    }

    public class_3917<BuiltScreenHandler> method_17358() {
        return this.type;
    }

    private record IdentifiedSyncedObject<T>(SyncedObject<T> object, int id) {
        public T get() {
            return this.object.getter().get();
        }

        public void set(T value) {
            this.object.setter().accept(value);
        }
    }
}

