/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture;

import com.luciad.imageio.webp.WebP;
import com.luciad.imageio.webp.WebPImageReaderSpi;
import com.luciad.imageio.webp.WebPImageWriterSpi;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import me.chrr.camerapture.ByteCollector;
import me.chrr.camerapture.Camerapture;
import me.chrr.camerapture.compat.FirstPersonModelCompat;
import me.chrr.camerapture.config.SyncedConfig;
import me.chrr.camerapture.gui.PictureScreen;
import me.chrr.camerapture.gui.UploadScreen;
import me.chrr.camerapture.item.AlbumItem;
import me.chrr.camerapture.item.CameraItem;
import me.chrr.camerapture.item.PictureItem;
import me.chrr.camerapture.net.clientbound.DownloadPartialPicturePacket;
import me.chrr.camerapture.net.clientbound.PictureErrorPacket;
import me.chrr.camerapture.net.clientbound.RequestUploadPacket;
import me.chrr.camerapture.net.clientbound.SyncConfigPacket;
import me.chrr.camerapture.picture.ClientPictureStore;
import me.chrr.camerapture.picture.PictureTaker;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class CameraptureClient {
    public static final float MIN_ZOOM = 1.0f;
    public static final float MAX_ZOOM = 6.0f;
    public static boolean replayModInstalled = false;
    public static SyncedConfig syncedConfig;

    public static void init() {
        CameraptureClient.loadImageIOWebP();
        ClientPictureStore.getInstance().clear();
        syncedConfig = SyncedConfig.fromServerConfig(Camerapture.CONFIG_MANAGER.getConfig().server);
        if (Camerapture.PLATFORM.isModLoaded("firstperson")) {
            FirstPersonModelCompat.register();
        }
        if (Camerapture.PLATFORM.isModLoaded("replay-mod")) {
            Camerapture.LOGGER.info("Replay Mod is detected, Camerapture will cache pictures, regardless of config.");
            replayModInstalled = true;
        }
    }

    private static void loadImageIOWebP() {
        ImageIO.scanForPlugins();
        if (!WebP.loadNativeLibrary()) {
            Camerapture.LOGGER.error("failed to load ImageIO-WebP, pictures might not work!");
        }
        boolean readerFound = false;
        Iterator<ImageReader> readers = ImageIO.getImageReadersBySuffix("webp");
        while (readers.hasNext()) {
            readerFound |= readers.next().getOriginatingProvider() instanceof WebPImageReaderSpi;
        }
        if (!readerFound) {
            Camerapture.LOGGER.error("WebP image reader not found, loading pictures might not work!");
        }
        boolean writerFound = false;
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByMIMEType("image/webp");
        while (writers.hasNext()) {
            writerFound |= writers.next().getOriginatingProvider() instanceof WebPImageWriterSpi;
        }
        if (!writerFound) {
            Camerapture.LOGGER.error("WebP image writer not found, taking pictures might not work!");
        }
        if (readerFound && writerFound) {
            Camerapture.LOGGER.info("successfully loaded WebP image reader and writer!");
        }
    }

    public static void registerPacketHandlers() {
        Camerapture.NETWORK.onReceiveFromServer(RequestUploadPacket.class, packet -> Camerapture.EXECUTOR.execute(() -> PictureTaker.getInstance().uploadStoredPicture(packet.uuid())));
        ConcurrentHashMap collectors = new ConcurrentHashMap();
        Camerapture.NETWORK.onReceiveFromServer(DownloadPartialPicturePacket.class, packet -> {
            ByteCollector collector;
            Object object = collectors;
            synchronized (object) {
                collector = collectors.computeIfAbsent(packet.uuid(), uuid -> new ByteCollector(bytes -> {
                    collectors.remove(uuid);
                    Camerapture.EXECUTOR.execute(() -> ClientPictureStore.getInstance().processReceivedBytes((UUID)uuid, (byte[])bytes));
                }));
            }
            object = collector;
            synchronized (object) {
                if (!collector.push(packet.bytes(), packet.bytesLeft())) {
                    Camerapture.LOGGER.error("received malformed byte section from server");
                    ClientPictureStore.getInstance().processReceivedError(packet.uuid());
                }
            }
        });
        Camerapture.NETWORK.onReceiveFromServer(PictureErrorPacket.class, packet -> {
            ClientPictureStore.getInstance().processReceivedError(packet.uuid());
            collectors.remove(packet.uuid());
        });
        Camerapture.NETWORK.onReceiveFromServer(SyncConfigPacket.class, packet -> {
            Camerapture.LOGGER.info("received synced config: {}", (Object)packet.syncedConfig());
            syncedConfig = packet.syncedConfig();
        });
    }

    public static class_1269 onUseItem(class_1657 player, class_1799 stack) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 != player) {
            return class_1269.field_5811;
        }
        if (stack.method_31574(Camerapture.PICTURE)) {
            if (PictureItem.getPictureData(stack) != null) {
                client.method_40000(() -> client.method_1507((class_437)new PictureScreen(List.of(stack))));
                return class_1269.field_5812;
            }
        } else if (stack.method_31574(Camerapture.ALBUM) && !player.method_5715()) {
            List<class_1799> pictures = AlbumItem.getPictures(stack);
            if (!pictures.isEmpty()) {
                client.method_40000(() -> client.method_1507((class_437)new PictureScreen(pictures)));
                return class_1269.field_5812;
            }
        } else if (player.method_64475(CameraptureClient.syncedConfig.permissionLevels().upload) && player.method_5715() && stack.method_31574(Camerapture.CAMERA) && !CameraItem.isActive(stack) && !player.method_7357().method_7904(stack)) {
            client.method_40000(() -> client.method_1507((class_437)new UploadScreen()));
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }
}

