/*
 * Decompiled with CFR 0.152.
 */
package fuzs.helditemtooltips.client.gui.screens.inventory.tooltip;

import fuzs.helditemtooltips.HeldItemTooltips;
import fuzs.helditemtooltips.client.core.ClientAbstractions;
import fuzs.helditemtooltips.client.gui.screens.inventory.tooltip.TooltipComponentHolder;
import fuzs.helditemtooltips.client.gui.screens.inventory.tooltip.component.TooltipComponent;
import fuzs.helditemtooltips.config.ClientConfig;
import fuzs.helditemtooltips.config.TooltipComponentConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public class HoverTextManager {
    private static final List<TooltipComponentHolder> TOOLTIP_COMPONENT_HOLDERS = new ArrayList<TooltipComponentHolder>();

    public static void register(TooltipComponent tooltipComponent, TooltipComponentConfig settings) {
        TOOLTIP_COMPONENT_HOLDERS.add(new TooltipComponentHolder(tooltipComponent, settings));
    }

    public static List<class_2561> getTooltipLines(class_1799 itemStack, @Nullable class_1937 level, int maxLines) {
        boolean includeLastLine;
        List<TooltipComponentHolder> holders = TOOLTIP_COMPONENT_HOLDERS.stream().filter(TooltipComponentHolder::include).collect(Collectors.toList());
        class_1792.class_9635 tooltipContext = class_1792.class_9635.method_59528((class_1937)level);
        holders.forEach(holder -> holder.rebuildIfNecessary(itemStack, tooltipContext));
        boolean bl = includeLastLine = ((ClientConfig)HeldItemTooltips.CONFIG.get(ClientConfig.class)).lastLine && maxLines > 1;
        if (holders.stream().mapToInt(TooltipComponentHolder::size).sum() > maxLines && includeLastLine) {
            --maxLines;
        }
        holders.sort(Comparator.comparingInt(TooltipComponentHolder::priority).reversed());
        for (TooltipComponentHolder holder2 : holders) {
            maxLines = holder2.subtractLines(maxLines);
        }
        holders.sort(Comparator.comparingInt(TooltipComponentHolder::ordering));
        List<class_2561> tooltipLines = holders.stream().map(TooltipComponentHolder::getLines).flatMap(Collection::stream).collect(Collectors.toList());
        maxLines = HoverTextManager.getAdditionalTooltipLines(itemStack, tooltipLines, tooltipContext, maxLines);
        if (includeLastLine && maxLines < 0) {
            tooltipLines.add((class_2561)class_2561.method_43469((String)"item.container.more_items", (Object[])new Object[]{-maxLines}).method_27695(new class_124[]{class_124.field_1080, class_124.field_1056}));
        }
        return tooltipLines;
    }

    public static void reset() {
        TOOLTIP_COMPONENT_HOLDERS.forEach(TooltipComponentHolder::clear);
    }

    private static int getAdditionalTooltipLines(class_1799 itemStack, List<class_2561> tooltipLines, class_1792.class_9635 tooltipContext, int maxLines) {
        if (!((ClientConfig)HeldItemTooltips.CONFIG.get(ClientConfig.class)).additionalTooltipLines) {
            return maxLines;
        }
        int oldSize = tooltipLines.size();
        ClientAbstractions.INSTANCE.onItemTooltip(itemStack, tooltipLines, tooltipContext, (class_1836)class_1836.class_1837.field_41070);
        if (tooltipLines.size() - oldSize > Math.max(maxLines, 0)) {
            tooltipLines.subList(oldSize + Math.max(maxLines, 0), tooltipLines.size()).clear();
        }
        return maxLines - (tooltipLines.size() - oldSize);
    }
}

