/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.compile.estimation;

import java.util.Locale;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.estimation.Estimator;
import net.caffeinemc.mods.sodium.client.util.MathUtil;

public abstract class Average1DEstimator<C>
extends Estimator<C, Value<C>, ValueBatch<C>, Void, Long, Average<C>> {
    private final double newDataRatio;
    private final long initialEstimate;

    public Average1DEstimator(double newDataRatio, long initialEstimate) {
        this.newDataRatio = newDataRatio;
        this.initialEstimate = initialEstimate;
    }

    @Override
    protected ValueBatch<C> createNewDataBatch() {
        return new ValueBatch();
    }

    @Override
    protected Average<C> createNewModel() {
        return new Average(this.newDataRatio, this.initialEstimate);
    }

    public Long predict(C category) {
        return (Long)super.predict(category, null);
    }

    protected static class ValueBatch<BatchCategory>
    implements Estimator.DataBatch<Value<BatchCategory>> {
        private long valueSum;
        private long count;

        protected ValueBatch() {
        }

        @Override
        public void addDataPoint(Value<BatchCategory> input) {
            this.valueSum += input.value();
            ++this.count;
        }

        @Override
        public void reset() {
            this.valueSum = 0L;
            this.count = 0L;
        }

        public double getAverage() {
            return (double)this.valueSum / (double)this.count;
        }
    }

    protected static class Average<C>
    implements Estimator.Model<Void, Long, ValueBatch<C>> {
        private final double newDataRatio;
        private boolean hasRealData = false;
        private double average;

        public Average(double newDataRatio, double initialValue) {
            this.average = initialValue;
            this.newDataRatio = newDataRatio;
        }

        @Override
        public void update(ValueBatch<C> batch) {
            if (batch.count > 0L) {
                if (this.hasRealData) {
                    this.average = MathUtil.exponentialMovingAverage(this.average, batch.getAverage(), this.newDataRatio);
                } else {
                    this.average = batch.getAverage();
                    this.hasRealData = true;
                }
            }
        }

        @Override
        public Long predict(Void input) {
            return (long)this.average;
        }

        public String toString() {
            return String.format(Locale.US, "%.0f", this.average);
        }
    }

    public static interface Value<PointCategory>
    extends Estimator.DataPoint<PointCategory> {
        public long value();
    }
}

