/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture.render;

import com.mojang.serialization.MapCodec;
import java.util.Set;
import java.util.UUID;
import me.chrr.camerapture.item.PictureItem;
import me.chrr.camerapture.picture.ClientPictureStore;
import me.chrr.camerapture.picture.RemotePicture;
import net.minecraft.class_10515;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5599;
import net.minecraft.class_811;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class PictureItemRenderer
implements class_10515<UUID> {
    public static boolean canRender(class_1799 stack) {
        PictureItem.PictureData pictureData = PictureItem.getPictureData(stack);
        if (pictureData == null) {
            return false;
        }
        RemotePicture picture = ClientPictureStore.getInstance().getServerPicture(pictureData.id());
        return picture.getStatus() == RemotePicture.Status.SUCCESS;
    }

    public void render(@Nullable UUID data, class_811 displayContext, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay, boolean glint) {
        if (data == null) {
            return;
        }
        RemotePicture picture = ClientPictureStore.getInstance().getServerPicture(data);
        matrices.method_22903();
        matrices.method_46416(0.0f, 0.0f, 0.5f);
        matrices.method_46416(0.0625f, 0.0625f, 0.0f);
        matrices.method_22905(0.875f, 0.875f, 0.875f);
        if (picture.getWidth() > picture.getHeight()) {
            float height = (float)picture.getHeight() / (float)picture.getWidth();
            matrices.method_46416(0.0f, (1.0f - height) / 2.0f, 0.0f);
            matrices.method_22905(1.0f, height, 1.0f);
        } else {
            float width = (float)picture.getWidth() / (float)picture.getHeight();
            matrices.method_46416((1.0f - width) / 2.0f, 0.0f, 0.0f);
            matrices.method_22905(width, 1.0f, 1.0f);
        }
        class_1921 renderLayer = class_1921.method_23578((class_2960)picture.getTextureIdentifier());
        class_4588 buffer = vertexConsumers.getBuffer(renderLayer);
        class_4587.class_4665 matrix = matrices.method_23760();
        Matrix4f matrix4f = matrix.method_23761();
        buffer.method_22918(matrix4f, 1.0f, 0.0f, 0.0f).method_39415(-1).method_22913(1.0f, 1.0f).method_22922(overlay).method_60803(light).method_60831(matrix, 0.0f, 0.0f, 1.0f);
        buffer.method_22918(matrix4f, 1.0f, 1.0f, 0.0f).method_39415(-1).method_22913(1.0f, 0.0f).method_22922(overlay).method_60803(light).method_60831(matrix, 0.0f, 0.0f, 1.0f);
        buffer.method_22918(matrix4f, 0.0f, 1.0f, 0.0f).method_39415(-1).method_22913(0.0f, 0.0f).method_22922(overlay).method_60803(light).method_60831(matrix, 0.0f, 0.0f, 1.0f);
        buffer.method_22918(matrix4f, 0.0f, 0.0f, 0.0f).method_39415(-1).method_22913(0.0f, 1.0f).method_22922(overlay).method_60803(light).method_60831(matrix, 0.0f, 0.0f, 1.0f);
        matrices.method_22909();
    }

    public void method_72175(Set<Vector3f> vertices) {
        vertices.add(new Vector3f(1.0f, 0.0f, 0.0f));
        vertices.add(new Vector3f(1.0f, 1.0f, 0.0f));
        vertices.add(new Vector3f(0.0f, 1.0f, 0.0f));
        vertices.add(new Vector3f(0.0f, 0.0f, 0.0f));
    }

    @Nullable
    public UUID getData(class_1799 stack) {
        PictureItem.PictureData pictureData = PictureItem.getPictureData(stack);
        return pictureData != null ? pictureData.id() : null;
    }

    public static class Unbaked
    implements class_10515.class_10516 {
        public static final MapCodec<Unbaked> MAP_CODEC = MapCodec.unit(Unbaked::new);

        public class_10515<UUID> method_65698(class_5599 entityModels) {
            return new PictureItemRenderer();
        }

        public MapCodec<Unbaked> method_65696() {
            return MAP_CODEC;
        }
    }
}

