/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.integration.eiv.cooking_pot;

import de.crafty.eiv.common.api.recipe.IEivRecipeViewType;
import de.crafty.eiv.common.api.recipe.IEivViewRecipe;
import de.crafty.eiv.common.recipe.inventory.RecipeViewMenu;
import de.crafty.eiv.common.recipe.inventory.RecipeViewScreen;
import de.crafty.eiv.common.recipe.inventory.SlotContent;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import vectorwing.farmersdelight.client.gui.CookingPotScreen;
import vectorwing.farmersdelight.common.utility.ClientRenderUtils;
import vectorwing.farmersdelight.integration.eiv.cooking_pot.CookingPotServerRecipe;
import vectorwing.farmersdelight.integration.eiv.cooking_pot.CookingPotViewType;

public class CookingPotViewRecipe
implements IEivViewRecipe {
    private final SlotContent result;
    private final List<SlotContent> ingredients = new ArrayList<SlotContent>();
    private final SlotContent container;
    private final int cookTime;
    private final float experience;

    public CookingPotViewRecipe(CookingPotServerRecipe shapelessRecipe) {
        shapelessRecipe.getIngredients().forEach(ingredient -> this.ingredients.add(SlotContent.of((class_1856)ingredient)));
        this.result = SlotContent.of((class_1799)shapelessRecipe.getResult());
        this.container = SlotContent.of((class_1799)shapelessRecipe.getContainer());
        this.experience = shapelessRecipe.getExperience();
        this.cookTime = shapelessRecipe.getCookTime();
        this.container.setType(SlotContent.Type.RESULT);
    }

    public IEivRecipeViewType getViewType() {
        return CookingPotViewType.INSTANCE;
    }

    public void bindSlots(RecipeViewMenu.SlotFillContext slotFillContext) {
        for (int i = 0; i < this.ingredients.size() && i < 6; ++i) {
            slotFillContext.bindSlot(i, this.ingredients.get(i));
        }
        slotFillContext.bindSlot(6, this.result);
        slotFillContext.bindSlot(7, this.container);
    }

    public void renderRecipe(RecipeViewScreen screen, IEivViewRecipe.RecipePosition recipePosition, class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        guiGraphics.method_51427(this.result.getByIndex(0), 103, 17);
        if (mouseX > 65 && mouseX < 90 && mouseY < 37 && mouseY > 5) {
            ArrayList<class_5250> tooltip = new ArrayList<class_5250>();
            if (this.cookTime > 0) {
                tooltip.add(class_2561.method_43469((String)"eiv.cooking.time", (Object[])new Object[]{this.cookTime / 20}));
            }
            if (this.experience > 0.0f) {
                tooltip.add(class_2561.method_43469((String)"eiv.cooking.experience", (Object[])new Object[]{Float.valueOf(this.experience)}));
            }
            guiGraphics.method_64038(class_310.method_1551().field_1772, tooltip, Optional.empty(), mouseX, mouseY);
        }
        if (ClientRenderUtils.isCursorInsideBounds(103, 17, 18, 18, mouseX, mouseY)) {
            guiGraphics.method_51446(class_310.method_1551().field_1772, this.result.getByIndex(0), mouseX, mouseY);
        }
    }

    public List<SlotContent> getIngredients() {
        return this.ingredients;
    }

    public List<SlotContent> getResults() {
        return List.of(this.result);
    }

    public boolean supportsItemTransfer() {
        return true;
    }

    public void mapRecipeItems(IEivViewRecipe.RecipeTransferMap transferMap, class_465<?> screen) {
        for (int i = 0; i < this.ingredients.size() && i < 6; ++i) {
            transferMap.linkSlots(i, i);
        }
        transferMap.linkSlots(7, 7);
    }

    public List<Class<? extends class_465<?>>> getTransferClasses() {
        return List.of(CookingPotScreen.class);
    }

    public boolean canTransferToScreen(class_465<?> screen) {
        return screen instanceof CookingPotScreen;
    }
}

