/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.vanillin;

import com.zurrtum.create.client.vanillin.VanillinXplat;
import com.zurrtum.create.client.vanillin.VisualElements;
import com.zurrtum.create.client.vanillin.compose.ComposableEntityVisual;
import com.zurrtum.create.client.vanillin.compose.ConfiguredElement;
import com.zurrtum.create.client.vanillin.compose.ConfiguredElementImpl;
import com.zurrtum.create.client.vanillin.compose.VisualElement;
import com.zurrtum.create.client.vanillin.compose.VisualizationPredicate;
import com.zurrtum.create.client.vanillin.config.BlockEntityVisualizerBuilder;
import com.zurrtum.create.client.vanillin.config.Configurator;
import com.zurrtum.create.client.vanillin.config.EntityVisualizerBuilder;
import com.zurrtum.create.client.vanillin.elements.ShadowElement;
import com.zurrtum.create.client.vanillin.visuals.BellVisual;
import com.zurrtum.create.client.vanillin.visuals.BlockDisplayVisual;
import com.zurrtum.create.client.vanillin.visuals.ChestVisual;
import com.zurrtum.create.client.vanillin.visuals.ItemDisplayVisual;
import com.zurrtum.create.client.vanillin.visuals.ItemFrameVisual;
import com.zurrtum.create.client.vanillin.visuals.ItemVisual;
import com.zurrtum.create.client.vanillin.visuals.MinecartVisual;
import com.zurrtum.create.client.vanillin.visuals.ShulkerBoxVisual;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1533;
import net.minecraft.class_1688;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_5601;
import net.minecraft.class_5602;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class VanillaVisuals {
    public static final Configurator CONFIGURATOR = new Configurator();
    public static final boolean STABLE = true;
    public static final boolean EXPERIMENTAL = VanillinXplat.INSTANCE.isDevelopmentEnvironment();

    public static void init() {
        VanillaVisuals.builder(class_2591.field_11914).factory(ChestVisual::new).apply(true);
        VanillaVisuals.builder(class_2591.field_11901).factory(ChestVisual::new).apply(true);
        VanillaVisuals.builder(class_2591.field_11891).factory(ChestVisual::new).apply(true);
        VanillaVisuals.builder(class_2591.field_16413).factory(BellVisual::new).apply(true);
        VanillaVisuals.builder(class_2591.field_11896).factory(ShulkerBoxVisual::new).apply(true);
        VanillaVisuals.builder(class_1299.field_42460).factory(BlockDisplayVisual::new).apply(true);
        VanillaVisuals.composable(class_1299.field_42456).with(VanillaVisuals.element(VisualElements.ITEM_DISPLAY).build()).shouldVisualize((ctx, e) -> ItemDisplayVisual.shouldVisualize(e)).build().skipVanillaRender(ItemDisplayVisual::shouldVisualize).apply(EXPERIMENTAL);
        VanillaVisuals.minecart(class_1299.field_6126, class_5602.field_27690).apply(true);
        VanillaVisuals.minecart(class_1299.field_6136, class_5602.field_27693).apply(true);
        VanillaVisuals.minecart(class_1299.field_6080, class_5602.field_27567).apply(true);
        VanillaVisuals.minecart(class_1299.field_6058, class_5602.field_27601).apply(true);
        VanillaVisuals.minecart(class_1299.field_6096, class_5602.field_27614).apply(true);
        VanillaVisuals.minecart(class_1299.field_6142, class_5602.field_27657).apply(true);
        VanillaVisuals.composable(class_1299.field_6053).apply(VanillaVisuals::commonElements).with(VanillaVisuals.element(VisualElements.SHADOW).configure(new ShadowElement.Config(0.7f, 1.0f)).build()).with(VanillaVisuals.element(VisualElements.FIRE).build()).with(VanillaVisuals.element(VisualElements.TNT_MINECART).build()).build().skipVanillaRender(MinecartVisual::shouldSkipRender).apply(true);
        VanillaVisuals.itemFrame(class_1299.field_6043).apply(EXPERIMENTAL);
        VanillaVisuals.itemFrame(class_1299.field_28401).apply(EXPERIMENTAL);
        VanillaVisuals.composable(class_1299.field_6052).apply(VanillaVisuals::commonElements).with(VanillaVisuals.element(VisualElements.FIRE).build()).with(VanillaVisuals.element(VisualElements.SHADOW).configure(new ShadowElement.Config(0.15f, 0.75f)).build()).with(VanillaVisuals.element(VisualElements.ITEM_ENTITY).build()).shouldVisualize((ctx, entity) -> ItemVisual.isSupported(entity)).build().skipVanillaRender(ItemVisual::isSupported).apply(EXPERIMENTAL);
    }

    public static <T extends class_1297> void commonElements(EntityBuilder<T> builder) {
        builder.with(VanillaVisuals.element(VisualElements.HITBOX).configure(false).build());
    }

    public static <T extends class_1533> EntityVisualizerBuilder<T> itemFrame(class_1299<T> type) {
        return VanillaVisuals.composable(type).apply(VanillaVisuals::commonElements).with(VanillaVisuals.element(VisualElements.ITEM_FRAME).build()).shouldVisualize((ctx, entity) -> ItemFrameVisual.shouldVisualize(entity)).build().skipVanillaRender(ItemFrameVisual::shouldVisualize);
    }

    public static <T extends class_1688> EntityVisualizerBuilder<T> minecart(class_1299<T> type, class_5601 variant) {
        return VanillaVisuals.composable(type).apply(VanillaVisuals::commonElements).with(VanillaVisuals.element(VisualElements.SHADOW).configure(new ShadowElement.Config(0.7f, 1.0f)).build()).with(VanillaVisuals.element(VisualElements.FIRE).build()).with(VanillaVisuals.element(VisualElements.MINECART).configure(variant).build()).build().skipVanillaRender(MinecartVisual::shouldSkipRender);
    }

    public static <T extends class_1297> EntityBuilder<T> composable(class_1299<T> entityType) {
        return new EntityBuilder<T>(entityType);
    }

    public static <T, C> ConfiguredElementImpl.ConfiguredElementBuilder<T, C> element(VisualElement<T, C> element) {
        return new ConfiguredElementImpl.ConfiguredElementBuilder<T, C>(element);
    }

    public static <T extends class_2586> BlockEntityVisualizerBuilder<T> builder(class_2591<T> type) {
        return new BlockEntityVisualizerBuilder<T>(CONFIGURATOR, type);
    }

    public static <T extends class_1297> EntityVisualizerBuilder<T> builder(class_1299<T> type) {
        return new EntityVisualizerBuilder<T>(CONFIGURATOR, type);
    }

    @Environment(value=EnvType.CLIENT)
    public static class EntityBuilder<T extends class_1297> {
        private final List<ConfiguredElement<? super T>> elements = new ArrayList<ConfiguredElement<? super T>>();
        private final class_1299<T> entityType;
        @Nullable
        private VisualizationPredicate<T> predicate;

        public EntityBuilder(class_1299<T> entityType) {
            this.entityType = entityType;
        }

        public EntityBuilder<T> shouldVisualize(VisualizationPredicate<T> predicate) {
            this.predicate = predicate;
            return this;
        }

        public EntityBuilder<T> with(ConfiguredElement<? super T> element) {
            this.elements.add(element);
            return this;
        }

        public EntityBuilder<T> apply(Consumer<EntityBuilder<T>> mutate) {
            mutate.accept(this);
            return this;
        }

        public EntityVisualizerBuilder<T> build() {
            ConfiguredElement[] elementsArray = this.elements.toArray(new ConfiguredElement[0]);
            if (this.predicate == null) {
                this.predicate = VisualizationPredicate.alwaysTrue();
            }
            ComposableEntityVisual.Controller controller = new ComposableEntityVisual.Controller(elementsArray, this.predicate);
            return VanillaVisuals.builder(this.entityType).factory((ctx, entity, partialTick) -> new ComposableEntityVisual<class_1297>(ctx, entity, partialTick, controller));
        }
    }
}

