/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.lib.visualization;

import com.zurrtum.create.client.flywheel.api.visual.BlockEntityVisual;
import com.zurrtum.create.client.flywheel.api.visualization.BlockEntityVisualizer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizerRegistry;
import java.util.Objects;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class SimpleBlockEntityVisualizer<T extends class_2586>
implements BlockEntityVisualizer<T> {
    private final Factory<T> visualFactory;
    private final Predicate<T> skipVanillaRender;

    public SimpleBlockEntityVisualizer(Factory<T> visualFactory, Predicate<T> skipVanillaRender) {
        this.visualFactory = visualFactory;
        this.skipVanillaRender = skipVanillaRender;
    }

    @Override
    public BlockEntityVisual<? super T> createVisual(VisualizationContext ctx, T blockEntity, float partialTick) {
        return this.visualFactory.create(ctx, blockEntity, partialTick);
    }

    @Override
    public boolean skipVanillaRender(T blockEntity) {
        return this.skipVanillaRender.test(blockEntity);
    }

    public static <T extends class_2586> Builder<T> builder(class_2591<T> type) {
        return new Builder<T>(type);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface Factory<T extends class_2586> {
        public BlockEntityVisual<? super T> create(VisualizationContext var1, T var2, float var3);
    }

    @Environment(value=EnvType.CLIENT)
    public static final class Builder<T extends class_2586> {
        private final class_2591<T> type;
        @Nullable
        private Factory<T> visualFactory;
        @Nullable
        private Predicate<T> skipVanillaRender;

        public Builder(class_2591<T> type) {
            this.type = type;
        }

        public Builder<T> factory(Factory<T> visualFactory) {
            this.visualFactory = visualFactory;
            return this;
        }

        public Builder<T> skipVanillaRender(Predicate<T> skipVanillaRender) {
            this.skipVanillaRender = skipVanillaRender;
            return this;
        }

        public Builder<T> neverSkipVanillaRender() {
            this.skipVanillaRender = blockEntity -> false;
            return this;
        }

        public SimpleBlockEntityVisualizer<T> apply() {
            Objects.requireNonNull(this.visualFactory, "Visual factory cannot be null!");
            if (this.skipVanillaRender == null) {
                this.skipVanillaRender = blockEntity -> true;
            }
            SimpleBlockEntityVisualizer<T> visualizer = new SimpleBlockEntityVisualizer<T>(this.visualFactory, this.skipVanillaRender);
            VisualizerRegistry.setVisualizer(this.type, visualizer);
            return visualizer;
        }
    }
}

