/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.compat.rei.renderer;

import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllFluids;
import com.zurrtum.create.client.AllFluidConfigs;
import com.zurrtum.create.client.infrastructure.fluid.FluidConfig;
import com.zurrtum.create.content.fluids.potion.PotionFluidHandler;
import com.zurrtum.create.infrastructure.component.BottleType;
import dev.architectury.fluid.FluidStack;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.entry.renderer.EntryRenderer;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.common.entry.EntryStack;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_156;
import net.minecraft.class_1844;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3611;
import net.minecraft.class_7923;
import net.minecraft.class_9334;
import net.minecraft.class_9335;
import net.minecraft.class_9473;

@Environment(value=EnvType.CLIENT)
public record FluidStackRenderer(EntryRenderer<FluidStack> origin) implements EntryRenderer<FluidStack>
{
    public void render(EntryStack<FluidStack> entry, class_332 graphics, Rectangle bounds, int mouseX, int mouseY, float delta) {
        FluidStack stack = (FluidStack)entry.getValue();
        class_3611 fluid = stack.getFluid();
        FluidConfig config = AllFluidConfigs.get(fluid);
        if (config == null) {
            return;
        }
        int color = config.tint().apply(stack.getComponents().method_57940()) | 0xFF000000;
        graphics.method_52710(class_10799.field_56883, config.still().get(), bounds.x, bounds.y, bounds.width, bounds.height, color);
    }

    public Tooltip getTooltip(EntryStack<FluidStack> entry, TooltipContext context) {
        Tooltip tooltip = this.origin.getTooltip(entry, context);
        if (tooltip == null) {
            return null;
        }
        List entries = tooltip.entries();
        Tooltip.Entry first = (Tooltip.Entry)entries.getFirst();
        if (first.isText()) {
            FluidStack stack = (FluidStack)entry.getValue();
            if (stack.getFluid() == AllFluids.POTION) {
                class_9335 components = stack.getComponents();
                class_1844 contents = (class_1844)components.method_58695(class_9334.field_49651, (Object)class_1844.field_49274);
                BottleType bottleType = (BottleType)((Object)components.method_58695(AllDataComponents.POTION_FLUID_BOTTLE_TYPE, (Object)BottleType.REGULAR));
                class_2561 name = contents.method_64195(PotionFluidHandler.itemFromBottleType(bottleType).method_7876() + ".effect.");
                ArrayList<Tooltip.Entry> list = new ArrayList<Tooltip.Entry>();
                list.add(Tooltip.entry((class_2561)name));
                contents.method_57409(context.vanillaContext(), text -> list.add(Tooltip.entry((class_2561)text)), context.getFlag(), (class_9473)components);
                entries.removeFirst();
                entries.addAll(0, list);
            } else {
                class_2561 name = first.getAsText();
                if (name.getString().startsWith("block.")) {
                    entries.removeFirst();
                    entries.addFirst(Tooltip.entry((class_2561)class_2561.method_43471((String)class_156.method_646((String)"fluid", (class_2960)class_7923.field_41173.method_10221((Object)((FluidStack)entry.getValue()).getFluid())))));
                }
            }
        }
        return tooltip;
    }
}

