/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.control.collection;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_2561;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.IGuiParent;
import team.creative.creativecore.common.gui.control.parent.GuiColumn;
import team.creative.creativecore.common.gui.control.parent.GuiRow;
import team.creative.creativecore.common.gui.control.parent.GuiScrollY;
import team.creative.creativecore.common.gui.control.simple.GuiButton;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;

public class GuiListBoxBase<T extends GuiControl>
extends GuiScrollY {
    protected List<GuiRow> rows = new ArrayList<GuiRow>();
    protected List<T> content;
    public final boolean modifiable;
    public Predicate<T> canBeModified = x -> true;

    public GuiListBoxBase(IGuiParent parent, String name, boolean modifiable, List<T> entries) {
        super(parent, name);
        this.content = entries;
        this.modifiable = modifiable;
        this.createItems();
    }

    @Override
    public GuiListBoxBaseDist dist() {
        return (GuiListBoxBaseDist)super.dist();
    }

    protected void createItems() {
        for (int i = 0; i < this.content.size(); ++i) {
            this.createControl(i);
        }
    }

    protected void createControl(int index) {
        GuiRow row = new GuiRow(this);
        super.add((GuiControl)row);
        GuiColumn content = (GuiColumn)new GuiColumn(this).setExpandableX();
        content.setAlign(Align.CENTER);
        content.add((GuiControl)this.content.get(index));
        row.addColumn(content);
        if (this.modifiable && this.canBeModified.test((GuiControl)this.content.get(index))) {
            GuiColumn remove = new GuiColumn((IGuiParent)this, 20);
            remove.setAlign(Align.CENTER);
            remove.add((GuiControl)new GuiButtonRemove(this, index));
            row.addColumn(remove);
        }
        this.rows.add(row);
    }

    protected void removeControl(int index) {
        this.remove(this.rows.get(index));
        this.rows.remove(index);
        this.content.remove(index);
    }

    public GuiControl addCustomControl(GuiControl control) {
        return super.add(control);
    }

    @Override
    @Deprecated
    public GuiParent add(GuiControl control) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public GuiParent addHover(GuiControl control) {
        throw new UnsupportedOperationException();
    }

    public void removeItem(int index) {
        this.removeControl(index);
        if (this.modifiable) {
            for (int i = 0; i < this.rows.size(); ++i) {
                if (!this.canBeModified.test((GuiControl)this.content.get(i))) continue;
                ((GuiButtonRemove)this.rows.get((int)i).getCol((int)1).get((String)"x")).index = i;
            }
        }
        if (this.dist() != null) {
            this.dist().reflowInternal();
        }
        this.raiseEvent(new GuiControlChangedEvent<GuiListBoxBase>(this));
    }

    public void clearItems() {
        while (!this.content.isEmpty()) {
            this.removeControl(this.content.size() - 1);
        }
    }

    public void addAllItems(List<T> entries) {
        for (GuiControl entry : entries) {
            this.content.add(entry);
            this.createControl(this.content.size() - 1);
        }
        if (this.dist() != null) {
            this.dist().reflowInternal();
        }
    }

    public void addItem(T entry) {
        this.content.add(entry);
        this.createControl(this.content.size() - 1);
        if (this.dist() != null) {
            this.dist().reflowInternal();
        }
        this.raiseEvent(new GuiControlChangedEvent<GuiListBoxBase>(this));
    }

    public boolean isListEmpty() {
        return this.content.isEmpty();
    }

    public int itemSize() {
        return this.content.size();
    }

    public T getItem(int index) {
        return (T)((GuiControl)this.content.get(index));
    }

    public Iterable<T> items() {
        return this.content;
    }

    public static interface GuiListBoxBaseDist
    extends GuiScrollY.GuiScrollYDist {
        public void reflowInternal();
    }

    public class GuiButtonRemove
    extends GuiButton {
        public int index;

        public GuiButtonRemove(IGuiParent parent, int index) {
            super(parent, "x", null);
            this.setDim(6, 8);
            this.setAlign(Align.CENTER);
            this.setTitle((class_2561)class_2561.method_43470((String)"x"));
            this.setPressed(x -> GuiListBoxBase.this.removeItem(this.index));
            this.index = index;
        }
    }
}

