/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.gui.control.simple;

import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_6880;
import team.creative.creativecore.client.gui.GuiClientControl;
import team.creative.creativecore.client.render.gui.CreativeGuiGraphics;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.control.simple.GuiSeekBar;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.parser.LongValueParser;
import team.creative.creativecore.common.gui.style.ControlFormatting;

public class GuiClientSeekBar<T extends GuiSeekBar>
extends GuiClientControl<T>
implements GuiSeekBar.GuiSeekBarDist {
    private LongSupplier posSupplier;
    private LongSupplier maxSupplier;
    public LongConsumer timeUpdate;
    public LongConsumer lastTimeUpdate;
    private long pos;
    private long max;
    public LongValueParser parser;
    public boolean grabbedSlider;

    public GuiClientSeekBar(T control) {
        super(control);
    }

    @Override
    public void init(LongSupplier posSupplier, LongSupplier maxSupplier, LongValueParser parser) {
        this.posSupplier = posSupplier;
        this.maxSupplier = maxSupplier;
        this.parser = parser;
    }

    @Override
    public void setOnTimeUpdate(LongConsumer consumer) {
        this.timeUpdate = consumer;
    }

    @Override
    public void setOnLastTimeUpdate(LongConsumer consumer) {
        this.lastTimeUpdate = consumer;
    }

    @Override
    public void setPosition(long value, boolean notify) {
        if (this.pos >= this.max) {
            value = this.max;
        }
        this.timeUpdate.accept(value);
        this.pos = value;
        if (this.getParent() != null && notify) {
            this.raiseEvent(new GuiControlChangedEvent<GuiControl>(this.control));
        }
    }

    @Override
    protected void renderContent(class_332 graphics, int mouseX, int mouseY) {
        double percent = this.max > 0L ? (double)this.pos / (double)this.max : 0.0;
        this.renderProgress(graphics, percent);
        ((CreativeGuiGraphics)graphics).drawStringCentered(this.parser.parse(this.pos, this.max), this.rect.getContentWidth(), this.rect.getContentHeight(), this.getStyle().fontColor.toInt(), true);
    }

    protected void renderProgress(class_332 graphics, double percent) {
        this.getStyle().clickable.render(graphics, 0.0, 0.0, (double)this.rect.getContentWidth() * Math.min(percent, 1.0), this.rect.getContentHeight());
    }

    @Override
    public boolean mouseClicked(double x, double y, int button) {
        if (button == 0) {
            this.playSound((class_6880.class_6883<class_3414>)class_3417.field_15015);
            this.grabbedSlider = this.max > 0L;
            this.mouseMoved(x, y);
            return true;
        }
        return false;
    }

    @Override
    public void mouseMoved(double x, double y) {
        if (this.grabbedSlider) {
            long value;
            int width = this.rect.getWidth() - this.getContentOffset() * 2;
            if (x < (double)this.getContentOffset()) {
                value = 0L;
            } else if (x > (double)(this.getContentOffset() + width)) {
                value = this.maxSupplier.getAsLong();
            } else {
                int mouseOffsetX = (int)(x - (double)this.getContentOffset());
                value = (long)((float)this.maxSupplier.getAsLong() * ((float)mouseOffsetX / (float)width));
            }
            this.setPosition(value, true);
        }
    }

    @Override
    public void mouseReleased(double x, double y, int button) {
        if (this.grabbedSlider) {
            this.lastTimeUpdate.accept(this.pos);
            this.grabbedSlider = false;
        }
    }

    @Override
    public void tick() {
        if (!this.grabbedSlider) {
            this.pos = this.posSupplier.getAsLong();
            this.max = this.maxSupplier.getAsLong();
        }
    }

    @Override
    protected ControlFormatting defaultFormatting() {
        return ControlFormatting.PROGRESSBAR;
    }

    @Override
    public void flowX(int width, int preferred) {
    }

    @Override
    public void flowY(int width, int height, int preferred) {
    }

    @Override
    protected int preferredWidth(int availableWidth) {
        return 40;
    }

    @Override
    protected int preferredHeight(int width, int availableHeight) {
        return 14;
    }
}

