/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.globalxp.xpblock;

import bl4ckscor3.mod.globalxp.GlobalXP;
import bl4ckscor3.mod.globalxp.XPUtils;
import bl4ckscor3.mod.globalxp.xpblock.XPBlock;
import com.google.common.math.IntMath;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1275;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1303;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_7225;
import net.minecraft.class_8824;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import net.minecraft.class_9473;

public class XPBlockEntity
extends class_2586
implements class_1275 {
    private class_2561 name;
    private int storedXP = 0;
    private float storedLevels = 0.0f;
    private boolean destroyedByCreativePlayer;

    public XPBlockEntity(class_2338 pos, class_2680 state) {
        super(GlobalXP.XP_BLOCK_ENTITY_TYPE, pos, state);
    }

    public int addXP(int amount) {
        int space = Integer.MAX_VALUE - this.storedXP;
        this.storedXP = IntMath.saturatedAdd((int)this.storedXP, (int)amount);
        this.storedLevels = XPUtils.calculateStoredLevels(this.storedXP);
        this.method_5431();
        this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 2);
        if (amount > space) {
            return amount - space;
        }
        return 0;
    }

    public int removeXP(int amount) {
        int amountRemoved = Math.min(amount, this.storedXP);
        if (amountRemoved <= 0) {
            return 0;
        }
        this.storedXP -= amountRemoved;
        this.storedLevels = XPUtils.calculateStoredLevels(this.storedXP);
        this.method_5431();
        this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 2);
        return amountRemoved;
    }

    public class_2487 method_16887(class_7225.class_7874 lookupProvider) {
        return this.method_58692(lookupProvider);
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public void setStoredXP(int xp) {
        this.storedXP = xp;
        this.storedLevels = XPUtils.calculateStoredLevels(this.storedXP);
        this.method_5431();
        if (this.field_11863 != null) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 2);
        }
    }

    public int getStoredXP() {
        return this.storedXP;
    }

    public float getStoredLevels() {
        return this.storedLevels;
    }

    public void setDestroyedByCreativePlayer(boolean destroyedByCreativePlayer) {
        this.destroyedByCreativePlayer = destroyedByCreativePlayer;
    }

    public boolean isDestroyedByCreativePlayer() {
        return this.destroyedByCreativePlayer;
    }

    public void method_11007(class_11372 tag) {
        tag.method_71465("stored_xp", this.storedXP);
        tag.method_71477("CustomName", class_8824.field_46597, (Object)this.name);
    }

    public void method_11014(class_11368 tag) {
        super.method_11014(tag);
        this.setStoredXP(tag.method_71424("stored_xp", 0));
        this.name = tag.method_71426("CustomName", class_8824.field_46597).orElse(null);
    }

    protected void method_57568(class_9473 getter) {
        super.method_57568(getter);
        this.name = (class_2561)getter.method_58694(class_9334.field_49631);
        this.setStoredXP((Integer)getter.method_58695(GlobalXP.STORED_XP, (Object)0));
    }

    public void method_57569(class_11372 tag) {
        tag.method_71478("CustomName");
        tag.method_71478("stored_xp");
    }

    protected void method_57567(class_9323.class_9324 builder) {
        super.method_57567(builder);
        builder.method_57840(class_9334.field_49631, (Object)this.name);
        builder.method_57840(GlobalXP.STORED_XP, (Object)this.storedXP);
    }

    public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, XPBlockEntity be) {
        if (level.method_8510() % 5L == 0L && GlobalXP.CONFIG.pickupXP && !((Boolean)state.method_11654((class_2769)XPBlock.POWERED)).booleanValue()) {
            be.pickupDroppedXP();
        }
    }

    private void pickupDroppedXP() {
        for (class_1303 orb : this.field_11863.method_8390(class_1303.class, this.getPickupArea(), class_1301.field_6154.and(e -> !e.method_5752().contains("GlobalXPMarker")))) {
            int amount = orb.method_5919();
            if (this.getStoredXP() + amount > this.getCapacity()) continue;
            int unused = this.addXP(amount);
            orb.method_31472();
            if (unused <= 0) continue;
            this.field_11863.method_8649((class_1297)new class_1303(this.field_11863, orb.method_23317(), orb.method_23318(), orb.method_23321(), unused));
        }
    }

    private class_238 getPickupArea() {
        double x = (double)this.method_11016().method_10263() + 0.5;
        double y = (double)this.method_11016().method_10264() + 0.5;
        double z = (double)this.method_11016().method_10260() + 0.5;
        double range = GlobalXP.CONFIG.pickupRange + 0.5;
        return new class_238(x - range, y - range, z - range, x + range, y + range, z + range);
    }

    public int getCapacity() {
        return Integer.MAX_VALUE;
    }

    public void setCustomName(class_2561 name) {
        this.name = name;
    }

    public class_2561 method_5477() {
        return this.name != null ? this.name : this.getDefaultName();
    }

    public class_2561 method_5476() {
        return this.method_5477();
    }

    public class_2561 method_5797() {
        return this.name;
    }

    public class_2561 getDefaultName() {
        return class_2561.method_43471((String)GlobalXP.XP_BLOCK.method_63499());
    }
}

