/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.config;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.electronwill.nightconfig.core.file.FileWatcher;
import com.mrcrayfish.framework.Constants;
import java.nio.file.Path;

public class ConfigWatcher {
    private static volatile ConfigWatcher instance;
    private final FileWatcher fileWatcher = new FileWatcher();

    public static synchronized ConfigWatcher get() {
        if (instance == null) {
            instance = new ConfigWatcher();
        }
        return instance;
    }

    public void watch(UnmodifiableConfig config, Runnable changeCallback) {
        if (config instanceof FileConfig) {
            FileConfig fileConfig = (FileConfig)config;
            Path path = fileConfig.getNioPath();
            try {
                this.fileWatcher.setWatch(path, changeCallback);
                Constants.LOG.debug("Started watching config: " + String.valueOf(path));
            }
            catch (Exception e) {
                Constants.LOG.debug("Failed to watch config: " + String.valueOf(path), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    public void unwatch(UnmodifiableConfig config) {
        if (config instanceof FileConfig) {
            FileConfig fileConfig = (FileConfig)config;
            Path path = fileConfig.getNioPath();
            try {
                this.fileWatcher.removeWatch(path);
                Constants.LOG.debug("Stopped watching config: " + String.valueOf(path));
            }
            catch (RuntimeException e) {
                Constants.LOG.debug("Failed to unwatch config: " + String.valueOf(path), (Throwable)e);
            }
        }
    }

    public void stop() {
        try {
            Constants.LOG.debug("Stopping config watcher");
            this.fileWatcher.stop();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

