/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.registry.display;

import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.impl.common.InternalLogger;

public class DisplayValidator {
    public static boolean validate(Display display) {
        CategoryIdentifier<?> identifier = display.getCategoryIdentifier();
        try {
            CategoryRegistry.CategoryConfiguration<?> configuration = CategoryRegistry.getInstance().get(identifier);
            try {
                DisplayCategory<?> category = configuration.getCategory();
                category.getDisplayWidth(display);
                return true;
            }
            catch (ClassCastException exception) {
                InternalLogger.getInstance().error("Display [%s] %s failed validation check for category [%s] %s", display.getDisplayLocation().orElse(null), display, identifier, configuration.getCategory());
                return false;
            }
        }
        catch (NullPointerException exception) {
            return true;
        }
        catch (Throwable throwable) {
            InternalLogger.getInstance().error("Display [%s] %s failed validation check for category [%s]".formatted(display.getDisplayLocation().orElse(null), display, identifier), throwable);
            return false;
        }
    }
}

