/*
 * Decompiled with CFR 0.152.
 */
package fuzs.forgeconfigapiport.fabric.impl;

import fuzs.forgeconfigapiport.fabric.api.v5.ConfigRegistry;
import fuzs.forgeconfigapiport.fabric.impl.handler.ServerLifecycleHandler;
import fuzs.forgeconfigapiport.fabric.impl.network.ConfigSync;
import fuzs.forgeconfigapiport.fabric.impl.network.configuration.SyncConfig;
import fuzs.forgeconfigapiport.fabric.impl.network.payload.ConfigFilePayload;
import fuzs.forgeconfigapiport.impl.services.CommonAbstractions;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.minecraft.class_8605;
import net.minecraft.class_8610;
import net.minecraftforge.common.ForgeConfigSpec;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.config.ModConfigs;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ForgeConfigAPIPortFabric
implements ModInitializer {
    public void onInitialize() {
        ForgeConfigAPIPortFabric.registerEventHandlers();
        ForgeConfigAPIPortFabric.registerMessages();
        ForgeConfigAPIPortFabric.setupDevelopmentEnvironment();
    }

    private static void registerEventHandlers() {
        ServerConfigurationConnectionEvents.CONFIGURE.register((handler, server) -> {
            if (ServerConfigurationNetworking.canSend((class_8610)handler, ConfigFilePayload.TYPE)) {
                handler.addTask((class_8605)new SyncConfig(handler));
            }
        });
        ServerLifecycleHandler.registerEventHandlers();
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> ModConfigs.getFileMap().values().forEach(config -> {
            IConfigSpec patt0$temp = config.getSpec();
            if (patt0$temp instanceof ModConfigSpec) {
                ModConfigSpec spec = (ModConfigSpec)patt0$temp;
                spec.resetCaches(ModConfigSpec.RestartType.WORLD);
            }
        }));
        ServerTickEvents.END_SERVER_TICK.register(ConfigSync::syncPendingConfigs);
        ConfigSync.registerEventListeners();
    }

    private static void registerMessages() {
        PayloadTypeRegistry.configurationS2C().register(ConfigFilePayload.TYPE, ConfigFilePayload.STREAM_CODEC);
        PayloadTypeRegistry.playS2C().register(ConfigFilePayload.TYPE, ConfigFilePayload.STREAM_CODEC);
        PayloadTypeRegistry.configurationC2S().register(ConfigFilePayload.TYPE, ConfigFilePayload.STREAM_CODEC);
        ServerConfigurationNetworking.registerGlobalReceiver(ConfigFilePayload.TYPE, (payload, context) -> {});
    }

    private static void setupDevelopmentEnvironment() {
        if (CommonAbstractions.INSTANCE.isDevelopmentEnvironment("forgeconfigapiport")) {
            ConfigRegistry.INSTANCE.register("forgeconfigapiport", ModConfig.Type.SERVER, new ModConfigSpec.Builder().comment("hello world").define("dummy_entry", true).next().build(), "forgeconfigapiport-server-neoforge.toml");
            ConfigRegistry.INSTANCE.register("forgeconfigapiport", ModConfig.Type.SERVER, new ForgeConfigSpec.Builder().comment("hello world").define("dummy_entry", true).next().build(), "forgeconfigapiport-server-forge.toml");
        }
    }
}

