/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.graph;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.ListBuilder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.zurrtum.create.Create;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.content.trains.graph.DimensionPalette;
import com.zurrtum.create.content.trains.graph.EdgeData;
import com.zurrtum.create.content.trains.graph.EdgePointManager;
import com.zurrtum.create.content.trains.graph.EdgePointStorage;
import com.zurrtum.create.content.trains.graph.EdgePointType;
import com.zurrtum.create.content.trains.graph.TrackEdge;
import com.zurrtum.create.content.trains.graph.TrackEdgeIntersection;
import com.zurrtum.create.content.trains.graph.TrackGraphBounds;
import com.zurrtum.create.content.trains.graph.TrackNode;
import com.zurrtum.create.content.trains.graph.TrackNodeLocation;
import com.zurrtum.create.content.trains.signal.SignalEdgeGroup;
import com.zurrtum.create.content.trains.signal.TrackEdgePoint;
import com.zurrtum.create.content.trains.track.BezierConnection;
import com.zurrtum.create.content.trains.track.TrackMaterial;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_4844;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

public class TrackGraph {
    public static final AtomicInteger graphNetIdGenerator = new AtomicInteger();
    public static final AtomicInteger nodeNetIdGenerator = new AtomicInteger();
    public UUID id;
    public Color color;
    public Map<TrackNodeLocation, TrackNode> nodes;
    Map<Integer, TrackNode> nodesById;
    public Map<TrackNode, Map<TrackNode, TrackEdge>> connectionsByNode;
    public EdgePointStorage edgePoints;
    Map<class_5321<class_1937>, TrackGraphBounds> bounds;
    List<TrackEdge> deferredIntersectionUpdates;
    public int netId;
    int checksum = 0;

    public TrackGraph() {
        this(UUID.randomUUID());
    }

    public TrackGraph(UUID graphID) {
        this.setId(graphID);
        this.nodes = new HashMap<TrackNodeLocation, TrackNode>();
        this.nodesById = new HashMap<Integer, TrackNode>();
        this.bounds = new HashMap<class_5321<class_1937>, TrackGraphBounds>();
        this.connectionsByNode = new IdentityHashMap<TrackNode, Map<TrackNode, TrackEdge>>();
        this.edgePoints = new EdgePointStorage();
        this.deferredIntersectionUpdates = new ArrayList<TrackEdge>();
        this.netId = TrackGraph.nextGraphId();
    }

    public <T extends TrackEdgePoint> void addPoint(MinecraftServer server, EdgePointType<T> type, T point) {
        this.edgePoints.put(type, point);
        EdgePointManager.onEdgePointAdded(server, this, point, type);
        Create.RAILWAYS.sync.pointAdded(this, point);
        this.markDirty();
    }

    public <T extends TrackEdgePoint> T getPoint(EdgePointType<T> type, UUID id) {
        return this.edgePoints.get(type, id);
    }

    public <T extends TrackEdgePoint> Collection<T> getPoints(EdgePointType<T> type) {
        return this.edgePoints.values(type);
    }

    public <T extends TrackEdgePoint> T removePoint(MinecraftServer server, EdgePointType<T> type, UUID id) {
        T removed = this.edgePoints.remove(type, id);
        if (removed == null) {
            return null;
        }
        EdgePointManager.onEdgePointRemoved(server, this, removed, type);
        Create.RAILWAYS.sync.pointRemoved(this, (TrackEdgePoint)removed);
        this.markDirty();
        return removed;
    }

    public void tickPoints(MinecraftServer server, boolean preTrains) {
        this.edgePoints.tick(server, this, preTrains);
    }

    public TrackGraphBounds getBounds(class_1937 level) {
        return this.bounds.computeIfAbsent((class_5321<class_1937>)level.method_27983(), dim -> new TrackGraphBounds(this, (class_5321<class_1937>)dim));
    }

    public void invalidateBounds() {
        this.checksum = 0;
        this.bounds.clear();
    }

    public Set<TrackNodeLocation> getNodes() {
        return this.nodes.keySet();
    }

    public TrackNode locateNode(class_1937 level, class_243 position) {
        return this.locateNode(new TrackNodeLocation(position).in(level));
    }

    public TrackNode locateNode(TrackNodeLocation position) {
        return this.nodes.get((Object)position);
    }

    public TrackNode getNode(int netId) {
        return this.nodesById.get(netId);
    }

    public boolean createNodeIfAbsent(TrackNodeLocation.DiscoveredLocation location) {
        if (!this.addNodeIfAbsent(new TrackNode(location, TrackGraph.nextNodeId(), location.normal))) {
            return false;
        }
        TrackNode newNode = this.nodes.get((Object)location);
        Create.RAILWAYS.sync.nodeAdded(this, newNode);
        this.invalidateBounds();
        this.markDirty();
        return true;
    }

    public void loadNode(TrackNodeLocation location, int netId, class_243 normal) {
        this.addNode(new TrackNode(location, netId, normal));
    }

    public void addNode(TrackNode node) {
        TrackNodeLocation location = node.getLocation();
        if (this.nodes.containsKey((Object)location)) {
            this.removeNode(null, location);
        }
        this.nodes.put(location, node);
        this.nodesById.put(node.getNetId(), node);
    }

    public boolean addNodeIfAbsent(TrackNode node) {
        if (this.nodes.putIfAbsent(node.getLocation(), node) != null) {
            return false;
        }
        this.nodesById.put(node.getNetId(), node);
        return true;
    }

    public boolean removeNode(@Nullable class_1936 level, TrackNodeLocation location) {
        TrackNode removed = this.nodes.remove((Object)location);
        if (removed == null) {
            return false;
        }
        Map<UUID, Train> trains = Create.RAILWAYS.trains;
        for (UUID uuid : trains.keySet()) {
            Train train = trains.get(uuid);
            if (train.graph != this || !train.isTravellingOn(removed)) continue;
            train.detachFromTracks();
        }
        this.nodesById.remove(removed.netId);
        this.invalidateBounds();
        if (!this.connectionsByNode.containsKey(removed)) {
            return true;
        }
        Map<TrackNode, TrackEdge> connections = this.connectionsByNode.remove(removed);
        MinecraftServer server = level != null ? level.method_8503() : null;
        for (Map.Entry<TrackNode, TrackEdge> entry : connections.entrySet()) {
            TrackEdge trackEdge = entry.getValue();
            EdgeData edgeData = trackEdge.getEdgeData();
            for (TrackEdgePoint point : edgeData.getPoints()) {
                if (level != null) {
                    point.invalidate(level);
                }
                this.edgePoints.remove(point.getType(), point.getId());
            }
            if (level == null) continue;
            for (TrackEdgeIntersection intersection : edgeData.getIntersections()) {
                Couple<TrackNodeLocation> target = intersection.target;
                TrackGraph graph = Create.RAILWAYS.getGraph((TrackNodeLocation)((Object)target.getFirst()));
                if (graph == null) continue;
                graph.removeIntersection(server, intersection);
            }
        }
        for (TrackNode railNode : connections.keySet()) {
            if (!this.connectionsByNode.containsKey(railNode)) continue;
            this.connectionsByNode.get(railNode).remove(removed);
        }
        return true;
    }

    private void removeIntersection(MinecraftServer server, TrackEdgeIntersection intersection) {
        TrackEdge edge;
        Map<TrackNode, TrackEdge> from2;
        TrackEdge edge2;
        TrackNode node1 = this.locateNode((TrackNodeLocation)((Object)intersection.target.getFirst()));
        TrackNode node2 = this.locateNode((TrackNodeLocation)((Object)intersection.target.getSecond()));
        if (node1 == null || node2 == null) {
            return;
        }
        Map<TrackNode, TrackEdge> from1 = this.getConnectionsFrom(node1);
        if (from1 != null && (edge2 = from1.get(node2)) != null) {
            edge2.getEdgeData().removeIntersection(server, this, intersection.id);
        }
        if ((from2 = this.getConnectionsFrom(node2)) != null && (edge = from2.get(node1)) != null) {
            edge.getEdgeData().removeIntersection(server, this, intersection.id);
        }
    }

    public static int nextNodeId() {
        return nodeNetIdGenerator.incrementAndGet();
    }

    public static int nextGraphId() {
        return graphNetIdGenerator.incrementAndGet();
    }

    public void transferAll(TrackGraph toOther) {
        this.nodes.forEach((loc, node) -> {
            if (toOther.addNodeIfAbsent((TrackNode)node)) {
                Create.RAILWAYS.sync.nodeAdded(toOther, (TrackNode)node);
            }
        });
        this.connectionsByNode.forEach((node1, map) -> map.forEach((node2, edge) -> {
            TrackNode n1 = toOther.locateNode(node1.location);
            TrackNode n2 = toOther.locateNode(node2.location);
            if (n1 == null || n2 == null) {
                return;
            }
            if (toOther.putConnection(n1, n2, (TrackEdge)edge)) {
                Create.RAILWAYS.sync.edgeAdded(toOther, n1, n2, (TrackEdge)edge);
                Create.RAILWAYS.sync.edgeDataChanged(toOther, n1, n2, (TrackEdge)edge);
            }
        }));
        this.edgePoints.transferAll(toOther, toOther.edgePoints);
        this.nodes.clear();
        this.connectionsByNode.clear();
        toOther.invalidateBounds();
        Map<UUID, Train> trains = Create.RAILWAYS.trains;
        for (UUID uuid : trains.keySet()) {
            Train train = trains.get(uuid);
            if (train.graph != this) continue;
            train.graph = toOther;
        }
    }

    public Set<TrackGraph> findDisconnectedGraphs(@Nullable class_1936 level, @Nullable Map<Integer, Pair<Integer, UUID>> splitSubGraphs) {
        HashSet<TrackGraph> dicovered = new HashSet<TrackGraph>();
        HashSet<TrackNodeLocation> vertices = new HashSet<TrackNodeLocation>(this.nodes.keySet());
        ArrayList<TrackNodeLocation> frontier = new ArrayList<TrackNodeLocation>();
        TrackGraph target = null;
        while (!vertices.isEmpty()) {
            if (target != null) {
                dicovered.add(target);
            }
            TrackNodeLocation start = (TrackNodeLocation)((Object)vertices.stream().findFirst().get());
            frontier.add(start);
            vertices.remove((Object)start);
            while (!frontier.isEmpty()) {
                TrackNodeLocation current = (TrackNodeLocation)((Object)frontier.remove(0));
                TrackNode currentNode = this.locateNode(current);
                Map<TrackNode, TrackEdge> connections = this.getConnectionsFrom(currentNode);
                for (TrackNode connected : connections.keySet()) {
                    if (!vertices.remove((Object)connected.getLocation())) continue;
                    frontier.add(connected.getLocation());
                }
                if (target == null) continue;
                if (splitSubGraphs != null && splitSubGraphs.containsKey(currentNode.getNetId())) {
                    Pair<Integer, UUID> ids = splitSubGraphs.get(currentNode.getNetId());
                    target.setId(ids.getSecond());
                    target.netId = ids.getFirst();
                }
                this.transfer(level, currentNode, target);
            }
            frontier.clear();
            target = new TrackGraph();
        }
        return dicovered;
    }

    public void setId(UUID id) {
        this.id = id;
        this.color = Color.rainbowColor(new Random(id.getLeastSignificantBits()).nextInt());
    }

    public void setNetId(int id) {
        this.netId = id;
    }

    public int getChecksum() {
        if (this.checksum == 0) {
            this.checksum = this.nodes.values().stream().collect(Collectors.summingInt(TrackNode::getNetId));
        }
        return this.checksum;
    }

    public void transfer(class_1936 level, TrackNode node, TrackGraph target) {
        target.addNode(node);
        target.invalidateBounds();
        TrackNodeLocation nodeLoc = node.getLocation();
        Map<TrackNode, TrackEdge> connections = this.getConnectionsFrom(node);
        Map<UUID, Train> trains = Create.RAILWAYS.sided((class_1936)level).trains;
        if (!connections.isEmpty()) {
            target.connectionsByNode.put(node, connections);
            for (TrackEdge entry : connections.values()) {
                EdgeData edgeData = entry.getEdgeData();
                for (TrackEdgePoint trackEdgePoint : edgeData.getPoints()) {
                    target.edgePoints.put(trackEdgePoint.getType(), trackEdgePoint);
                    this.edgePoints.remove(trackEdgePoint.getType(), trackEdgePoint.getId());
                }
            }
        }
        if (level != null) {
            for (UUID uuid : trains.keySet()) {
                Train train = trains.get(uuid);
                if (train.graph != this || !train.isTravellingOn(node)) continue;
                train.graph = target;
            }
        }
        this.nodes.remove((Object)nodeLoc);
        this.nodesById.remove(node.getNetId());
        this.connectionsByNode.remove(node);
        this.invalidateBounds();
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    public Map<TrackNode, TrackEdge> getConnectionsFrom(TrackNode node) {
        if (node == null) {
            return null;
        }
        return this.connectionsByNode.getOrDefault(node, new HashMap());
    }

    public TrackEdge getConnection(Couple<TrackNode> nodes) {
        Map<TrackNode, TrackEdge> connectionsFrom = this.getConnectionsFrom((TrackNode)nodes.getFirst());
        if (connectionsFrom == null) {
            return null;
        }
        return connectionsFrom.get(nodes.getSecond());
    }

    public void connectNodes(class_1936 reader, TrackNodeLocation.DiscoveredLocation location, TrackNodeLocation.DiscoveredLocation location2, @Nullable BezierConnection turn) {
        TrackNode node1 = this.nodes.get((Object)location);
        TrackNode node2 = this.nodes.get((Object)location2);
        boolean bezier = turn != null;
        TrackMaterial material = bezier ? turn.getMaterial() : location2.materialA;
        TrackEdge edge = new TrackEdge(node1, node2, turn, material);
        TrackEdge edge2 = new TrackEdge(node2, node1, bezier ? turn.secondary() : null, material);
        for (TrackGraph graph : Create.RAILWAYS.trackNetworks.values()) {
            for (TrackNode otherNode1 : graph.nodes.values()) {
                Map<TrackNode, TrackEdge> connections = graph.connectionsByNode.get(otherNode1);
                if (connections == null) continue;
                for (Map.Entry<TrackNode, TrackEdge> entry : connections.entrySet()) {
                    TrackNode otherNode2 = entry.getKey();
                    TrackEdge otherEdge = entry.getValue();
                    if (graph == this && (otherNode1 == node1 || otherNode2 == node1 || otherNode1 == node2 || otherNode2 == node2) || edge == otherEdge || otherEdge.isInterDimensional() || edge.isInterDimensional() || node1.location.dimension != otherNode1.location.dimension || !bezier && !otherEdge.isTurn() || otherEdge.isTurn() && otherEdge.turn.isPrimary()) continue;
                    Collection<double[]> intersections = edge.getIntersection(node1, node2, otherEdge, otherNode1, otherNode2);
                    UUID id = UUID.randomUUID();
                    for (double[] intersection : intersections) {
                        double s = intersection[0];
                        double t = intersection[1];
                        edge.edgeData.addIntersection(this, id, s, otherNode1, otherNode2, t);
                        edge2.edgeData.addIntersection(this, id, edge.getLength() - s, otherNode1, otherNode2, t);
                        otherEdge.edgeData.addIntersection(graph, id, t, node1, node2, s);
                        TrackEdge otherEdge2 = graph.getConnection(Couple.create(otherNode2, otherNode1));
                        if (otherEdge2 == null) continue;
                        otherEdge2.edgeData.addIntersection(graph, id, otherEdge.getLength() - t, node1, node2, s);
                    }
                }
            }
        }
        this.putConnection(node1, node2, edge);
        this.putConnection(node2, node1, edge2);
        Create.RAILWAYS.sync.edgeAdded(this, node1, node2, edge);
        Create.RAILWAYS.sync.edgeAdded(this, node2, node1, edge2);
        this.markDirty();
    }

    public void disconnectNodes(TrackNode node1, TrackNode node2) {
        Map<TrackNode, TrackEdge> map1 = this.connectionsByNode.get(node1);
        Map<TrackNode, TrackEdge> map2 = this.connectionsByNode.get(node2);
        if (map1 != null) {
            map1.remove(node2);
        }
        if (map2 != null) {
            map2.remove(node1);
        }
    }

    public boolean putConnection(TrackNode node1, TrackNode node2, TrackEdge edge) {
        Map connections = this.connectionsByNode.computeIfAbsent(node1, n -> new IdentityHashMap());
        if (connections.containsKey(node2) && ((TrackEdge)connections.get(node2)).getEdgeData().hasPoints()) {
            return false;
        }
        return connections.put(node2, edge) == null;
    }

    public float distanceToLocationSqr(class_1937 level, class_243 location) {
        float nearest = Float.MAX_VALUE;
        for (TrackNodeLocation tnl : this.nodes.keySet()) {
            if (!Objects.equals(tnl.dimension, level.method_27983())) continue;
            nearest = Math.min(nearest, (float)tnl.getLocation().method_1025(location));
        }
        return nearest;
    }

    public void deferIntersectionUpdate(TrackEdge edge) {
        this.deferredIntersectionUpdates.add(edge);
    }

    public void resolveIntersectingEdgeGroups(class_1937 level) {
        MinecraftServer server = level.method_8503();
        for (TrackEdge edge : this.deferredIntersectionUpdates) {
            if (!this.connectionsByNode.containsKey(edge.node1) || edge != this.connectionsByNode.get(edge.node1).get(edge.node2)) continue;
            EdgeData edgeData = edge.getEdgeData();
            for (TrackEdgeIntersection intersection : edgeData.getIntersections()) {
                TrackEdge otherEdge;
                UUID groupId = edgeData.getGroupAtPosition(this, intersection.location);
                Couple<TrackNodeLocation> target = intersection.target;
                TrackGraph graph = Create.RAILWAYS.getGraph((TrackNodeLocation)((Object)target.getFirst()));
                if (graph == null) continue;
                TrackNode node1 = graph.locateNode((TrackNodeLocation)((Object)target.getFirst()));
                TrackNode node2 = graph.locateNode((TrackNodeLocation)((Object)target.getSecond()));
                Map<TrackNode, TrackEdge> connectionsFrom = graph.getConnectionsFrom(node1);
                if (connectionsFrom == null || (otherEdge = connectionsFrom.get(node2)) == null) continue;
                UUID otherGroupId = otherEdge.getEdgeData().getGroupAtPosition(graph, intersection.targetLocation);
                SignalEdgeGroup group = Create.RAILWAYS.signalEdgeGroups.get(groupId);
                SignalEdgeGroup otherGroup = Create.RAILWAYS.signalEdgeGroups.get(otherGroupId);
                if (group == null || otherGroup == null || groupId == null || otherGroupId == null) continue;
                intersection.groupId = groupId;
                group.putIntersection(server, intersection.id, otherGroupId);
                otherGroup.putIntersection(server, intersection.id, groupId);
            }
        }
        this.deferredIntersectionUpdates.clear();
    }

    public void markDirty() {
        Create.RAILWAYS.markTracksDirty();
    }

    public void write(class_11372 view, DimensionPalette dimensions) {
        view.method_71468("Id", class_4844.field_25122, (Object)this.id);
        view.method_71465("Color", this.color.getRGB());
        HashMap<TrackNode, Integer> indexTracker = new HashMap<TrackNode, Integer>();
        class_11372.class_11374 list = view.method_71476("Nodes");
        class_11372[] nodesList = new class_11372[this.nodes.size()];
        int i = 0;
        for (TrackNode railNode : this.nodes.values()) {
            indexTracker.put(railNode, i);
            class_11372 node = list.method_71480();
            railNode.getLocation().write(node.method_71461("Location"), dimensions);
            node.method_71468("Normal", class_243.field_38277, (Object)railNode.getNormal());
            nodesList[i] = node;
            ++i;
        }
        this.connectionsByNode.forEach((node1, map) -> {
            Integer index1 = (Integer)indexTracker.get(node1);
            if (index1 == null) {
                return;
            }
            class_11372.class_11374 connections = nodesList[index1].method_71476("Connections");
            map.forEach((node2, edge) -> {
                Integer index2 = (Integer)indexTracker.get(node2);
                if (index2 == null) {
                    return;
                }
                class_11372 connection = connections.method_71480();
                connection.method_71465("To", index2.intValue());
                edge.write(connection.method_71461("EdgeData"), dimensions);
            });
        });
        this.edgePoints.write(view.method_71461("Points"), dimensions);
    }

    public static <T> DataResult<T> encode(TrackGraph input, DynamicOps<T> ops, T empty, DimensionPalette dimensions) {
        RecordBuilder builder = ops.mapBuilder();
        builder.add("Id", (Object)input.id, (Encoder)class_4844.field_25122);
        builder.add("Color", ops.createInt(input.color.getRGB()));
        HashMap<TrackNode, Integer> indexTracker = new HashMap<TrackNode, Integer>();
        RecordBuilder[] nodesList = new RecordBuilder[input.nodes.size()];
        int i = 0;
        for (TrackNode railNode : input.nodes.values()) {
            indexTracker.put(railNode, i);
            RecordBuilder node = ops.mapBuilder();
            node.add("Location", TrackNodeLocation.encode(railNode.getLocation(), ops, empty, dimensions));
            node.add("Normal", (Object)railNode.getNormal(), (Encoder)class_243.field_38277);
            nodesList[i] = node;
            ++i;
        }
        input.connectionsByNode.forEach((node1, map) -> {
            Integer index1 = (Integer)indexTracker.get(node1);
            if (index1 == null) {
                return;
            }
            RecordBuilder node = nodesList[index1];
            ListBuilder connections = ops.listBuilder();
            map.forEach((node2, edge) -> {
                Integer index2 = (Integer)indexTracker.get(node2);
                if (index2 == null) {
                    return;
                }
                RecordBuilder connection = ops.mapBuilder();
                connection.add("To", ops.createInt(index2.intValue()));
                connection.add("EdgeData", TrackEdge.encode(edge, ops, empty, dimensions));
                connections.add(connection.build(empty));
            });
            node.add("Connections", connections.build(empty));
        });
        ListBuilder list = ops.listBuilder();
        for (RecordBuilder node : nodesList) {
            list.add(node.build(empty));
        }
        builder.add("Nodes", list.build(empty));
        builder.add("Points", EdgePointStorage.encode(input.edgePoints, ops, empty, dimensions));
        return builder.build(empty);
    }

    public static TrackGraph read(class_11368 view, DimensionPalette dimensions) {
        TrackGraph graph = new TrackGraph((UUID)view.method_71426("Id", class_4844.field_25122).orElseThrow());
        graph.color = new Color(view.method_71424("Color", 0));
        graph.edgePoints.read(view.method_71434("Points"), dimensions);
        HashMap<Integer, TrackNode> indexTracker = new HashMap<Integer, TrackNode>();
        class_11368.class_11370 nodes = view.method_71438("Nodes");
        int i = 0;
        for (class_11368 node : nodes) {
            TrackNodeLocation location = TrackNodeLocation.read(node.method_71434("Location"), dimensions);
            class_243 normal = (class_243)view.method_71426("Normal", class_243.field_38277).orElseThrow();
            graph.loadNode(location, TrackGraph.nextNodeId(), normal);
            indexTracker.put(i, graph.locateNode(location));
            ++i;
        }
        i = 0;
        for (class_11368 node : nodes) {
            TrackNode node1 = (TrackNode)indexTracker.get(i);
            ++i;
            node.method_71436("Connections").ifPresent(connections -> connections.forEach(connection -> {
                TrackNode node2 = (TrackNode)indexTracker.get(connection.method_71424("To", 0));
                TrackEdge edge = TrackEdge.read(node1, node2, connection.method_71434("EdgeData"), graph, dimensions);
                graph.putConnection(node1, node2, edge);
            }));
        }
        return graph;
    }

    public static <T> TrackGraph decode(DynamicOps<T> ops, T input, DimensionPalette dimensions) {
        MapLike map = (MapLike)ops.getMap(input).getOrThrow();
        TrackGraph graph = new TrackGraph((UUID)((com.mojang.datafixers.util.Pair)class_4844.field_25122.decode(ops, map.get("Id")).getOrThrow()).getFirst());
        graph.color = new Color(ops.getNumberValue(map.get("Color"), (Number)0).intValue());
        graph.edgePoints.decode(ops, map.get("Points"), dimensions);
        HashMap indexTracker = new HashMap();
        HashMap<Integer, MapLike> nodes = new HashMap<Integer, MapLike>();
        MutableInt i = new MutableInt();
        ((Consumer)ops.getList(map.get("Nodes")).getOrThrow()).accept(item -> {
            MapLike node = (MapLike)ops.getMap(item).getOrThrow();
            TrackNodeLocation location = TrackNodeLocation.decode(ops, node.get("Location"), dimensions);
            class_243 normal = (class_243)((com.mojang.datafixers.util.Pair)class_243.field_38277.decode(ops, node.get("Normal")).getOrThrow()).getFirst();
            graph.loadNode(location, TrackGraph.nextNodeId(), normal);
            int index = i.getAndIncrement();
            nodes.put(index, node);
            indexTracker.put(index, graph.locateNode(location));
        });
        nodes.forEach((index, node) -> {
            TrackNode node1 = (TrackNode)indexTracker.get(index);
            ops.getList(node.get("Connections")).result().ifPresent(connections -> connections.accept(item -> {
                MapLike connection = (MapLike)ops.getMap(item).getOrThrow();
                TrackNode node2 = (TrackNode)indexTracker.get(ops.getNumberValue(connection.get("To"), (Number)0).intValue());
                TrackEdge edge = TrackEdge.decode(node1, node2, ops, connection.get("EdgeData"), graph, dimensions);
                graph.putConnection(node1, node2, edge);
            }));
        });
        return graph;
    }
}

