/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.gui.widget;

import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.client.catnip.gui.widget.AbstractSimiWidget;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.zurrtum.create.client.foundation.gui.widget.Label;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_437;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public class ScrollInput
extends AbstractSimiWidget {
    protected Consumer<Integer> onScroll;
    protected int state = 0;
    protected class_2561 title = CreateLang.translateDirect("gui.scrollInput.defaultTitle", new Object[0]);
    protected final class_2561 scrollToModify = CreateLang.translateDirect("gui.scrollInput.scrollToModify", new Object[0]);
    protected final class_2561 shiftScrollsFaster = CreateLang.translateDirect("gui.scrollInput.shiftScrollsFaster", new Object[0]);
    protected class_2561 hint = null;
    protected Label displayLabel;
    protected boolean inverted;
    protected boolean soundPlayed = false;
    protected Function<Integer, class_2561> formatter;
    protected int min = 0;
    protected int max = 1;
    protected int shiftStep = 5;
    Function<ScrollValueBehaviour.StepContext, Integer> step = this.standardStep();

    public ScrollInput(int xIn, int yIn, int widthIn, int heightIn) {
        super(xIn, yIn, widthIn, heightIn);
        this.formatter = i -> class_2561.method_43470((String)String.valueOf(i));
    }

    public Function<ScrollValueBehaviour.StepContext, Integer> standardStep() {
        return c -> c.shift ? this.shiftStep : 1;
    }

    public ScrollInput inverted() {
        this.inverted = true;
        return this;
    }

    public ScrollInput withRange(int min, int max) {
        this.min = min;
        this.max = max;
        return this;
    }

    public ScrollInput calling(Consumer<Integer> onScroll) {
        this.onScroll = onScroll;
        return this;
    }

    public ScrollInput format(Function<Integer, class_2561> formatter) {
        this.formatter = formatter;
        return this;
    }

    public ScrollInput removeCallback() {
        this.onScroll = null;
        return this;
    }

    public ScrollInput titled(class_5250 title) {
        this.title = title;
        this.updateTooltip();
        return this;
    }

    public ScrollInput addHint(class_5250 hint) {
        this.hint = hint;
        this.updateTooltip();
        return this;
    }

    public ScrollInput withStepFunction(Function<ScrollValueBehaviour.StepContext, Integer> step) {
        this.step = step;
        return this;
    }

    public ScrollInput writingTo(Label label) {
        this.displayLabel = label;
        if (label != null) {
            this.writeToLabel();
        }
        return this;
    }

    @Override
    public void tick() {
        super.tick();
        this.soundPlayed = false;
    }

    public int getState() {
        return this.state;
    }

    public ScrollInput setState(int state) {
        this.state = state;
        this.clampState();
        this.updateTooltip();
        if (this.displayLabel != null) {
            this.writeToLabel();
        }
        return this;
    }

    public ScrollInput withShiftStep(int step) {
        this.shiftStep = step;
        return this;
    }

    public boolean method_25401(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        if (this.inverted) {
            pScrollY *= -1.0;
        }
        ScrollValueBehaviour.StepContext context = new ScrollValueBehaviour.StepContext();
        context.control = class_437.method_25441();
        context.shift = class_437.method_25442();
        context.currentValue = this.state;
        context.forward = pScrollY > 0.0;
        int priorState = this.state;
        boolean shifted = context.shift;
        int step = (int)Math.signum(pScrollY) * this.step.apply(context);
        this.state += step;
        if (shifted) {
            this.state -= this.state % this.shiftStep;
        }
        this.clampState();
        if (priorState != this.state) {
            if (!this.soundPlayed) {
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)AllSoundEvents.SCROLL_VALUE.getMainEvent(), (float)(1.5f + 0.1f * (float)(this.state - this.min) / (float)(this.max - this.min))));
            }
            this.soundPlayed = true;
            this.onChanged();
        }
        return priorState != this.state;
    }

    protected void clampState() {
        if (this.state >= this.max) {
            this.state = this.max - 1;
        }
        if (this.state < this.min) {
            this.state = this.min;
        }
    }

    public void onChanged() {
        if (this.displayLabel != null) {
            this.writeToLabel();
        }
        if (this.onScroll != null) {
            this.onScroll.accept(this.state);
        }
        this.updateTooltip();
    }

    protected void writeToLabel() {
        this.displayLabel.text = this.formatter.apply(this.state);
    }

    protected void updateTooltip() {
        this.toolTip.clear();
        if (this.title == null) {
            return;
        }
        this.toolTip.add(this.title.method_27662().method_27694(s -> s.method_36139(HEADER_RGB.getRGB())));
        if (this.hint != null) {
            this.toolTip.add(this.hint.method_27662().method_27694(s -> s.method_36139(HINT_RGB.getRGB())));
        }
        this.toolTip.add(this.scrollToModify.method_27662().method_27695(new class_124[]{class_124.field_1056, class_124.field_1063}));
        this.toolTip.add(this.shiftScrollsFaster.method_27662().method_27695(new class_124[]{class_124.field_1056, class_124.field_1063}));
    }
}

