/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2287;
import net.minecraft.class_2561;
import net.minecraft.class_2806;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import reborncore.common.network.NetworkManager;
import reborncore.common.network.clientbound.QueueItemStacksPayload;

public class RebornCoreCommands {
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newSingleThreadExecutor();
    private static final SuggestionProvider<class_2168> MOD_SUGGESTIONS = (context, builder) -> class_2172.method_9264(FabricLoader.getInstance().getAllMods().stream().map(modContainer -> modContainer.getMetadata().getId()), (SuggestionsBuilder)builder);

    public static void setup() {
        CommandRegistrationCallback.EVENT.register(RebornCoreCommands::addCommands);
    }

    private static void addCommands(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"reborncore").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"generate").requires(source -> source.method_9259(3))).then(class_2170.method_9244((String)"size", (ArgumentType)IntegerArgumentType.integer()).executes(RebornCoreCommands::generate)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"flyspeed").requires(source -> source.method_9259(3))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"speed", (ArgumentType)IntegerArgumentType.integer((int)1, (int)10)).executes(ctx -> RebornCoreCommands.flySpeed((CommandContext<class_2168>)ctx, (Collection<class_3222>)ImmutableList.of((Object)((class_2168)ctx.getSource()).method_44023())))).then(class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).executes(ctx -> RebornCoreCommands.flySpeed((CommandContext<class_2168>)ctx, class_2186.method_9312((CommandContext)ctx, (String)"players"))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"render").then(class_2170.method_9247((String)"mod").then(class_2170.method_9244((String)"modid", (ArgumentType)StringArgumentType.word()).suggests(MOD_SUGGESTIONS).executes(RebornCoreCommands::renderMod)))).then(class_2170.method_9247((String)"item").then(class_2170.method_9244((String)"item", (ArgumentType)class_2287.method_9776((class_7157)registryAccess)).executes(RebornCoreCommands::itemRenderer)))).then(class_2170.method_9247((String)"hand").executes(RebornCoreCommands::handRenderer))));
    }

    private static int generate(CommandContext<class_2168> ctx) {
        int size = IntegerArgumentType.getInteger(ctx, (String)"size");
        class_3218 world = ((class_2168)ctx.getSource()).method_9225();
        class_3215 serverChunkManager = world.method_14178();
        AtomicInteger completed = new AtomicInteger(0);
        for (int x = -(size / 2); x < size / 2; ++x) {
            int z = -(size / 2);
            while (z < size / 2) {
                int chunkPosX = x;
                int chunkPosZ = z++;
                CompletableFuture.supplyAsync(() -> serverChunkManager.method_12121(chunkPosX, chunkPosZ, class_2806.field_12803, true), EXECUTOR_SERVICE).whenComplete((chunk, throwable) -> {
                    int max = (int)Math.pow(size, 2.0);
                    ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)String.format("Finished generating %d:%d (%d/%d %d%%)", chunk.method_12004().field_9181, chunk.method_12004().field_9180, completed.getAndIncrement(), max, completed.get() == 0 ? 0 : (int)((float)completed.get() * 100.0f / (float)max))), true);
                });
            }
        }
        return 1;
    }

    private static int flySpeed(CommandContext<class_2168> ctx, Collection<class_3222> players) {
        int speed = IntegerArgumentType.getInteger(ctx, (String)"speed");
        players.stream().peek(player -> player.method_31549().method_7248((float)speed / 20.0f)).forEach(class_3222::method_7355);
        return 1;
    }

    private static int renderMod(CommandContext<class_2168> ctx) {
        String modid = StringArgumentType.getString(ctx, (String)"modid");
        List<class_1799> list = class_7923.field_41178.method_10235().stream().filter(identifier -> identifier.method_12836().equals(modid)).map(arg_0 -> ((class_7922)class_7923.field_41178).method_63535(arg_0)).map(class_1799::new).collect(Collectors.toList());
        RebornCoreCommands.queueRender(list, ctx);
        return 1;
    }

    private static int itemRenderer(CommandContext<class_2168> ctx) {
        class_1792 item = class_2287.method_9777(ctx, (String)"item").method_9785();
        RebornCoreCommands.queueRender(Collections.singletonList(new class_1799((class_1935)item)), ctx);
        return 1;
    }

    private static int handRenderer(CommandContext<class_2168> ctx) {
        RebornCoreCommands.queueRender(Collections.singletonList(((class_2168)ctx.getSource()).method_44023().method_31548().method_7391()), ctx);
        return 1;
    }

    private static void queueRender(List<class_1799> stacks, CommandContext<class_2168> ctx) {
        NetworkManager.sendToPlayer(new QueueItemStacksPayload(stacks), ((class_2168)ctx.getSource()).method_44023());
    }
}

