/*
 * Decompiled with CFR 0.152.
 */
package reborncore.client.gui.config.elements;

import java.util.Arrays;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2350;
import net.minecraft.class_332;
import net.minecraft.class_8710;
import net.minecraft.class_8805;
import reborncore.RebornCore;
import reborncore.client.gui.GuiBase;
import reborncore.client.gui.GuiSprites;
import reborncore.client.gui.config.elements.AbstractConfigPopupElement;
import reborncore.client.gui.config.elements.ConfigFluidElement;
import reborncore.common.blockentity.FluidConfiguration;
import reborncore.common.network.serverbound.FluidConfigSavePayload;
import reborncore.common.network.serverbound.FluidIoSavePayload;

@Environment(value=EnvType.CLIENT)
public class FluidConfigPopupElement
extends AbstractConfigPopupElement {
    ConfigFluidElement fluidElement;

    public FluidConfigPopupElement(int x, int y, int height, ConfigFluidElement fluidElement) {
        super(x, y, height, GuiSprites.SLOT_CONFIG_POPUP, 62, 62, (String[])Arrays.stream(FluidConfiguration.ExtractConfig.values()).map(Enum::name).toArray(String[]::new));
        this.fluidElement = fluidElement;
    }

    @Override
    public int getPencilColor(String pencil) {
        return switch (pencil) {
            case "INPUT" -> this.theme.ioInputColor().comp_1971();
            case "OUTPUT" -> this.theme.ioOutputColor().comp_1971();
            case "ALL" -> this.theme.ioBothColor().comp_1971();
            default -> this.theme.warningTextColor().comp_1971() & 0xFFFFFF | Integer.MIN_VALUE;
        };
    }

    @Override
    protected void cycleConfig(class_2350 side, GuiBase<?> guiBase) {
        FluidConfiguration.ExtractConfig fluidIO;
        if (this.pencil != null) {
            fluidIO = switch (this.pencil) {
                case "INPUT" -> FluidConfiguration.ExtractConfig.INPUT;
                case "OUTPUT" -> FluidConfiguration.ExtractConfig.OUTPUT;
                case "ALL" -> FluidConfiguration.ExtractConfig.ALL;
                default -> FluidConfiguration.ExtractConfig.NONE;
            };
        } else {
            FluidConfiguration.FluidConfig config = guiBase.getMachine().fluidConfiguration.getSideDetail(side);
            fluidIO = config.getIoConfig().getNext();
        }
        FluidConfiguration.FluidConfig newConfig = new FluidConfiguration.FluidConfig(side, fluidIO);
        ClientPlayNetworking.send((class_8710)new FluidConfigSavePayload(guiBase.be.method_11016(), newConfig));
    }

    public void updateCheckBox(String type, GuiBase<?> guiBase) {
        FluidConfiguration configHolder = guiBase.getMachine().fluidConfiguration;
        boolean input = configHolder.autoInput();
        boolean output = configHolder.autoOutput();
        if (type.equalsIgnoreCase("input")) {
            boolean bl = input = !configHolder.autoInput();
        }
        if (type.equalsIgnoreCase("output")) {
            output = !configHolder.autoOutput();
        }
        ClientPlayNetworking.send((class_8710)new FluidIoSavePayload(guiBase.be.method_11016(), input, output));
    }

    @Override
    protected void drawSateColor(class_332 drawContext, GuiBase<?> gui, class_2350 side, int inx, int iny) {
        int sx = inx + this.getX() + gui.getGuiLeft();
        int sy = (iny += 4) + this.getY() + gui.getGuiTop();
        FluidConfiguration fluidConfiguration = gui.getMachine().fluidConfiguration;
        if (fluidConfiguration == null) {
            RebornCore.LOGGER.debug("Hmm, this isn't supposed to happen");
            return;
        }
        FluidConfiguration.FluidConfig fluidConfig = fluidConfiguration.getSideDetail(side);
        class_8805 color = switch (fluidConfig.getIoConfig()) {
            default -> throw new MatchException(null, null);
            case FluidConfiguration.ExtractConfig.NONE -> new class_8805(0);
            case FluidConfiguration.ExtractConfig.INPUT -> this.theme.ioInputColor();
            case FluidConfiguration.ExtractConfig.OUTPUT -> this.theme.ioOutputColor();
            case FluidConfiguration.ExtractConfig.ALL -> this.theme.ioBothColor();
        };
        drawContext.method_25294(sx, sy, sx + 18, sy + 18, color.comp_1971());
    }
}

