/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.type.tree;

import com.google.common.base.Objects;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import team.creative.creativecore.common.util.type.itr.ConsecutiveIterator;
import team.creative.creativecore.common.util.type.itr.FilterIterator;
import team.creative.creativecore.common.util.type.itr.NestedFunctionIterator;
import team.creative.creativecore.common.util.type.itr.SingleIterator;

public class NamedTree<T> {
    private final NamedTree<T> parent;
    private final String name;
    private final LinkedHashMap<String, NamedTree<T>> children = new LinkedHashMap();
    public T value;

    public NamedTree() {
        this.parent = null;
        this.name = null;
    }

    private NamedTree(NamedTree<T> parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    public T add(String path, T value) {
        String[] parts = path.split("\\.");
        this.folderForce((String[])parts, (int)0).value = value;
        return value;
    }

    public Collection<NamedTree<T>> children() {
        return this.children.values();
    }

    public Set<Map.Entry<String, NamedTree<T>>> entries() {
        return this.children.entrySet();
    }

    public T get(String path) {
        NamedTree<T> result = this.folder(path);
        if (result != null) {
            return result.value;
        }
        return null;
    }

    public NamedTree<T> folder(String path) {
        return this.folder(path.split("\\."), 0);
    }

    private NamedTree<T> folder(String[] path, int index) {
        NamedTree<T> folder = this.children.get(path[index]);
        if (folder == null) {
            return null;
        }
        if (path.length <= ++index) {
            return folder;
        }
        return folder.folder(path, index);
    }

    public NamedTree<T> folderForce(String path) {
        return this.folderForce(path.split("\\."), 0);
    }

    private NamedTree<T> folderForce(String[] path, int index) {
        return this.folderForce(path, index, path.length);
    }

    private NamedTree<T> folderForce(String[] path, int index, int end) {
        NamedTree<T> folder = this.children.get(path[index]);
        if (folder == null) {
            folder = new NamedTree<T>(this, path[index]);
            this.children.put(path[index], folder);
        }
        if (end <= ++index) {
            return folder;
        }
        return folder.folderForce(path, index);
    }

    public String path() {
        Object path = "";
        if (this.parent != null && !((String)(path = this.parent.path())).isBlank() && this.name != null) {
            path = (String)path + ".";
        }
        return (String)path + (this.name != null ? this.name : "");
    }

    public String findPath(T value) {
        if (Objects.equal(this.value, value)) {
            return this.name;
        }
        for (NamedTree<T> child : this.children.values()) {
            String path = child.findPath(value);
            if (path == null) continue;
            return (String)(this.name != null ? this.name + "." : "") + path;
        }
        return null;
    }

    public String toString() {
        return "[" + String.valueOf(this.value) + "|" + String.valueOf(this.children) + "]";
    }

    public Iterable<T> values() {
        return FilterIterator.skipNull(new ConsecutiveIterator(new Iterator[]{new SingleIterator<T>(this.value), new NestedFunctionIterator(this.children.values(), x -> x.values())}));
    }

    public T first() {
        if (this.value != null) {
            return this.value;
        }
        for (Map.Entry<String, NamedTree<T>> entry : this.children.entrySet()) {
            T selected = entry.getValue().first();
            if (selected == null) continue;
            return selected;
        }
        return null;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }
}

