/*
 * Decompiled with CFR 0.152.
 */
package techreborn.utils;

import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2758;
import net.minecraft.class_2769;

public class DirectionUtils {
    private static final byte FLAG_NORTH = 1;
    private static final byte FLAG_SOUTH = 2;
    private static final byte FLAG_WEST = 4;
    private static final byte FLAG_EAST = 8;
    public static final class_2382[] POSITIONS = new class_2382[]{new class_2382(0, 0, -1), new class_2382(0, 0, 1), new class_2382(-1, 0, 0), new class_2382(1, 0, 0), new class_2382(0, -1, 0), new class_2382(0, 1, 0)};
    public static final int HORIZONTAL_LENGTH = 4;
    public static final int ALL_LENGTH = POSITIONS.length;
    public static final int[] FLAGS = new int[ALL_LENGTH];
    public static final int[] OPP_FLAGS = new int[ALL_LENGTH];
    public static final Map<class_2350, byte[]> HORIZONTAL_MAP;
    public static final class_2758 HORIZONTAL_NEIGHBORS;

    private static int addNeighbor(class_1937 world, class_2338 pos, class_2758 property, int length, Predicate<class_2248> predicate) {
        int neighbors = 0;
        class_2338.class_2339 neighborPos = new class_2338.class_2339();
        for (int i = 0; i < length; ++i) {
            neighborPos.method_35831((class_2382)pos, POSITIONS[i]);
            class_2680 neighborState = world.method_8320((class_2338)neighborPos);
            if (!predicate.test(neighborState.method_26204())) continue;
            int flags = (Integer)neighborState.method_11654((class_2769)property) | OPP_FLAGS[i];
            world.method_8501((class_2338)neighborPos, (class_2680)neighborState.method_11657((class_2769)property, (Comparable)Integer.valueOf(flags)));
            neighbors |= FLAGS[i];
        }
        return neighbors;
    }

    private static void removeNeighbor(class_1937 world, class_2338 pos, class_2680 state, class_2758 property, int length, Predicate<class_2248> predicate) {
        int neighbors = (Integer)state.method_11654((class_2769)property);
        if (neighbors != 0) {
            class_2338.class_2339 neighborPos = new class_2338.class_2339();
            for (int i = 0; i < length; ++i) {
                if ((neighbors & FLAGS[i]) == 0) continue;
                neighborPos.method_35831((class_2382)pos, POSITIONS[i]);
                class_2680 neighborState = world.method_8320((class_2338)neighborPos);
                if (!predicate.test(neighborState.method_26204())) continue;
                int flags = (Integer)neighborState.method_11654((class_2769)property) & ~OPP_FLAGS[i];
                world.method_8501((class_2338)neighborPos, (class_2680)neighborState.method_11657((class_2769)property, (Comparable)Integer.valueOf(flags)));
            }
        }
    }

    private static void loadNeighbors(class_1937 world, class_2338 pos, class_2680 state, class_2758 property, int length, Predicate<class_2248> predicate) {
        int neighbors = 0;
        class_2338.class_2339 neighborPos = new class_2338.class_2339();
        for (int i = 0; i < length; ++i) {
            neighborPos.method_35831((class_2382)pos, POSITIONS[i]);
            if (!predicate.test(world.method_8320((class_2338)neighborPos).method_26204())) continue;
            neighbors |= FLAGS[i];
        }
        world.method_8501(pos, (class_2680)state.method_11657((class_2769)property, (Comparable)Integer.valueOf(neighbors)));
    }

    public static void addHorizontalNeighbor(class_1937 world, class_2338 pos, class_2680 state, Predicate<class_2248> predicate) {
        world.method_8501(pos, (class_2680)state.method_11657((class_2769)HORIZONTAL_NEIGHBORS, (Comparable)Integer.valueOf(DirectionUtils.addNeighbor(world, pos, HORIZONTAL_NEIGHBORS, 4, predicate))));
    }

    public static void removeHorizontalNeighbor(class_1937 world, class_2338 pos, class_2680 state, Predicate<class_2248> predicate) {
        DirectionUtils.removeNeighbor(world, pos, state, HORIZONTAL_NEIGHBORS, 4, predicate);
    }

    public static void loadHorizontalNeighbors(class_1937 world, class_2338 pos, class_2680 state, Predicate<class_2248> predicate) {
        DirectionUtils.loadNeighbors(world, pos, state, HORIZONTAL_NEIGHBORS, 4, predicate);
    }

    public static HORIZONTAL_PART getHorizontalPart(class_2350 direction, int neighbors) {
        byte[] flags = HORIZONTAL_MAP.get(direction);
        if ((neighbors & flags[1]) == flags[1]) {
            return HORIZONTAL_PART.MIDDLE;
        }
        if ((neighbors & flags[0]) == flags[0]) {
            return HORIZONTAL_PART.START;
        }
        if ((neighbors & flags[2]) == flags[2]) {
            return HORIZONTAL_PART.END;
        }
        return HORIZONTAL_PART.ALONE;
    }

    static {
        for (int i = 0; i < ALL_LENGTH; ++i) {
            DirectionUtils.FLAGS[i] = 1 << i;
            if (i % 2 != 1) continue;
            DirectionUtils.OPP_FLAGS[i] = FLAGS[i - 1];
            DirectionUtils.OPP_FLAGS[i - 1] = FLAGS[i];
        }
        HORIZONTAL_MAP = Map.of(class_2350.field_11043, new byte[]{4, 12, 8}, class_2350.field_11035, new byte[]{8, 12, 4}, class_2350.field_11039, new byte[]{2, 3, 1}, class_2350.field_11034, new byte[]{1, 3, 2});
        HORIZONTAL_NEIGHBORS = class_2758.method_11867((String)"neighbors", (int)0, (int)15);
    }

    public static enum HORIZONTAL_PART {
        ALONE,
        START,
        MIDDLE,
        END;

    }
}

