/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.packagePort;

import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.api.entity.FakePlayerHandler;
import com.zurrtum.create.content.logistics.box.PackageItem;
import com.zurrtum.create.content.logistics.packagePort.PackagePortMenu;
import com.zurrtum.create.content.logistics.packagePort.PackagePortTarget;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.animatedContainer.AnimatedContainerBehaviour;
import com.zurrtum.create.foundation.gui.menu.MenuBase;
import com.zurrtum.create.foundation.gui.menu.MenuProvider;
import com.zurrtum.create.infrastructure.component.ClipboardEntry;
import com.zurrtum.create.infrastructure.component.ClipboardType;
import com.zurrtum.create.infrastructure.transfer.SlotRangeCache;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_11343;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1269;
import net.minecraft.class_1278;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_9129;
import org.jetbrains.annotations.Nullable;

public abstract class PackagePortBlockEntity
extends SmartBlockEntity
implements MenuProvider {
    public boolean acceptsPackages = true;
    public String addressFilter = "";
    public PackagePortTarget target;
    public PackagePortInventory inventory = new PackagePortInventory();
    protected AnimatedContainerBehaviour<PackagePortMenu> openTracker;

    public PackagePortBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public boolean isBackedUp() {
        int size = this.inventory.method_5439();
        for (int i = 0; i < size; ++i) {
            if (!this.inventory.method_5438(i).method_7960()) continue;
            return false;
        }
        return true;
    }

    public void filterChanged() {
        if (this.target != null) {
            this.target.deregister(this, (class_1936)this.field_11863, this.field_11867);
            this.target.register(this, (class_1936)this.field_11863, this.field_11867);
        }
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.target != null) {
            this.target.register(this, (class_1936)this.field_11863, this.field_11867);
        }
    }

    public String getFilterString() {
        return this.acceptsPackages ? this.addressFilter : null;
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        if (this.target != null) {
            view.method_71468("Target", PackagePortTarget.CODEC, (Object)this.target);
        }
        view.method_71469("AddressFilter", this.addressFilter);
        view.method_71472("AcceptsPackages", this.acceptsPackages);
        this.inventory.write(view);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        this.inventory.read(view);
        PackagePortTarget prevTarget = this.target;
        this.target = view.method_71426("Target", PackagePortTarget.CODEC).orElse(null);
        this.addressFilter = view.method_71428("AddressFilter", "");
        this.acceptsPackages = view.method_71433("AcceptsPackages", false);
        if (clientPacket && prevTarget != this.target) {
            this.invalidateRenderBoundingBox();
        }
    }

    @Override
    public void invalidate() {
        super.invalidate();
    }

    @Override
    public void destroy() {
        if (this.target != null) {
            this.target.deregister(this, (class_1936)this.field_11863, this.field_11867);
        }
        super.destroy();
        class_1264.method_5451((class_1937)this.field_11863, (class_2338)this.field_11867, (class_1263)this.inventory);
    }

    public void drop(class_1799 box) {
        if (box.method_7960()) {
            return;
        }
        class_2248.method_9577((class_1937)this.field_11863, (class_2338)this.field_11867, (class_1799)box);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        this.openTracker = new AnimatedContainerBehaviour<PackagePortMenu>(this, PackagePortMenu.class);
        behaviours.add(this.openTracker);
        this.openTracker.onOpenChanged(this::onOpenChange);
    }

    protected abstract void onOpenChange(boolean var1);

    public class_1269 use(class_1657 player) {
        if (player == null || player.method_18276()) {
            return class_1269.field_52423;
        }
        if (FakePlayerHandler.has((class_1297)player)) {
            return class_1269.field_52423;
        }
        class_1799 mainHandItem = player.method_6047();
        boolean clipboard = mainHandItem.method_31574((class_1792)AllItems.CLIPBOARD);
        if (this.field_11863.field_9236) {
            if (!clipboard) {
                this.onOpenedManually();
            }
            return class_1269.field_5812;
        }
        if (clipboard) {
            this.addAddressToClipboard(player, mainHandItem);
            return class_1269.field_5812;
        }
        this.openHandledScreen((class_3222)player);
        return class_1269.field_5812;
    }

    protected void onOpenedManually() {
    }

    private void addAddressToClipboard(class_1657 player, class_1799 mainHandItem) {
        if (this.addressFilter == null || this.addressFilter.isBlank()) {
            return;
        }
        List<List<ClipboardEntry>> list = ClipboardEntry.readAll(mainHandItem);
        for (List<ClipboardEntry> page : list) {
            for (ClipboardEntry entry : page) {
                String existing = entry.text.getString();
                if (!existing.equals("#" + this.addressFilter) && !existing.equals("# " + this.addressFilter)) continue;
                return;
            }
        }
        List<ClipboardEntry> page = null;
        for (List<ClipboardEntry> freePage : list) {
            if (freePage.size() > 11) continue;
            page = freePage;
            break;
        }
        if (page == null) {
            page = new ArrayList<ClipboardEntry>();
            list.add(page);
        }
        page.add(new ClipboardEntry(false, class_2561.method_43470((String)("#" + this.addressFilter))));
        player.method_7353((class_2561)class_2561.method_43469((String)"create.clipboard.address_added", (Object[])new Object[]{this.addressFilter}), true);
        ClipboardEntry.saveAll(list, mainHandItem);
        mainHandItem.method_57379(AllDataComponents.CLIPBOARD_TYPE, (Object)ClipboardType.WRITTEN);
    }

    @Override
    public MenuBase<?> createMenu(int pContainerId, class_1661 pPlayerInventory, class_1657 pPlayer, class_9129 extraData) {
        extraData.method_10807(this.field_11867);
        return new PackagePortMenu(pContainerId, pPlayerInventory, this);
    }

    public int getComparatorOutput() {
        if (this.inventory == null) {
            return 0;
        }
        int itemsFound = 0;
        float proportion = 0.0f;
        int size = this.inventory.method_5439();
        for (int j = 0; j < size; ++j) {
            class_1799 itemstack = this.inventory.method_5438(j);
            if (itemstack.method_7960()) continue;
            proportion += (float)itemstack.method_7947() / (float)itemstack.method_7914();
            ++itemsFound;
        }
        return class_3532.method_15375((float)((proportion /= (float)size) * 14.0f)) + (itemsFound > 0 ? 1 : 0);
    }

    public class PackagePortInventory
    implements class_1278 {
        public static final int[] SLOTS = SlotRangeCache.get(18);
        public final class_2371<class_1799> stacks = class_2371.method_10213((int)18, (Object)class_1799.field_8037);
        private boolean receive = true;

        public int[] method_5494(class_2350 side) {
            return SLOTS;
        }

        public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
            String filterString = PackagePortBlockEntity.this.getFilterString();
            if (this.receive) {
                return filterString != null && PackageItem.matchAddress(stack, filterString);
            }
            return filterString == null || !PackageItem.matchAddress(stack, filterString);
        }

        public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
            String filterString = PackagePortBlockEntity.this.getFilterString();
            if (this.receive) {
                return filterString == null || !PackageItem.matchAddress(stack, filterString);
            }
            return filterString != null && PackageItem.matchAddress(stack, filterString);
        }

        public void receiveMode() {
            this.receive = true;
        }

        public void sendMode() {
            this.receive = false;
        }

        public boolean method_5437(int slot, class_1799 stack) {
            return PackageItem.isPackage(stack);
        }

        public int method_5439() {
            return 18;
        }

        public class_1799 method_5438(int slot) {
            if (slot >= 18) {
                return class_1799.field_8037;
            }
            return (class_1799)this.stacks.get(slot);
        }

        public void method_5447(int slot, class_1799 stack) {
            if (slot >= 18) {
                return;
            }
            this.stacks.set(slot, (Object)stack);
        }

        public void method_5431() {
            PackagePortBlockEntity.this.notifyUpdate();
        }

        public void write(class_11372 view) {
            class_11372.class_11373 list = view.method_71467("Inventory", class_11343.field_60354);
            for (int i = 0; i < 18; ++i) {
                class_1799 stack = (class_1799)this.stacks.get(i);
                if (stack.method_7960()) continue;
                list.method_71484((Object)new class_11343(i, stack));
            }
        }

        public void read(class_11368 view) {
            class_11368.class_11369 list = view.method_71437("Inventory", class_11343.field_60354);
            for (int i = 0; i < 18; ++i) {
                this.stacks.set(i, (Object)class_1799.field_8037);
            }
            for (class_11343 slot : list) {
                this.stacks.set(slot.comp_4211(), (Object)slot.comp_4212());
            }
        }
    }
}

