/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.funnel;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.math.BlockFace;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.kinetics.belt.BeltBlockEntity;
import com.zurrtum.create.content.kinetics.belt.BeltHelper;
import com.zurrtum.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.zurrtum.create.content.kinetics.belt.transport.TransportedItemStack;
import com.zurrtum.create.content.logistics.box.PackageEntity;
import com.zurrtum.create.content.logistics.funnel.AbstractFunnelBlock;
import com.zurrtum.create.content.logistics.funnel.BeltFunnelBlock;
import com.zurrtum.create.content.logistics.funnel.FunnelBlock;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.VersionedInventoryTrackerBehaviour;
import com.zurrtum.create.foundation.item.ItemHelper;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import com.zurrtum.create.infrastructure.packet.s2c.FunnelFlapPacket;
import java.lang.ref.WeakReference;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class FunnelBlockEntity
extends SmartBlockEntity {
    private ServerFilteringBehaviour filtering;
    private InvManipulationBehaviour invManipulation;
    private VersionedInventoryTrackerBehaviour invVersionTracker;
    private int extractionCooldown = 0;
    private WeakReference<class_1297> lastObserved;
    public LerpedFloat flap = this.createChasingFlap();
    static final class_238 coreBB = new class_238(class_2338.field_10980);

    public FunnelBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.FUNNEL, pos, state);
    }

    Mode determineCurrentMode() {
        class_2680 state = this.method_11010();
        if (!FunnelBlock.isFunnel(state)) {
            return Mode.INVALID;
        }
        if (((Boolean)state.method_61767((class_2769)class_2741.field_12484, (Comparable)Boolean.valueOf(false))).booleanValue()) {
            return Mode.PAUSED;
        }
        if (state.method_26204() instanceof BeltFunnelBlock) {
            BeltFunnelBlock.Shape shape = (BeltFunnelBlock.Shape)((Object)state.method_11654(BeltFunnelBlock.SHAPE));
            if (shape == BeltFunnelBlock.Shape.PULLING) {
                return Mode.TAKING_FROM_BELT;
            }
            if (shape == BeltFunnelBlock.Shape.PUSHING) {
                return Mode.PUSHING_TO_BELT;
            }
            BeltBlockEntity belt = BeltHelper.getSegmentBE((class_1936)this.field_11863, this.field_11867.method_10074());
            if (belt != null) {
                return belt.getMovementFacing() == state.method_11654((class_2769)BeltFunnelBlock.HORIZONTAL_FACING) ? Mode.PUSHING_TO_BELT : Mode.TAKING_FROM_BELT;
            }
            return Mode.INVALID;
        }
        if (state.method_26204() instanceof FunnelBlock) {
            return (Boolean)state.method_11654((class_2769)FunnelBlock.EXTRACTING) != false ? Mode.EXTRACT : Mode.COLLECT;
        }
        return Mode.INVALID;
    }

    @Override
    public void tick() {
        super.tick();
        this.flap.tickChaser();
        Mode mode = this.determineCurrentMode();
        if (this.field_11863.field_9236) {
            return;
        }
        if (mode == Mode.PAUSED) {
            this.extractionCooldown = 0;
        }
        if (mode == Mode.TAKING_FROM_BELT) {
            return;
        }
        if (this.extractionCooldown > 0) {
            --this.extractionCooldown;
            return;
        }
        if (mode == Mode.PUSHING_TO_BELT) {
            this.activateExtractingBeltFunnel();
        }
        if (mode == Mode.EXTRACT) {
            this.activateExtractor();
        }
    }

    private void activateExtractor() {
        if (this.invVersionTracker.stillWaiting(this.invManipulation)) {
            return;
        }
        class_2680 blockState = this.method_11010();
        class_2350 facing = AbstractFunnelBlock.getFunnelFacing(blockState);
        if (facing == null) {
            return;
        }
        boolean trackingEntityPresent = true;
        class_238 area = this.getEntityOverflowScanningArea();
        if (this.lastObserved == null) {
            trackingEntityPresent = false;
        } else {
            class_1297 lastEntity = (class_1297)this.lastObserved.get();
            if (lastEntity == null || !lastEntity.method_5805() || !lastEntity.method_5829().method_994(area)) {
                trackingEntityPresent = false;
                this.lastObserved = null;
            }
        }
        if (trackingEntityPresent) {
            return;
        }
        int amountToExtract = this.getAmountToExtract();
        ItemHelper.ExtractionCountMode mode = this.getModeToExtract();
        class_1799 stack = ((InvManipulationBehaviour)this.invManipulation.simulate()).extract(mode, amountToExtract);
        if (stack.method_7960()) {
            this.invVersionTracker.awaitNewVersion(this.invManipulation);
            return;
        }
        for (class_1297 entity : this.field_11863.method_8335(null, area)) {
            if (!(entity instanceof class_1542) && !(entity instanceof PackageEntity)) continue;
            this.lastObserved = new WeakReference<class_1297>(entity);
            return;
        }
        stack = this.invManipulation.extract(mode, amountToExtract);
        if (stack.method_7960()) {
            return;
        }
        this.flap(false);
        this.onTransfer(stack);
        class_243 outputPos = VecHelper.getCenterOf((class_2382)this.field_11867);
        boolean vertical = facing.method_10166().method_10178();
        boolean up = facing == class_2350.field_11036;
        outputPos = outputPos.method_1019(class_243.method_24954((class_2382)facing.method_62675()).method_1021(vertical ? (up ? (double)0.15f : 0.5) : 0.25));
        if (!vertical) {
            outputPos = outputPos.method_1023(0.0, (double)0.45f, 0.0);
        }
        class_243 motion = class_243.field_1353;
        if (up) {
            motion = new class_243(0.0, 0.25, 0.0);
        }
        class_1542 item = new class_1542(this.field_11863, outputPos.field_1352, outputPos.field_1351, outputPos.field_1350, stack.method_7972());
        item.method_6988();
        item.method_18799(motion);
        this.field_11863.method_8649((class_1297)item);
        this.lastObserved = new WeakReference<class_1542>(item);
        this.startCooldown();
    }

    private class_238 getEntityOverflowScanningArea() {
        class_2350 facing = AbstractFunnelBlock.getFunnelFacing(this.method_11010());
        class_238 bb = coreBB.method_996(this.field_11867);
        if (facing == null || facing == class_2350.field_11036) {
            return bb;
        }
        return bb.method_1012(0.0, -1.0, 0.0);
    }

    private void activateExtractingBeltFunnel() {
        MutableBoolean deniedByInsertion;
        if (this.invVersionTracker.stillWaiting(this.invManipulation)) {
            return;
        }
        class_2680 blockState = this.method_11010();
        class_2350 facing = (class_2350)blockState.method_11654((class_2769)BeltFunnelBlock.HORIZONTAL_FACING);
        DirectBeltInputBehaviour inputBehaviour = BlockEntityBehaviour.get((class_1922)this.field_11863, this.field_11867.method_10074(), DirectBeltInputBehaviour.TYPE);
        if (inputBehaviour == null) {
            return;
        }
        if (!inputBehaviour.canInsertFromSide(facing)) {
            return;
        }
        if (inputBehaviour.isOccupied(facing)) {
            return;
        }
        int amountToExtract = this.getAmountToExtract();
        ItemHelper.ExtractionCountMode mode = this.getModeToExtract();
        class_1799 stack = this.invManipulation.extract(mode, amountToExtract, arg_0 -> FunnelBlockEntity.lambda$activateExtractingBeltFunnel$0(inputBehaviour, facing, deniedByInsertion = new MutableBoolean(false), arg_0));
        if (stack.method_7960()) {
            if (deniedByInsertion.isFalse()) {
                this.invVersionTracker.awaitNewVersion((class_1263)this.invManipulation.getInventory());
            }
            return;
        }
        this.flap(false);
        this.onTransfer(stack);
        inputBehaviour.handleInsertion(stack, facing, false);
        this.startCooldown();
    }

    public int getAmountToExtract() {
        if (!this.supportsAmountOnFilter()) {
            return 64;
        }
        int amountToExtract = this.invManipulation.getAmountFromFilter();
        if (!this.filtering.isActive()) {
            amountToExtract = 1;
        }
        return amountToExtract;
    }

    public ItemHelper.ExtractionCountMode getModeToExtract() {
        if (!this.supportsAmountOnFilter() || !this.filtering.isActive()) {
            return ItemHelper.ExtractionCountMode.UPTO;
        }
        return this.invManipulation.getModeFromFilter();
    }

    private int startCooldown() {
        this.extractionCooldown = (Integer)AllConfigs.server().logistics.defaultExtractionTimer.get();
        return this.extractionCooldown;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        this.invManipulation = new InvManipulationBehaviour(this, (w, p, s) -> new BlockFace(p, AbstractFunnelBlock.getFunnelFacing(s).method_10153()));
        behaviours.add(this.invManipulation);
        this.invVersionTracker = new VersionedInventoryTrackerBehaviour(this);
        behaviours.add(this.invVersionTracker);
        this.filtering = new ServerFilteringBehaviour(this);
        this.filtering.showCountWhen(this::supportsAmountOnFilter);
        this.filtering.onlyActiveWhen(this::supportsFiltering);
        behaviours.add(this.filtering);
        behaviours.add(new DirectBeltInputBehaviour(this).onlyInsertWhen(this::supportsDirectBeltInput).setInsertionHandler(this::handleDirectBeltInput));
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.FUNNEL);
    }

    private boolean supportsAmountOnFilter() {
        class_2680 blockState = this.method_11010();
        boolean beltFunnelsupportsAmount = false;
        if (blockState.method_26204() instanceof BeltFunnelBlock) {
            BeltFunnelBlock.Shape shape = (BeltFunnelBlock.Shape)((Object)blockState.method_11654(BeltFunnelBlock.SHAPE));
            beltFunnelsupportsAmount = shape == BeltFunnelBlock.Shape.PUSHING ? true : BeltHelper.getSegmentBE((class_1936)this.field_11863, this.field_11867.method_10074()) != null;
        }
        boolean extractor = blockState.method_26204() instanceof FunnelBlock && (Boolean)blockState.method_11654((class_2769)FunnelBlock.EXTRACTING) != false;
        return beltFunnelsupportsAmount || extractor;
    }

    private boolean supportsDirectBeltInput(class_2350 side) {
        class_2680 blockState = this.method_11010();
        if (blockState == null) {
            return false;
        }
        if (!(blockState.method_26204() instanceof FunnelBlock)) {
            return false;
        }
        if (((Boolean)blockState.method_11654((class_2769)FunnelBlock.EXTRACTING)).booleanValue()) {
            return false;
        }
        return FunnelBlock.getFunnelFacing(blockState) == class_2350.field_11036;
    }

    private boolean supportsFiltering() {
        class_2680 blockState = this.method_11010();
        return blockState.method_27852((class_2248)AllBlocks.BRASS_BELT_FUNNEL) || blockState.method_27852((class_2248)AllBlocks.BRASS_FUNNEL);
    }

    private class_1799 handleDirectBeltInput(TransportedItemStack stack, class_2350 side, boolean simulate) {
        class_1799 inserted = stack.stack;
        if (!this.filtering.test(inserted)) {
            return inserted;
        }
        if (this.determineCurrentMode() == Mode.PAUSED) {
            return inserted;
        }
        if (simulate) {
            this.invManipulation.simulate();
        }
        if (!simulate) {
            this.onTransfer(inserted);
        }
        return this.invManipulation.insert(inserted);
    }

    public void flap(boolean inward) {
        class_1937 class_19372;
        if (!this.field_11863.field_9236 && (class_19372 = this.field_11863) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            FunnelFlapPacket packet = new FunnelFlapPacket(this, inward);
            for (class_3222 player : serverLevel.method_14178().field_17254.method_17210(new class_1923(this.field_11867), false)) {
                player.field_13987.method_14364((class_2596)packet);
            }
        } else {
            this.flap.setValue(inward ? -1.0 : 1.0);
            AllSoundEvents.FUNNEL_FLAP.playAt(this.field_11863, (class_2382)this.field_11867, 1.0f, 1.0f, true);
        }
    }

    public boolean hasFlap() {
        class_2680 blockState = this.method_11010();
        return AbstractFunnelBlock.getFunnelFacing(blockState).method_10166().method_10179();
    }

    public float getFlapOffset() {
        class_2680 blockState = this.method_11010();
        if (!(blockState.method_26204() instanceof BeltFunnelBlock)) {
            return -0.0625f;
        }
        return switch ((BeltFunnelBlock.Shape)((Object)blockState.method_11654(BeltFunnelBlock.SHAPE))) {
            case BeltFunnelBlock.Shape.EXTENDED -> 0.5f;
            case BeltFunnelBlock.Shape.PULLING, BeltFunnelBlock.Shape.PUSHING -> -0.125f;
            default -> 0.0f;
        };
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        view.method_71465("TransferCooldown", this.extractionCooldown);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        this.extractionCooldown = view.method_71424("TransferCooldown", 0);
        if (clientPacket) {
            AllClientHandle.INSTANCE.queueUpdate(this);
        }
    }

    public void onTransfer(class_1799 stack) {
        AllBlocks.SMART_OBSERVER.onFunnelTransfer(this.field_11863, this.field_11867, stack);
        this.award(AllAdvancements.FUNNEL);
    }

    private LerpedFloat createChasingFlap() {
        return LerpedFloat.linear().startWithValue(0.25).chase(0.0, 0.05f, LerpedFloat.Chaser.EXP);
    }

    private static /* synthetic */ boolean lambda$activateExtractingBeltFunnel$0(DirectBeltInputBehaviour inputBehaviour, class_2350 facing, MutableBoolean deniedByInsertion, class_1799 s) {
        class_1799 handleInsertion = inputBehaviour.handleInsertion(s, facing, true);
        if (handleInsertion.method_7960()) {
            return true;
        }
        deniedByInsertion.setTrue();
        return false;
    }

    static enum Mode {
        INVALID,
        PAUSED,
        COLLECT,
        PUSHING_TO_BELT,
        TAKING_FROM_BELT,
        EXTRACT;

    }
}

