/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.elevator;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllContraptionTypes;
import com.zurrtum.create.api.contraption.ContraptionType;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.IntAttached;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.AssemblyException;
import com.zurrtum.create.content.contraptions.actors.contraptionControls.ContraptionControlsMovement;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.content.contraptions.elevator.ElevatorColumn;
import com.zurrtum.create.content.contraptions.elevator.ElevatorContactBlockEntity;
import com.zurrtum.create.content.contraptions.pulley.PulleyContraption;
import com.zurrtum.create.content.redstone.contact.RedstoneContactBlock;
import com.zurrtum.create.infrastructure.packet.s2c.ElevatorFloorListPacket;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3499;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class ElevatorContraption
extends PulleyContraption {
    protected ElevatorColumn.ColumnCoords column;
    protected int contactYOffset;
    public boolean arrived;
    private int namesListVersion = -1;
    public List<IntAttached<Couple<String>>> namesList = ImmutableList.of();
    public int clientYTarget;
    public int maxContactY;
    public int minContactY;
    private int contacts;

    public ElevatorContraption() {
    }

    public ElevatorContraption(int initialOffset) {
        super(initialOffset);
    }

    @Override
    public void tickStorage(AbstractContraptionEntity entity) {
        super.tickStorage(entity);
        if (entity.field_6012 % 10 != 0) {
            return;
        }
        ElevatorColumn.ColumnCoords coords = this.getGlobalColumn();
        ElevatorColumn column = ElevatorColumn.get((class_1936)entity.method_37908(), coords);
        if (column == null) {
            return;
        }
        if (column.namesListVersion == this.namesListVersion) {
            return;
        }
        this.namesList = column.compileNamesList();
        this.namesListVersion = column.namesListVersion;
        class_1937 class_19372 = entity.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            serverWorld.method_14178().method_18754((class_1297)entity, (class_2596)new ElevatorFloorListPacket(entity, this.namesList));
        }
    }

    @Override
    protected void disableActorOnStart(MovementContext context) {
    }

    public ElevatorColumn.ColumnCoords getGlobalColumn() {
        return this.column.relative(this.anchor);
    }

    public Integer getCurrentTargetY(class_1937 level) {
        ElevatorColumn.ColumnCoords coords = this.getGlobalColumn();
        ElevatorColumn column = ElevatorColumn.get((class_1936)level, coords);
        if (column == null) {
            return null;
        }
        if (!column.isTargetAvailable()) {
            return null;
        }
        int targetedYLevel = column.getTargetedYLevel();
        if (this.isTargetUnreachable(targetedYLevel)) {
            return null;
        }
        return targetedYLevel;
    }

    public boolean isTargetUnreachable(int contactY) {
        return contactY < this.minContactY || contactY > this.maxContactY;
    }

    @Override
    public boolean assemble(class_1937 world, class_2338 pos) throws AssemblyException {
        if (!this.searchMovedStructure(world, pos, null)) {
            return false;
        }
        if (this.blocks.size() <= 0) {
            return false;
        }
        if (this.contacts == 0) {
            throw new AssemblyException((class_2561)class_2561.method_43471((String)"create.gui.assembly.exception.no_contacts"));
        }
        if (this.contacts > 1) {
            throw new AssemblyException((class_2561)class_2561.method_43471((String)"create.gui.assembly.exception.too_many_contacts"));
        }
        ElevatorColumn column = ElevatorColumn.get((class_1936)world, this.getGlobalColumn());
        if (column != null && column.isActive()) {
            throw new AssemblyException((class_2561)class_2561.method_43471((String)"create.gui.assembly.exception.column_conflict"));
        }
        this.startMoving(world);
        return true;
    }

    @Override
    protected Pair<class_3499.class_3501, class_2586> capture(class_1937 world, class_2338 pos) {
        class_2680 blockState = world.method_8320(pos);
        if (!blockState.method_27852((class_2248)AllBlocks.REDSTONE_CONTACT)) {
            return super.capture(world, pos);
        }
        class_2350 facing = (class_2350)blockState.method_11654((class_2769)RedstoneContactBlock.field_10927);
        if (facing.method_10166() == class_2350.class_2351.field_11052) {
            return super.capture(world, pos);
        }
        ++this.contacts;
        class_2338 local = this.toLocalPos(pos.method_10093(facing));
        this.column = new ElevatorColumn.ColumnCoords(local.method_10263(), local.method_10260(), facing.method_10153());
        this.contactYOffset = local.method_10264();
        return super.capture(world, pos);
    }

    public int getContactYOffset() {
        return this.contactYOffset;
    }

    public void broadcastFloorData(class_1937 level, class_2338 contactPos) {
        ElevatorColumn column = ElevatorColumn.get((class_1936)level, this.getGlobalColumn());
        class_2586 class_25862 = level.method_8321(contactPos);
        if (!(class_25862 instanceof ElevatorContactBlockEntity)) {
            return;
        }
        ElevatorContactBlockEntity ecbe = (ElevatorContactBlockEntity)class_25862;
        if (column != null) {
            column.floorReached((class_1936)level, ecbe.shortName);
        }
    }

    @Override
    public void write(class_11372 view, boolean spawnPacket) {
        super.write(view, spawnPacket);
        view.method_71472("Arrived", this.arrived);
        view.method_71468("Column", ElevatorColumn.ColumnCoords.CODEC, (Object)this.column);
        view.method_71465("ContactY", this.contactYOffset);
        view.method_71465("MaxContactY", this.maxContactY);
        view.method_71465("MinContactY", this.minContactY);
    }

    @Override
    public void read(class_1937 world, class_11368 view, boolean spawnData) {
        this.arrived = view.method_71433("Arrived", false);
        this.column = (ElevatorColumn.ColumnCoords)view.method_71426("Column", ElevatorColumn.ColumnCoords.CODEC).orElseThrow();
        this.contactYOffset = view.method_71424("ContactY", 0);
        this.maxContactY = view.method_71424("MaxContactY", 0);
        this.minContactY = view.method_71424("MinContactY", 0);
        super.read(world, view, spawnData);
    }

    @Override
    public ContraptionType getType() {
        return AllContraptionTypes.ELEVATOR;
    }

    public void setClientYTarget(int clientYTarget) {
        if (this.clientYTarget == clientYTarget) {
            return;
        }
        this.clientYTarget = clientYTarget;
        this.syncControlDisplays();
    }

    public void syncControlDisplays() {
        if (this.namesList.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.namesList.size(); ++i) {
            if ((Integer)this.namesList.get(i).getFirst() != this.clientYTarget) continue;
            this.setAllControlsToFloor(i);
        }
    }

    public void setAllControlsToFloor(int floorIndex) {
        for (MutablePair pair : this.actors) {
            Object object;
            if (pair.right == null || !((object = ((MovementContext)pair.right).temporaryData) instanceof ContraptionControlsMovement.ElevatorFloorSelection)) continue;
            ContraptionControlsMovement.ElevatorFloorSelection efs = (ContraptionControlsMovement.ElevatorFloorSelection)object;
            efs.currentIndex = floorIndex;
        }
    }
}

