/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.blockEntity.behaviour.tooltip;

import com.zurrtum.create.client.catnip.lang.Lang;
import com.zurrtum.create.client.catnip.lang.LangBuilder;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.tooltip.GaugeTooltipBehaviour;
import com.zurrtum.create.client.foundation.item.TooltipHelper;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.gauge.StressGaugeBlockEntity;
import com.zurrtum.create.infrastructure.packet.c2s.GaugeObservedPacket;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class StressGaugeTooltipBehaviour
extends GaugeTooltipBehaviour<StressGaugeBlockEntity> {
    public StressGaugeTooltipBehaviour(StressGaugeBlockEntity be) {
        super(be);
    }

    @Override
    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        if (!IRotate.StressImpact.isEnabled()) {
            return false;
        }
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        double capacity = ((StressGaugeBlockEntity)this.blockEntity).getNetworkCapacity();
        float networkStress = ((StressGaugeBlockEntity)this.blockEntity).getNetworkStress();
        double stressFraction = (double)networkStress / (capacity == 0.0 ? 1.0 : capacity);
        CreateLang.translate("gui.stressometer.title", new Object[0]).style(class_124.field_1080).forGoggles(tooltip);
        if (((StressGaugeBlockEntity)this.blockEntity).getTheoreticalSpeed() == 0.0f) {
            CreateLang.text(TooltipHelper.makeProgressBar(3, 0)).translate("gui.stressometer.no_rotation", new Object[0]).style(class_124.field_1063).forGoggles(tooltip);
        } else {
            StressGaugeTooltipBehaviour.getFormattedStressText(stressFraction).forGoggles(tooltip);
            CreateLang.translate("gui.stressometer.capacity", new Object[0]).style(class_124.field_1080).forGoggles(tooltip);
            double remainingCapacity = capacity - (double)networkStress;
            LangBuilder su = CreateLang.translate("generic.unit.stress", new Object[0]);
            LangBuilder stressTip = CreateLang.number(remainingCapacity).add(su).style(IRotate.StressImpact.of(stressFraction).getRelativeColor());
            if (remainingCapacity != capacity) {
                stressTip.text(class_124.field_1080, " / ").add(CreateLang.number(capacity).add(su).style(class_124.field_1063));
            }
            stressTip.forGoggles(tooltip, 1);
        }
        class_2338 pos = ((StressGaugeBlockEntity)this.blockEntity).method_11016();
        if (!pos.equals((Object)StressGaugeBlockEntity.lastSent)) {
            StressGaugeBlockEntity.lastSent = pos;
            class_310.method_1551().field_1724.field_3944.method_52787((class_2596)new GaugeObservedPacket(StressGaugeBlockEntity.lastSent));
        }
        return true;
    }

    public static LangBuilder getFormattedStressText(double stressPercent) {
        IRotate.StressImpact stressLevel = IRotate.StressImpact.of(stressPercent);
        return CreateLang.text(TooltipHelper.makeProgressBar(3, Math.min(stressLevel.ordinal() + 1, 3))).translate("tooltip.stressImpact." + Lang.asId(stressLevel.name()), new Object[0]).text(String.format(" (%s%%) ", (int)(stressPercent * 100.0))).style(stressLevel.getRelativeColor());
    }
}

