/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture.fix;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import net.minecraft.class_1208;
import net.minecraft.class_9228;

public class PictureFrameInlineNbtFix
extends DataFix {
    public PictureFrameInlineNbtFix(Schema outputSchema) {
        super(outputSchema, false);
    }

    protected TypeRewriteRule makeRule() {
        OpticFinder opticFinder = DSL.namedChoice((String)"camerapture:picture_frame", (Type)this.getInputSchema().getChoiceType(class_1208.field_5729, "camerapture:picture_frame"));
        return this.fixTypeEverywhereTyped("InlineBlockPosFormatFix - Camerapture Picture Frame", this.getInputSchema().getType(class_1208.field_5729), entityTyped -> entityTyped.updateTyped(opticFinder, pictureFrameTyped -> pictureFrameTyped.update(DSL.remainderFinder(), this::fixPictureFrameFields)));
    }

    private Dynamic<?> fixPictureFrameFields(Dynamic<?> dynamic) {
        dynamic = dynamic.renameField("Width", "width");
        dynamic = dynamic.renameField("Height", "height");
        dynamic = dynamic.renameField("Item", "item");
        dynamic = dynamic.renameField("PictureGlowing", "picture_glowing");
        dynamic = dynamic.renameField("Fixed", "fixed");
        dynamic = dynamic.renameField("Rotation", "rotation");
        dynamic = dynamic.renameAndFixField("Facing", "facing", facing -> switch (facing.asInt(0)) {
            case 0 -> facing.createString("down");
            case 1 -> facing.createString("up");
            case 3 -> facing.createString("south");
            case 4 -> facing.createString("west");
            case 5 -> facing.createString("east");
            default -> facing.createString("north");
        });
        return class_9228.method_67331((Dynamic)dynamic, (String)"TileX", (String)"TileY", (String)"TileZ", (String)"block_pos");
    }
}

