/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.container.v1;

import fuzs.puzzleslib.impl.container.SlotsProvider;
import net.minecraft.class_11343;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_2371;

public final class ContainerSerializationHelper {
    private ContainerSerializationHelper() {
    }

    public static void saveAllItems(class_11372 valueOutput, class_2371<class_1799> itemStacks) {
        ContainerSerializationHelper.storeAsSlots(itemStacks, (class_11372.class_11373<class_11343>)valueOutput.method_71467("Items", class_11343.field_60354));
    }

    public static void saveAllItems(class_11372 valueOutput, class_1263 container) {
        ContainerSerializationHelper.storeAsSlots(container, (class_11372.class_11373<class_11343>)valueOutput.method_71467("Items", class_11343.field_60354));
    }

    public static void storeAsSlots(class_2371<class_1799> itemStacks, class_11372.class_11373<class_11343> typedOutputList) {
        ContainerSerializationHelper.storeAsSlots(SlotsProvider.of(itemStacks), typedOutputList);
    }

    public static void storeAsSlots(class_1263 container, class_11372.class_11373<class_11343> typedOutputList) {
        ContainerSerializationHelper.storeAsSlots(SlotsProvider.of(container), typedOutputList);
    }

    private static void storeAsSlots(SlotsProvider slotsProvider, class_11372.class_11373<class_11343> typedOutputList) {
        for (int i = 0; i < slotsProvider.getContainerSize(); ++i) {
            class_1799 itemStack = slotsProvider.getItem(i);
            if (itemStack.method_7960()) continue;
            typedOutputList.method_71484((Object)new class_11343(i, itemStack));
        }
    }

    public static void loadAllItems(class_11368 valueInput, class_2371<class_1799> itemStacks) {
        ContainerSerializationHelper.fromSlots(itemStacks, (class_11368.class_11369<class_11343>)valueInput.method_71437("Items", class_11343.field_60354));
    }

    public static void loadAllItems(class_11368 valueInput, class_1263 container) {
        ContainerSerializationHelper.fromSlots(container, (class_11368.class_11369<class_11343>)valueInput.method_71437("Items", class_11343.field_60354));
    }

    public static void fromSlots(class_2371<class_1799> itemStacks, class_11368.class_11369<class_11343> typedInputList) {
        ContainerSerializationHelper.fromSlots(SlotsProvider.of(itemStacks), typedInputList);
    }

    public static void fromSlots(class_1263 container, class_11368.class_11369<class_11343> typedInputList) {
        ContainerSerializationHelper.fromSlots(SlotsProvider.of(container), typedInputList);
    }

    private static void fromSlots(SlotsProvider slotsProvider, class_11368.class_11369<class_11343> typedInputList) {
        slotsProvider.clearContent();
        for (class_11343 itemStackWithSlot : typedInputList) {
            if (!itemStackWithSlot.method_71368(slotsProvider.getContainerSize())) continue;
            slotsProvider.setItem(itemStackWithSlot.comp_4211(), itemStackWithSlot.comp_4212());
        }
    }
}

