/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.handler;

import fuzs.mutantmonsters.MutantMonsters;
import fuzs.mutantmonsters.config.CommonConfig;
import fuzs.mutantmonsters.handler.SpawnerDataBuilder;
import fuzs.mutantmonsters.init.ModEntityTypes;
import fuzs.mutantmonsters.init.ModTags;
import fuzs.puzzleslib.api.biome.v1.BiomeLoadingPhase;
import fuzs.puzzleslib.api.core.v1.context.BiomeModificationsContext;
import java.util.function.DoubleSupplier;
import net.minecraft.class_1299;
import net.minecraft.class_1959;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import org.apache.commons.lang3.math.Fraction;

public final class BiomeModificationsHandler {
    private BiomeModificationsHandler() {
    }

    public static void onRegisterBiomeModifications(BiomeModificationsContext context) {
        BiomeModificationsHandler.registerMutantSpawn(context, ModTags.WITHOUT_MUTANT_CREEPER_SPAWNS_BIOME_TAG, () -> ((CommonConfig)MutantMonsters.CONFIG.get(CommonConfig.class)).mutantCreeperSpawnWeight, class_1299.field_6046.method_40124(), ModEntityTypes.MUTANT_CREEPER_ENTITY_TYPE);
        BiomeModificationsHandler.registerMutantSpawn(context, ModTags.WITHOUT_MUTANT_ENDERMAN_SPAWNS_BIOME_TAG, () -> ((CommonConfig)MutantMonsters.CONFIG.get(CommonConfig.class)).mutantEndermanSpawnWeight, class_1299.field_6091.method_40124(), ModEntityTypes.MUTANT_ENDERMAN_ENTITY_TYPE);
        BiomeModificationsHandler.registerMutantSpawn(context, ModTags.WITHOUT_MUTANT_SKELETON_SPAWNS_BIOME_TAG, () -> ((CommonConfig)MutantMonsters.CONFIG.get(CommonConfig.class)).mutantSkeletonSpawnWeight, class_1299.field_6137.method_40124(), ModEntityTypes.MUTANT_SKELETON_ENTITY_TYPE);
        BiomeModificationsHandler.registerMutantSpawn(context, ModTags.WITHOUT_MUTANT_ZOMBIE_SPAWNS_BIOME_TAG, () -> ((CommonConfig)MutantMonsters.CONFIG.get(CommonConfig.class)).mutantZombieSpawnWeight, class_1299.field_6051.method_40124(), ModEntityTypes.MUTANT_ZOMBIE_ENTITY_TYPE);
    }

    private static void registerMutantSpawn(BiomeModificationsContext context, class_6862<class_1959> withoutSpawnsTag, DoubleSupplier spawnWeightSupplier, class_6880.class_6883<? extends class_1299<?>> vanillaEntityType, class_6880.class_6883<? extends class_1299<?>> mutantEntityType) {
        context.registerBiomeModification(BiomeLoadingPhase.ADDITIONS, biomeLoadingContext -> !biomeLoadingContext.is(withoutSpawnsTag), biomeModificationContext -> SpawnerDataBuilder.create(biomeModificationContext.mobSpawnSettings(), (class_1299)vanillaEntityType.comp_349()).setWeight(Fraction.getFraction((int)1, (int)Math.round(1.0f / (float)spawnWeightSupplier.getAsDouble()))).setMinCount(1).setMaxCount(1).apply((class_1299)mutantEntityType.comp_349()));
    }
}

