/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.foundation.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.IntFunction;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_5699;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class ItemSlots {
    public static final Codec<ItemSlots> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap(CreateCodecs.boundedIntStr(0), (Codec)class_1799.field_24671).fieldOf("items").forGetter(ItemSlots::toBoxedMap), (App)class_5699.field_33441.fieldOf("size").forGetter(ItemSlots::getSize)).apply((Applicative)instance, ItemSlots::deserialize));
    public static final class_9139<class_9129, ItemSlots> STREAM_CODEC = class_9139.method_56435((class_9139)class_9135.method_56377(HashMap::new, (class_9139)class_9135.field_49675, (class_9139)class_1799.field_48349), ItemSlots::toBoxedMap, (class_9139)class_9135.field_49675, ItemSlots::getSize, ItemSlots::deserialize);
    private final Int2ObjectMap<class_1799> map = new Int2ObjectOpenHashMap();
    private int size = 0;

    public void set(int slot, class_1799 stack) {
        if (slot < 0) {
            throw new IllegalArgumentException("Slot must be positive");
        }
        if (!stack.method_7960()) {
            this.map.put(slot, (Object)stack);
            this.size = Math.max(this.size, slot + 1);
        }
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        if (size <= this.getHighestSlot()) {
            throw new IllegalStateException("cannot set size to below the highest slot");
        }
        this.size = size;
    }

    public void forEach(SlotConsumer consumer) {
        for (Int2ObjectMap.Entry entry : this.map.int2ObjectEntrySet()) {
            consumer.accept(entry.getIntKey(), (class_1799)entry.getValue());
        }
    }

    private int getHighestSlot() {
        return this.map.keySet().intStream().max().orElse(-1);
    }

    public <T extends class_1263> T toHandler(IntFunction<T> factory) {
        class_1263 handler = (class_1263)factory.apply(this.size);
        this.forEach((arg_0, arg_1) -> ((class_1263)handler).method_5447(arg_0, arg_1));
        return (T)handler;
    }

    public static ItemSlots fromHandler(class_1263 handler) {
        ItemSlots slots = new ItemSlots();
        int size = handler.method_5439();
        slots.setSize(size);
        for (int i = 0; i < size; ++i) {
            class_1799 stack = handler.method_5438(i);
            if (stack.method_7960()) continue;
            slots.set(i, stack.method_7972());
        }
        return slots;
    }

    public Map<Integer, class_1799> toBoxedMap() {
        HashMap<Integer, class_1799> map = new HashMap<Integer, class_1799>();
        this.forEach(map::put);
        return map;
    }

    public static ItemSlots fromBoxedMap(Map<Integer, class_1799> map) {
        ItemSlots slots = new ItemSlots();
        map.forEach(slots::set);
        return slots;
    }

    public static Codec<ItemSlots> maxSizeCodec(int maxSize) {
        return CODEC.validate(slots -> slots.size <= maxSize ? DataResult.success((Object)slots) : DataResult.error(() -> "Slots above maximum of " + maxSize));
    }

    private static ItemSlots deserialize(Map<Integer, class_1799> map, int size) {
        ItemSlots slots = ItemSlots.fromBoxedMap(map);
        slots.setSize(size);
        return slots;
    }

    @FunctionalInterface
    public static interface SlotConsumer {
        public void accept(int var1, class_1799 var2);
    }
}

