/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.fan;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.kinetics.fan.AirCurrent;
import com.zurrtum.create.content.kinetics.fan.IAirCurrentSource;
import com.zurrtum.create.content.kinetics.fan.NozzleBlock;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_3959;

public class NozzleBlockEntity
extends SmartBlockEntity {
    private final List<class_1297> pushingEntities = new ArrayList<class_1297>();
    private float range;
    private boolean pushing;
    private class_2338 fanPos;

    public NozzleBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.NOZZLE, pos, state);
        this.setLazyTickRate(5);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        if (!clientPacket) {
            return;
        }
        view.method_71464("Range", this.range);
        view.method_71472("Pushing", this.pushing);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        if (!clientPacket) {
            return;
        }
        this.range = view.method_71423("Range", 0.0f);
        this.pushing = view.method_71433("Pushing", false);
    }

    @Override
    public void initialize() {
        this.fanPos = this.field_11867.method_10093(((class_2350)this.method_11010().method_11654((class_2769)NozzleBlock.field_10927)).method_10153());
        super.initialize();
    }

    @Override
    public void tick() {
        super.tick();
        float range = this.calcRange();
        if (this.range != range) {
            this.setRange(range);
        }
        class_243 center = VecHelper.getCenterOf((class_2382)this.field_11867);
        if (this.field_11863.field_9236 && range != 0.0f && this.field_11863.field_9229.method_43048(class_3532.method_15340((int)((Integer)AllConfigs.server().kinetics.fanPushDistance.get() - (int)range), (int)1, (int)10)) == 0) {
            class_243 start = VecHelper.offsetRandomly(center, this.field_11863.field_9229, this.pushing ? 1.0f : range / 2.0f);
            class_243 motion = center.method_1020(start).method_1029().method_1021((double)(class_3532.method_15363((float)(range * (this.pushing ? 0.025f : 1.0f)), (float)0.0f, (float)0.5f) * (float)(this.pushing ? -1 : 1)));
            this.field_11863.method_8406((class_2394)class_2398.field_11203, start.field_1352, start.field_1351, start.field_1350, motion.field_1352, motion.field_1351, motion.field_1350);
        }
        Iterator<class_1297> iterator = this.pushingEntities.iterator();
        while (iterator.hasNext()) {
            class_1297 entity = iterator.next();
            class_243 diff = entity.method_19538().method_1020(center);
            if (!(entity instanceof class_1657) && this.field_11863.field_9236) continue;
            double distance = diff.method_1033();
            if (distance > (double)range || entity.method_5715() || AirCurrent.isPlayerCreativeFlying(entity)) {
                iterator.remove();
                continue;
            }
            if (!this.pushing && distance < 1.5) continue;
            float factor = entity instanceof class_1542 ? 0.0078125f : 0.03125f;
            class_243 pushVec = diff.method_1029().method_1021(((double)range - distance) * (double)(this.pushing ? 1 : -1));
            entity.method_18799(entity.method_18798().method_1019(pushVec.method_1021((double)factor)));
            entity.field_6017 = 0.0;
            entity.field_6037 = true;
        }
    }

    public void setRange(float range) {
        this.range = range;
        if (range == 0.0f) {
            this.pushingEntities.clear();
        }
        this.sendData();
    }

    private float calcRange() {
        class_2586 be = this.field_11863.method_8321(this.fanPos);
        if (!(be instanceof IAirCurrentSource)) {
            return 0.0f;
        }
        IAirCurrentSource source = (IAirCurrentSource)be;
        if (source.getAirCurrent() == null) {
            return 0.0f;
        }
        if (source.getSpeed() == 0.0f) {
            return 0.0f;
        }
        this.pushing = source.getAirFlowDirection() == source.getAirflowOriginSide();
        return source.getMaxDistance();
    }

    @Override
    public void lazyTick() {
        class_1297 entity2;
        super.lazyTick();
        if (this.range == 0.0f) {
            return;
        }
        class_243 center = VecHelper.getCenterOf((class_2382)this.field_11867);
        class_238 bb = new class_238(center, center).method_1014((double)(this.range / 2.0f));
        for (class_1297 entity2 : this.field_11863.method_18467(class_1297.class, bb)) {
            class_243 diff = entity2.method_19538().method_1020(center);
            double distance = diff.method_1033();
            if (distance > (double)this.range || entity2.method_5715() || AirCurrent.isPlayerCreativeFlying(entity2)) continue;
            boolean canSee = this.canSee(entity2);
            if (!canSee) {
                this.pushingEntities.remove(entity2);
                continue;
            }
            if (this.pushingEntities.contains(entity2)) continue;
            this.pushingEntities.add(entity2);
        }
        Iterator<class_1297> iterator = this.pushingEntities.iterator();
        while (iterator.hasNext()) {
            entity2 = iterator.next();
            if (entity2.method_5805()) continue;
            iterator.remove();
        }
        if (!this.pushing && this.pushingEntities.size() > 256 && !this.field_11863.field_9236) {
            this.field_11863.method_8437(null, center.field_1352, center.field_1351, center.field_1350, 2.0f, class_1937.class_7867.field_40888);
            iterator = this.pushingEntities.iterator();
            while (iterator.hasNext()) {
                entity2 = iterator.next();
                entity2.method_31472();
                iterator.remove();
            }
        }
    }

    private boolean canSee(class_1297 entity) {
        class_3959 context = new class_3959(entity.method_19538(), VecHelper.getCenterOf((class_2382)this.field_11867), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, entity);
        return this.field_11867.equals((Object)this.field_11863.method_17742(context).method_17777());
    }
}

