/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.base;

import com.zurrtum.create.api.behaviour.movement.MovementBehaviour;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.OrientedContraptionEntity;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.content.contraptions.mounted.MountedContraption;
import com.zurrtum.create.content.kinetics.base.BlockBreakingKineticBlockEntity;
import com.zurrtum.create.content.trains.entity.CarriageContraption;
import com.zurrtum.create.foundation.utility.BlockHelper;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1688;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3532;

public class BlockBreakingMovementBehaviour
extends MovementBehaviour {
    @Override
    public void startMoving(MovementContext context) {
        if (context.world.field_9236) {
            return;
        }
        context.data.method_10569("BreakerId", -BlockBreakingKineticBlockEntity.NEXT_BREAKER_ID.incrementAndGet());
    }

    @Override
    public void visitNewPosition(MovementContext context, class_2338 pos) {
        class_1937 world = context.world;
        class_2680 stateVisited = world.method_8320(pos);
        if (!stateVisited.method_26212((class_1922)world, pos)) {
            this.damageEntities(context, pos, world);
        }
        if (world.field_9236) {
            return;
        }
        if (!this.canBreak(world, pos, stateVisited)) {
            return;
        }
        context.data.method_67494("BreakingPos", class_2338.field_25064, (Object)pos);
        context.stall = true;
    }

    public void damageEntities(MovementContext context, class_2338 pos, class_1937 world) {
        class_1282 damageSource;
        Object object = context.contraption.entity;
        if (object instanceof OrientedContraptionEntity) {
            OrientedContraptionEntity oce = (OrientedContraptionEntity)((Object)object);
            if (oce.nonDamageTicks > 0) {
                return;
            }
        }
        if ((damageSource = this.getDamageSource(world)) == null && !this.throwsEntities(world)) {
            return;
        }
        block0: for (class_1297 entity : world.method_18467(class_1297.class, new class_238(pos))) {
            if (entity instanceof class_1542 || entity instanceof AbstractContraptionEntity || entity.method_5794((class_1297)context.contraption.entity)) continue;
            if (entity instanceof class_1688) {
                for (class_1297 passenger : entity.method_5736()) {
                    if (!(passenger instanceof AbstractContraptionEntity) || ((AbstractContraptionEntity)passenger).getContraption() != context.contraption) continue;
                    continue block0;
                }
            }
            if (damageSource != null && !world.field_9236) {
                float damage = (float)class_3532.method_15350((double)(6.0 * Math.pow(context.relativeMotion.method_1033(), 0.4) + 1.0), (double)2.0, (double)10.0);
                entity.method_64397((class_3218)world, damageSource, damage);
            }
            if (!this.throwsEntities(world) || world.field_9236 != entity instanceof class_1657) continue;
            this.throwEntity(context, entity);
        }
    }

    protected void throwEntity(MovementContext context, class_1297 entity) {
        class_243 motionBoost = context.motion.method_1031(0.0, context.motion.method_1033() / 4.0, 0.0);
        int maxBoost = 4;
        if (motionBoost.method_1033() > (double)maxBoost) {
            motionBoost = motionBoost.method_1020(motionBoost.method_1029().method_1021(motionBoost.method_1033() - (double)maxBoost));
        }
        entity.method_18799(entity.method_18798().method_1019(motionBoost));
        entity.field_6037 = true;
    }

    protected class_1282 getDamageSource(class_1937 level) {
        return null;
    }

    protected boolean throwsEntities(class_1937 level) {
        return this.getDamageSource(level) != null;
    }

    @Override
    public void cancelStall(MovementContext context) {
        class_2487 data = context.data;
        if (context.world.field_9236) {
            return;
        }
        if (!data.method_10545("BreakingPos")) {
            return;
        }
        class_1937 world = context.world;
        int id = data.method_68083("BreakerId", 0);
        class_2338 breakingPos = data.method_67491("BreakingPos", class_2338.field_25064).orElse(class_2338.field_10980);
        data.method_10551("Progress");
        data.method_10551("TicksUntilNextProgress");
        data.method_10551("BreakingPos");
        super.cancelStall(context);
        world.method_8517(id, breakingPos, -1);
    }

    @Override
    public void stopMoving(MovementContext context) {
        this.cancelStall(context);
    }

    @Override
    public void tick(MovementContext context) {
        this.tickBreaker(context);
        class_2487 data = context.data;
        if (!data.method_10545("WaitingTicks")) {
            return;
        }
        int waitingTicks = data.method_68083("WaitingTicks", 0);
        if (waitingTicks-- > 0) {
            data.method_10569("WaitingTicks", waitingTicks);
            context.stall = true;
            return;
        }
        class_2338 pos = data.method_67491("LastPos", class_2338.field_25064).orElse(class_2338.field_10980);
        data.method_10551("WaitingTicks");
        data.method_10551("LastPos");
        context.stall = false;
        this.visitNewPosition(context, pos);
    }

    public void tickBreaker(MovementContext context) {
        class_2487 data = context.data;
        if (context.world.field_9236) {
            return;
        }
        if (!data.method_10545("BreakingPos")) {
            context.stall = false;
            return;
        }
        if (context.relativeMotion.equals((Object)class_243.field_1353)) {
            context.stall = false;
            return;
        }
        int ticksUntilNextProgress = data.method_68083("TicksUntilNextProgress", 0);
        if (ticksUntilNextProgress-- > 0) {
            data.method_10569("TicksUntilNextProgress", ticksUntilNextProgress);
            return;
        }
        class_1937 world = context.world;
        class_2338 breakingPos = data.method_67491("BreakingPos", class_2338.field_25064).orElse(class_2338.field_10980);
        int destroyProgress = data.method_68083("Progress", 0);
        int id = data.method_68083("BreakerId", 0);
        class_2680 stateToBreak = world.method_8320(breakingPos);
        float blockHardness = stateToBreak.method_26214((class_1922)world, breakingPos);
        if (!this.canBreak(world, breakingPos, stateToBreak)) {
            if (destroyProgress != 0) {
                data.method_10551("Progress");
                data.method_10551("TicksUntilNextProgress");
                data.method_10551("BreakingPos");
                world.method_8517(id, breakingPos, -1);
            }
            context.stall = false;
            return;
        }
        float breakSpeed = this.getBlockBreakingSpeed(context);
        destroyProgress += class_3532.method_15340((int)((int)(breakSpeed / blockHardness)), (int)1, (int)(10 - destroyProgress));
        world.method_8396(null, breakingPos, stateToBreak.method_26231().method_10596(), class_3419.field_15254, 0.25f, 1.0f);
        if (destroyProgress >= 10) {
            world.method_8517(id, breakingPos, -1);
            class_2338 ogPos = breakingPos;
            class_2680 stateAbove = world.method_8320(breakingPos.method_10084());
            while (stateAbove.method_26204() instanceof class_2346) {
                breakingPos = breakingPos.method_10084();
                stateAbove = world.method_8320(breakingPos.method_10084());
            }
            stateToBreak = world.method_8320(breakingPos);
            context.stall = false;
            if (this.shouldDestroyStartBlock(stateToBreak)) {
                this.destroyBlock(context, breakingPos);
            }
            this.onBlockBroken(context, ogPos, stateToBreak);
            ticksUntilNextProgress = -1;
            data.method_10551("Progress");
            data.method_10551("TicksUntilNextProgress");
            data.method_10551("BreakingPos");
            return;
        }
        ticksUntilNextProgress = (int)(blockHardness / breakSpeed);
        world.method_8517(id, breakingPos, destroyProgress);
        data.method_10569("TicksUntilNextProgress", ticksUntilNextProgress);
        data.method_10569("Progress", destroyProgress);
    }

    protected void destroyBlock(MovementContext context, class_2338 breakingPos) {
        BlockHelper.destroyBlock(context.world, breakingPos, 1.0f, stack -> this.dropItem(context, (class_1799)stack));
    }

    protected float getBlockBreakingSpeed(MovementContext context) {
        float lowerLimit = 0.0078125f;
        if (context.contraption instanceof MountedContraption) {
            lowerLimit = 1.0f;
        }
        if (context.contraption instanceof CarriageContraption) {
            lowerLimit = 2.0f;
        }
        return class_3532.method_15363((float)(Math.abs(context.getAnimationSpeed()) / 500.0f), (float)lowerLimit, (float)16.0f);
    }

    protected boolean shouldDestroyStartBlock(class_2680 stateToBreak) {
        return true;
    }

    public boolean canBreak(class_1937 world, class_2338 breakingPos, class_2680 state) {
        float blockHardness = state.method_26214((class_1922)world, breakingPos);
        return BlockBreakingKineticBlockEntity.isBreakable(state, blockHardness);
    }

    protected void onBlockBroken(MovementContext context, class_2338 pos, class_2680 brokenState) {
        if (!(brokenState.method_26204() instanceof class_2346)) {
            return;
        }
        class_2487 data = context.data;
        data.method_10569("WaitingTicks", 10);
        data.method_67494("LastPos", class_2338.field_25064, (Object)pos);
        context.stall = true;
    }
}

