/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.entity;

import com.google.common.collect.ImmutableList;
import com.tristankechlo.livingthings.config.entity.LionConfig;
import com.tristankechlo.livingthings.entity.ai.BetterMeleeAttackGoal;
import com.tristankechlo.livingthings.entity.misc.IGenderedMob;
import com.tristankechlo.livingthings.entity.misc.IMobVariants;
import com.tristankechlo.livingthings.init.ModEntityTypes;
import com.tristankechlo.livingthings.init.ModSounds;
import com.tristankechlo.livingthings.util.ILexiconEntry;
import com.tristankechlo.livingthings.util.LexiconEntries;
import com.tristankechlo.livingthings.util.LivingThingsTags;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3489;
import net.minecraft.class_3730;
import net.minecraft.class_4802;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5354;
import net.minecraft.class_5398;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6011;
import net.minecraft.class_6019;
import net.minecraft.class_9334;

public class LionEntity
extends class_1429
implements class_5354,
IMobVariants,
IGenderedMob,
ILexiconEntry {
    private static final class_2940<Boolean> MALE = class_2945.method_12791(LionEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Byte> LION_VARIANT = class_2945.method_12791(LionEntity.class, (class_2941)class_2943.field_13319);
    private static final class_6019 rangedInteger = class_4802.method_24505((int)20, (int)39);
    private int angerTime;
    private UUID angerTarget;

    public LionEntity(class_1299<? extends LionEntity> entityType, class_1937 worldIn) {
        super(entityType, worldIn);
    }

    public static boolean checkLionSpawnRules(class_1299<LionEntity> animal, class_1936 world, class_3730 reason, class_2338 pos, class_5819 random) {
        return world.method_8320(pos.method_10074()).method_26164(LivingThingsTags.LION_SPAWNABLE_ON) && LionEntity.method_39448((class_1920)world, (class_2338)pos);
    }

    public class_1296 method_5613(class_3218 world, class_1296 entityIn) {
        LionEntity entityChild = (LionEntity)ModEntityTypes.LION.get().method_5883(this.method_37908(), class_3730.field_16466);
        entityChild.setGender(LionEntity.getWeightedRandomGender(this.field_5974));
        entityChild.setVariant(this.getVariantFromParents((class_1296)this, entityIn));
        return entityChild;
    }

    public class_1315 method_5943(class_5425 worldIn, class_1266 difficultyIn, class_3730 reason, class_1315 spawnDataIn) {
        this.setGender(LionEntity.getWeightedRandomGender(this.field_5974));
        int color1Weight = (Integer)LionConfig.get().color1Weight.get();
        int colorWhiteWeight = (Integer)LionConfig.get().colorWhiteWeight.get();
        byte variant = this.getRandomVariant(this.field_5974, new byte[]{0, 1}, new int[]{color1Weight, colorWhiteWeight});
        this.setVariant(variant);
        return super.method_5943(worldIn, difficultyIn, reason, spawnDataIn);
    }

    public static IGenderedMob.Gender getWeightedRandomGender(class_5819 random) {
        int maleWeight = (Integer)LionConfig.get().maleWeight.get();
        int femaleWeight = (Integer)LionConfig.get().femaleWeight.get();
        if (maleWeight <= 0 && femaleWeight <= 0) {
            return random.method_43056() ? IGenderedMob.Gender.MALE : IGenderedMob.Gender.FEMALE;
        }
        Optional gender = class_6011.method_34986((class_5819)random, (List)ImmutableList.of((Object)new IGenderedMob.WeightedGender(Math.max(0, maleWeight), IGenderedMob.Gender.MALE), (Object)new IGenderedMob.WeightedGender(Math.max(0, femaleWeight), IGenderedMob.Gender.FEMALE)), IGenderedMob.WeightedGender::weight);
        return ((IGenderedMob.WeightedGender)gender.get()).gender();
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_52450, LionConfig.temptRange()).method_26868(class_5134.field_23716, LionConfig.health()).method_26868(class_5134.field_23719, LionConfig.movementSpeed()).method_26868(class_5134.field_23717, 16.0).method_26868(class_5134.field_23721, LionConfig.attackDamage());
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new BetterMeleeAttackGoal((class_1314)this, 1.1, false, LionConfig::canAttack));
        this.field_6201.method_6277(2, (class_1352)new class_1394((class_1314)this, 0.9));
        this.field_6201.method_6277(3, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(4, (class_1352)new class_1353((class_1429)this, 0.95));
        this.field_6201.method_6277(5, (class_1352)new class_1361((class_1308)this, class_1657.class, 7.0f));
        this.field_6201.method_6277(6, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(0, (class_1352)new class_1399((class_1314)this, new Class[0]).method_6318(new Class[0]));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1657.class, 10, true, true, null));
        this.field_6185.method_6277(2, (class_1352)new class_5398((class_1308)this, true));
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(MALE, (Object)false);
        builder.method_56912(LION_VARIANT, (Object)0);
    }

    public void method_5652(class_11372 compound) {
        super.method_5652(compound);
        if (this.getGender() == IGenderedMob.Gender.MALE) {
            compound.method_71472("IsMale", true);
        }
        compound.method_71462("LionVariant", this.getVariant());
        this.method_29517(compound);
    }

    public void method_5749(class_11368 compound) {
        super.method_5749(compound);
        if (compound.method_71433("IsMale", false)) {
            this.setGender(IGenderedMob.Gender.MALE);
        } else {
            this.setGender(IGenderedMob.Gender.FEMALE);
        }
        this.setVariant(compound.method_71421("LionVariant", (byte)0));
        this.method_29512(this.method_37908(), compound);
    }

    protected class_238 method_53511() {
        return super.method_53511().method_1014(1.8);
    }

    public boolean method_6474(class_1429 otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (otherAnimal instanceof LionEntity) {
            LionEntity otherLion = (LionEntity)otherAnimal;
            if (this.getGender() != otherLion.getGender()) {
                return this.method_6479() && otherLion.method_6479();
            }
        }
        return false;
    }

    protected float method_6120() {
        return 0.85f;
    }

    public boolean method_6481(class_1799 stack) {
        boolean isMeat = stack.method_57826(class_9334.field_50075) && stack.method_31573(class_3489.field_49932);
        return stack.method_31573(LivingThingsTags.LION_FOOD) || LionConfig.allowAllMeatAsFood() && isMeat;
    }

    protected class_3414 method_5994() {
        return ModSounds.LION_AMBIENT.get();
    }

    protected class_3414 method_6011(class_1282 damageSourceIn) {
        return ModSounds.LION_HURT.get();
    }

    protected class_3414 method_6002() {
        return ModSounds.LION_DEATH.get();
    }

    public int method_5945() {
        return LionConfig.maxSpawnedInChunk();
    }

    @Override
    public IGenderedMob.Gender getGender() {
        if (((Boolean)this.method_5841().method_12789(MALE)).booleanValue()) {
            return IGenderedMob.Gender.MALE;
        }
        return IGenderedMob.Gender.FEMALE;
    }

    @Override
    public void setGender(IGenderedMob.Gender gender) {
        if (gender == IGenderedMob.Gender.MALE) {
            this.method_5841().method_12778(MALE, (Object)true);
        } else {
            this.method_5841().method_12778(MALE, (Object)false);
        }
    }

    @Override
    public byte getVariant() {
        return (Byte)this.method_5841().method_12789(LION_VARIANT);
    }

    @Override
    public void setVariant(byte variant) {
        this.method_5841().method_12778(LION_VARIANT, (Object)variant);
    }

    public int method_29507() {
        return this.angerTime;
    }

    public void method_29514(int time) {
        this.angerTime = time;
    }

    public UUID method_29508() {
        return this.angerTarget;
    }

    public void method_29513(UUID target) {
        this.angerTarget = target;
    }

    public void method_29509() {
        this.method_29514(rangedInteger.method_35008(this.field_5974));
    }

    @Override
    public class_2960 getLexiconEntry() {
        return LexiconEntries.LION;
    }
}

