/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.block;

import java.util.function.Function;
import net.blay09.mods.balm.api.block.BalmBlocks;
import net.blay09.mods.waystones.block.PortstoneBlock;
import net.blay09.mods.waystones.block.SharestoneBlock;
import net.blay09.mods.waystones.block.WarpPlateBlock;
import net.blay09.mods.waystones.block.WaystoneBlock;
import net.blay09.mods.waystones.component.DescriptionComponent;
import net.blay09.mods.waystones.component.ModComponents;
import net.blay09.mods.waystones.item.PortstoneBlockItem;
import net.blay09.mods.waystones.item.SharestoneBlockItem;
import net.blay09.mods.waystones.item.WaystoneBlockItem;
import net.minecraft.class_124;
import net.minecraft.class_1747;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_9331;
import org.jetbrains.annotations.Nullable;

public class ModBlocks {
    private static final class_1767[] portstoneColors = new class_1767[]{class_1767.field_7952, class_1767.field_7946, class_1767.field_7958, class_1767.field_7951, class_1767.field_7947, class_1767.field_7961, class_1767.field_7954, class_1767.field_7944, class_1767.field_7967, class_1767.field_7955, class_1767.field_7945, class_1767.field_7966, class_1767.field_7957, class_1767.field_7942, class_1767.field_7964, class_1767.field_7963};
    private static final class_1767[] sharestoneColors = new class_1767[]{class_1767.field_7946, class_1767.field_7958, class_1767.field_7951, class_1767.field_7947, class_1767.field_7961, class_1767.field_7954, class_1767.field_7944, class_1767.field_7967, class_1767.field_7955, class_1767.field_7945, class_1767.field_7966, class_1767.field_7957, class_1767.field_7942, class_1767.field_7964, class_1767.field_7963};
    public static class_2248 waystone;
    public static class_2248 mossyWaystone;
    public static class_2248 sandyWaystone;
    public static class_2248 deepslateWaystone;
    public static class_2248 blackstoneWaystone;
    public static class_2248 endStoneWaystone;
    public static class_2248 warpPlate;
    public static final PortstoneBlock[] portstones;
    public static final SharestoneBlock[] sharestones;

    public static void initialize(BalmBlocks blocks) {
        blocks.register(identifier -> {
            waystone = new WaystoneBlock(ModBlocks.defaultProperties(identifier));
            return waystone;
        }, ModBlocks::waystoneItemBlock, ModBlocks.id("waystone"));
        blocks.register(identifier -> {
            mossyWaystone = new WaystoneBlock(ModBlocks.defaultProperties(identifier));
            return mossyWaystone;
        }, ModBlocks::waystoneItemBlock, ModBlocks.id("mossy_waystone"));
        blocks.register(identifier -> {
            sandyWaystone = new WaystoneBlock(ModBlocks.defaultProperties(identifier));
            return sandyWaystone;
        }, ModBlocks::waystoneItemBlock, ModBlocks.id("sandy_waystone"));
        blocks.register(identifier -> {
            deepslateWaystone = new WaystoneBlock(ModBlocks.defaultProperties(identifier).method_9626(class_2498.field_29033));
            return deepslateWaystone;
        }, ModBlocks::waystoneItemBlock, ModBlocks.id("deepslate_waystone"));
        blocks.register(identifier -> {
            blackstoneWaystone = new WaystoneBlock(ModBlocks.defaultProperties(identifier));
            return blackstoneWaystone;
        }, ModBlocks::waystoneItemBlock, ModBlocks.id("blackstone_waystone"));
        blocks.register(identifier -> {
            endStoneWaystone = new WaystoneBlock(ModBlocks.defaultProperties(identifier));
            return endStoneWaystone;
        }, ModBlocks::waystoneItemBlock, ModBlocks.id("end_stone_waystone"));
        blocks.register(identifier -> {
            warpPlate = new WarpPlateBlock(ModBlocks.defaultProperties(identifier));
            return warpPlate;
        }, ModBlocks::itemBlock, ModBlocks.id("warp_plate"));
        for (class_1767 color : portstoneColors) {
            blocks.register(identifier -> {
                PortstoneBlock portstoneBlock = new PortstoneBlock(color, ModBlocks.defaultProperties(identifier));
                ModBlocks.portstones[color.ordinal()] = portstoneBlock;
                return portstoneBlock;
            }, (block, name) -> ModBlocks.portstoneItemBlock(block, name, properties -> properties.method_57349((class_9331)ModComponents.description.get(), (Object)new DescriptionComponent((class_2561)class_2561.method_43471((String)"tooltip.waystones.portstone").method_27692(class_124.field_1080)))), ModBlocks.id(color.method_15434() + "_portstone"));
        }
        for (class_1767 color : sharestoneColors) {
            blocks.register(identifier -> {
                SharestoneBlock sharestoneBlock = new SharestoneBlock(color, ModBlocks.defaultProperties(identifier));
                ModBlocks.sharestones[color.ordinal() - 1] = sharestoneBlock;
                return sharestoneBlock;
            }, (block, name) -> ModBlocks.sharestoneItemBlock(block, name, properties -> properties.method_57349((class_9331)ModComponents.description.get(), (Object)new DescriptionComponent((class_2561)class_2561.method_43471((String)("tooltip.waystones." + name.method_12832()))))), ModBlocks.id(color.method_15434() + "_sharestone"));
        }
    }

    private static class_1747 portstoneItemBlock(class_2248 block, class_2960 name, Function<class_1792.class_1793, class_1792.class_1793> properties) {
        return new PortstoneBlockItem(block, properties.apply(ModBlocks.defaultItemProperties(name)));
    }

    private static class_1747 sharestoneItemBlock(class_2248 block, class_2960 name, Function<class_1792.class_1793, class_1792.class_1793> properties) {
        return new SharestoneBlockItem(block, properties.apply(ModBlocks.defaultItemProperties(name)));
    }

    private static class_1747 waystoneItemBlock(class_2248 block, class_2960 name) {
        return new WaystoneBlockItem(block, ModBlocks.defaultItemProperties(name));
    }

    private static class_1747 itemBlock(class_2248 block, class_2960 name) {
        return new class_1747(block, ModBlocks.defaultItemProperties(name));
    }

    private static class_1747 itemBlock(class_2248 block, class_2960 name, Function<class_1792.class_1793, class_1792.class_1793> properties) {
        return new class_1747(block, properties.apply(ModBlocks.defaultItemProperties(name)));
    }

    private static class_2960 id(String name) {
        return class_2960.method_60655((String)"waystones", (String)name);
    }

    private static class_5321<class_2248> blockId(class_2960 identifier) {
        return class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)identifier);
    }

    private static class_5321<class_1792> itemId(class_2960 identifier) {
        return class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)identifier);
    }

    private static class_4970.class_2251 defaultProperties(class_2960 identifier) {
        return class_4970.class_2251.method_9637().method_63500(ModBlocks.blockId(identifier)).method_9626(class_2498.field_11544).method_9629(5.0f, 2000.0f);
    }

    private static class_1792.class_1793 defaultItemProperties(class_2960 identifier) {
        return new class_1792.class_1793().method_63686(ModBlocks.itemId(identifier));
    }

    @Nullable
    public static SharestoneBlock getSharestone(class_1767 color) {
        int index = color.ordinal() - 1;
        if (index < 0 || index >= sharestones.length) {
            return null;
        }
        return sharestones[index];
    }

    @Nullable
    public static PortstoneBlock getPortstone(class_1767 color) {
        int index = color.ordinal();
        if (index >= portstones.length) {
            return null;
        }
        return portstones[index];
    }

    static {
        portstones = new PortstoneBlock[portstoneColors.length];
        sharestones = new SharestoneBlock[sharestoneColors.length];
    }
}

