/*
 * Decompiled with CFR 0.152.
 */
package techreborn.client.compat.rei;

import dev.architectury.fluid.FluidStack;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.entry.renderer.EntryRenderer;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.screen.ExclusionZones;
import me.shedaniel.rei.api.client.registry.screen.ExclusionZonesProvider;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.client.util.ClientEntryStacks;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.minecraft.class_1058;
import net.minecraft.class_10799;
import net.minecraft.class_1920;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_3956;
import net.minecraft.class_4730;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import reborncore.api.blockentity.IUpgradeable;
import reborncore.client.gui.GuiBase;
import reborncore.client.gui.GuiBuilder;
import reborncore.client.gui.GuiSprites;
import reborncore.client.gui.config.GuiTab;
import reborncore.common.crafting.RebornRecipe;
import techreborn.client.compat.rei.SlotConfigExclusionZones;
import techreborn.client.compat.rei.machine.AssemblingMachineCategory;
import techreborn.client.compat.rei.machine.BlastFurnaceCategory;
import techreborn.client.compat.rei.machine.DistillationTowerCategory;
import techreborn.client.compat.rei.machine.ElectrolyzerCategory;
import techreborn.client.compat.rei.machine.FluidGeneratorRecipeCategory;
import techreborn.client.compat.rei.machine.FluidReplicatorRecipeCategory;
import techreborn.client.compat.rei.machine.GrinderCategory;
import techreborn.client.compat.rei.machine.ImplosionCompressorCategory;
import techreborn.client.compat.rei.machine.IndustrialCentrifugeCategory;
import techreborn.client.compat.rei.machine.OneInputOneOutputCategory;
import techreborn.client.compat.rei.machine.RollingMachineCategory;
import techreborn.client.compat.rei.machine.SawmillCategory;
import techreborn.client.compat.rei.machine.TwoInputsCenterOutputCategory;
import techreborn.init.ModRecipes;
import techreborn.init.TRContent;
import techreborn.recipe.recipes.AssemblingMachineRecipe;
import techreborn.recipe.recipes.BlastFurnaceRecipe;
import techreborn.recipe.recipes.CentrifugeRecipe;
import techreborn.recipe.recipes.FusionReactorRecipe;
import techreborn.recipe.recipes.IndustrialGrinderRecipe;
import techreborn.recipe.recipes.IndustrialSawmillRecipe;
import techreborn.recipe.recipes.ScrapBoxRecipe;

@Environment(value=EnvType.CLIENT)
public class ReiPlugin
implements REIClientPlugin {
    public static final Map<class_3956<?>, class_1935> iconMap = new HashMap();

    public ReiPlugin() {
        iconMap.put(ModRecipes.ALLOY_SMELTER, TRContent.Machine.ALLOY_SMELTER);
        iconMap.put(ModRecipes.ASSEMBLING_MACHINE, TRContent.Machine.ASSEMBLY_MACHINE);
        iconMap.put(ModRecipes.BLAST_FURNACE, TRContent.Machine.INDUSTRIAL_BLAST_FURNACE);
        iconMap.put(ModRecipes.CENTRIFUGE, TRContent.Machine.INDUSTRIAL_CENTRIFUGE);
        iconMap.put(ModRecipes.CHEMICAL_REACTOR, TRContent.Machine.CHEMICAL_REACTOR);
        iconMap.put(ModRecipes.COMPRESSOR, TRContent.Machine.COMPRESSOR);
        iconMap.put(ModRecipes.DISTILLATION_TOWER, TRContent.Machine.DISTILLATION_TOWER);
        iconMap.put(ModRecipes.EXTRACTOR, TRContent.Machine.EXTRACTOR);
        iconMap.put(ModRecipes.FLUID_REPLICATOR, TRContent.Machine.FLUID_REPLICATOR);
        iconMap.put(ModRecipes.FUSION_REACTOR, TRContent.Machine.FUSION_CONTROL_COMPUTER);
        iconMap.put(ModRecipes.GRINDER, TRContent.Machine.GRINDER);
        iconMap.put(ModRecipes.IMPLOSION_COMPRESSOR, TRContent.Machine.IMPLOSION_COMPRESSOR);
        iconMap.put(ModRecipes.INDUSTRIAL_ELECTROLYZER, TRContent.Machine.INDUSTRIAL_ELECTROLYZER);
        iconMap.put(ModRecipes.INDUSTRIAL_GRINDER, TRContent.Machine.INDUSTRIAL_GRINDER);
        iconMap.put(ModRecipes.INDUSTRIAL_SAWMILL, TRContent.Machine.INDUSTRIAL_SAWMILL);
        iconMap.put(ModRecipes.ROLLING_MACHINE, TRContent.Machine.ROLLING_MACHINE);
        iconMap.put(ModRecipes.SCRAPBOX, () -> TRContent.SCRAP_BOX);
        iconMap.put(ModRecipes.SOLID_CANNING_MACHINE, TRContent.Machine.SOLID_CANNING_MACHINE);
        iconMap.put(ModRecipes.VACUUM_FREEZER, TRContent.Machine.VACUUM_FREEZER);
        iconMap.put(ModRecipes.WIRE_MILL, TRContent.Machine.WIRE_MILL);
    }

    public void registerCategories(CategoryRegistry registry) {
        registry.add(new TwoInputsCenterOutputCategory<RebornRecipe>(ModRecipes.ALLOY_SMELTER));
        registry.add(new AssemblingMachineCategory<AssemblingMachineRecipe>(ModRecipes.ASSEMBLING_MACHINE));
        registry.add(new BlastFurnaceCategory<BlastFurnaceRecipe>(ModRecipes.BLAST_FURNACE));
        registry.add(new IndustrialCentrifugeCategory<CentrifugeRecipe>(ModRecipes.CENTRIFUGE));
        registry.add(new TwoInputsCenterOutputCategory<RebornRecipe>(ModRecipes.CHEMICAL_REACTOR));
        registry.add(new OneInputOneOutputCategory<RebornRecipe>(ModRecipes.COMPRESSOR));
        registry.add(new DistillationTowerCategory<RebornRecipe>(ModRecipes.DISTILLATION_TOWER));
        registry.add(new OneInputOneOutputCategory<RebornRecipe>(ModRecipes.EXTRACTOR));
        registry.add((DisplayCategory)new FluidReplicatorRecipeCategory(ModRecipes.FLUID_REPLICATOR));
        registry.add(new TwoInputsCenterOutputCategory<FusionReactorRecipe>(ModRecipes.FUSION_REACTOR));
        registry.add(new OneInputOneOutputCategory<RebornRecipe>(ModRecipes.GRINDER));
        registry.add(new ImplosionCompressorCategory<RebornRecipe>(ModRecipes.IMPLOSION_COMPRESSOR));
        registry.add(new ElectrolyzerCategory<RebornRecipe>(ModRecipes.INDUSTRIAL_ELECTROLYZER));
        registry.add(new GrinderCategory<IndustrialGrinderRecipe>(ModRecipes.INDUSTRIAL_GRINDER));
        registry.add(new SawmillCategory<IndustrialSawmillRecipe>(ModRecipes.INDUSTRIAL_SAWMILL));
        registry.add((DisplayCategory)new RollingMachineCategory(ModRecipes.ROLLING_MACHINE));
        registry.add(new OneInputOneOutputCategory<ScrapBoxRecipe>(ModRecipes.SCRAPBOX));
        registry.add(new TwoInputsCenterOutputCategory<RebornRecipe>(ModRecipes.SOLID_CANNING_MACHINE));
        registry.add(new OneInputOneOutputCategory<RebornRecipe>(ModRecipes.VACUUM_FREEZER));
        registry.add(new OneInputOneOutputCategory<RebornRecipe>(ModRecipes.WIRE_MILL));
        registry.add((DisplayCategory)new FluidGeneratorRecipeCategory(TRContent.Machine.THERMAL_GENERATOR));
        registry.add((DisplayCategory)new FluidGeneratorRecipeCategory(TRContent.Machine.GAS_TURBINE));
        registry.add((DisplayCategory)new FluidGeneratorRecipeCategory(TRContent.Machine.DIESEL_GENERATOR));
        registry.add((DisplayCategory)new FluidGeneratorRecipeCategory(TRContent.Machine.SEMI_FLUID_GENERATOR));
        registry.add((DisplayCategory)new FluidGeneratorRecipeCategory(TRContent.Machine.PLASMA_GENERATOR));
        this.addWorkstations(ModRecipes.ALLOY_SMELTER, EntryStacks.of((class_1935)TRContent.Machine.ALLOY_SMELTER), EntryStacks.of((class_1935)TRContent.Machine.IRON_ALLOY_FURNACE));
        this.addWorkstations(ModRecipes.ASSEMBLING_MACHINE, EntryStacks.of((class_1935)TRContent.Machine.ASSEMBLY_MACHINE));
        this.addWorkstations(ModRecipes.BLAST_FURNACE, EntryStacks.of((class_1935)TRContent.Machine.INDUSTRIAL_BLAST_FURNACE));
        this.addWorkstations(ModRecipes.CENTRIFUGE, EntryStacks.of((class_1935)TRContent.Machine.INDUSTRIAL_CENTRIFUGE));
        this.addWorkstations(ModRecipes.CHEMICAL_REACTOR, EntryStacks.of((class_1935)TRContent.Machine.CHEMICAL_REACTOR));
        this.addWorkstations(ModRecipes.COMPRESSOR, EntryStacks.of((class_1935)TRContent.Machine.COMPRESSOR));
        this.addWorkstations(ModRecipes.DISTILLATION_TOWER, EntryStacks.of((class_1935)TRContent.Machine.DISTILLATION_TOWER));
        this.addWorkstations(ModRecipes.EXTRACTOR, EntryStacks.of((class_1935)TRContent.Machine.EXTRACTOR));
        this.addWorkstations(ModRecipes.FLUID_REPLICATOR, EntryStacks.of((class_1935)TRContent.Machine.FLUID_REPLICATOR));
        this.addWorkstations(ModRecipes.FUSION_REACTOR, EntryStacks.of((class_1935)TRContent.Machine.FUSION_CONTROL_COMPUTER));
        this.addWorkstations(ModRecipes.GRINDER, EntryStacks.of((class_1935)TRContent.Machine.GRINDER));
        this.addWorkstations(ModRecipes.IMPLOSION_COMPRESSOR, EntryStacks.of((class_1935)TRContent.Machine.IMPLOSION_COMPRESSOR));
        this.addWorkstations(ModRecipes.INDUSTRIAL_ELECTROLYZER, EntryStacks.of((class_1935)TRContent.Machine.INDUSTRIAL_ELECTROLYZER));
        this.addWorkstations(ModRecipes.INDUSTRIAL_GRINDER, EntryStacks.of((class_1935)TRContent.Machine.INDUSTRIAL_GRINDER));
        this.addWorkstations(ModRecipes.INDUSTRIAL_SAWMILL, EntryStacks.of((class_1935)TRContent.Machine.INDUSTRIAL_SAWMILL));
        this.addWorkstations(ModRecipes.ROLLING_MACHINE, EntryStacks.of((class_1935)TRContent.Machine.ROLLING_MACHINE));
        this.addWorkstations(ModRecipes.SOLID_CANNING_MACHINE, EntryStacks.of((class_1935)TRContent.Machine.SOLID_CANNING_MACHINE));
        this.addWorkstations(ModRecipes.VACUUM_FREEZER, EntryStacks.of((class_1935)TRContent.Machine.VACUUM_FREEZER));
        this.addWorkstations(ModRecipes.WIRE_MILL, EntryStacks.of((class_1935)TRContent.Machine.WIRE_MILL));
        registry.addWorkstations(CategoryIdentifier.of((String)"techreborn", (String)TRContent.Machine.THERMAL_GENERATOR.name), new EntryStack[]{EntryStacks.of((class_1935)TRContent.Machine.THERMAL_GENERATOR)});
        registry.addWorkstations(CategoryIdentifier.of((String)"techreborn", (String)TRContent.Machine.GAS_TURBINE.name), new EntryStack[]{EntryStacks.of((class_1935)TRContent.Machine.GAS_TURBINE)});
        registry.addWorkstations(CategoryIdentifier.of((String)"techreborn", (String)TRContent.Machine.DIESEL_GENERATOR.name), new EntryStack[]{EntryStacks.of((class_1935)TRContent.Machine.DIESEL_GENERATOR)});
        registry.addWorkstations(CategoryIdentifier.of((String)"techreborn", (String)TRContent.Machine.SEMI_FLUID_GENERATOR.name), new EntryStack[]{EntryStacks.of((class_1935)TRContent.Machine.SEMI_FLUID_GENERATOR)});
        registry.addWorkstations(CategoryIdentifier.of((String)"techreborn", (String)TRContent.Machine.PLASMA_GENERATOR.name), new EntryStack[]{EntryStacks.of((class_1935)TRContent.Machine.PLASMA_GENERATOR)});
    }

    private void addWorkstations(class_2960 identifier, EntryStack<?> ... stacks) {
        CategoryRegistry.getInstance().addWorkstations(CategoryIdentifier.of((class_2960)identifier), stacks);
    }

    private void addWorkstations(class_3956<?> type, EntryStack<?> ... stacks) {
        CategoryRegistry.getInstance().addWorkstations(CategoryIdentifier.of((class_2960)ReiPlugin.getTypeId(type)), stacks);
    }

    private static class_2960 getTypeId(class_3956<?> type) {
        return Objects.requireNonNull(class_7923.field_41188.method_10221(type));
    }

    public void registerScreens(ScreenRegistry registry) {
        ExclusionZones exclusionZones = registry.exclusionZones();
        exclusionZones.register(GuiBase.class, guiBase -> {
            IUpgradeable upgradeable;
            class_2586 patt0$temp;
            int height = 0;
            if (guiBase.tryAddUpgrades() && (patt0$temp = guiBase.be) instanceof IUpgradeable && (upgradeable = (IUpgradeable)patt0$temp).canBeUpgraded()) {
                height = 80;
            }
            for (GuiTab slot : guiBase.getTabs()) {
                if (!slot.enabled()) continue;
                height += 24;
            }
            if (height > 0) {
                int width = 20;
                return Collections.singletonList(new Rectangle(guiBase.getGuiLeft() - width, guiBase.getGuiTop() + 8, width, height));
            }
            return Collections.emptyList();
        });
    }

    public void registerExclusionZones(ExclusionZones zones) {
        zones.register(GuiBase.class, (ExclusionZonesProvider)new SlotConfigExclusionZones());
    }

    public static Widget createProgressBar(int x, int y, double animationDuration, GuiBuilder.ProgressDirection direction) {
        return Widgets.createDrawableWidget((drawContext, mouseX, mouseY, delta) -> {
            GuiSprites.drawSpriteStretched((class_332)drawContext, (class_4730)direction.baseSprite, (int)x, (int)y, (int)direction.width, (int)direction.height);
            int j = (int)((double)System.currentTimeMillis() / animationDuration % 1.0 * 16.0);
            if (j < 0) {
                j = 0;
            }
            switch (direction) {
                case RIGHT: {
                    drawContext.method_25290(class_10799.field_56883, GuiBuilder.GUI_ELEMENTS, x, y, (float)direction.xActive, (float)direction.yActive, j, 10, 256, 256);
                    break;
                }
                case LEFT: {
                    drawContext.method_25290(class_10799.field_56883, GuiBuilder.GUI_ELEMENTS, x + 16 - j, y, (float)(direction.xActive + 16 - j), (float)direction.yActive, j, 10, 256, 256);
                    break;
                }
                case UP: {
                    drawContext.method_25290(class_10799.field_56883, GuiBuilder.GUI_ELEMENTS, x, y + 16 - j, (float)direction.xActive, (float)(direction.yActive + 16 - j), 10, j, 256, 256);
                    break;
                }
                case DOWN: {
                    drawContext.method_25290(class_10799.field_56883, GuiBuilder.GUI_ELEMENTS, x, y, (float)direction.xActive, (float)direction.yActive, 10, j, 256, 256);
                }
            }
        });
    }

    public static Widget createEnergyDisplay(Rectangle bounds, double energy, EntryAnimation animation, Function<TooltipContext, Tooltip> tooltipBuilder) {
        return Widgets.createSlot((Rectangle)bounds).entry(ClientEntryStacks.of((Renderer)new EnergyEntryRenderer(animation, tooltipBuilder))).notFavoritesInteractable();
    }

    public static Widget createFluidDisplay(Rectangle bounds, EntryStack<FluidStack> fluid, EntryAnimation animation) {
        EntryStack copy = fluid.copy();
        copy.withRenderer((EntryRenderer)new FluidStackRenderer(animation, (EntryRenderer<FluidStack>)copy.getRenderer()));
        return Widgets.createSlot((Rectangle)bounds).entry(copy);
    }

    @Environment(value=EnvType.CLIENT)
    private record EnergyEntryRenderer(EntryAnimation animation, Function<TooltipContext, Tooltip> tooltipBuilder) implements Renderer
    {
        public void render(class_332 drawContext, Rectangle bounds, int mouseX, int mouseY, float delta) {
            int innerDisplayHeight;
            int width = bounds.width + 2;
            int height = bounds.height + 2;
            int innerHeight = height - 2;
            GuiSprites.drawSpriteStretched((class_332)drawContext, (class_4730)GuiSprites.POWER_BAR_BASE, (int)(bounds.x - 1), (int)(bounds.y - 1), (int)14, (int)50);
            if (this.animation.animationType != EntryAnimationType.NONE) {
                innerDisplayHeight = class_3532.method_15384((double)((double)System.currentTimeMillis() / ((double)Math.round((double)this.animation.duration * 1000.0 / (double)innerHeight) / 1000.0) % (double)innerHeight));
                if (this.animation.animationType == EntryAnimationType.DOWNWARDS) {
                    innerDisplayHeight = innerHeight - innerDisplayHeight;
                }
            } else {
                innerDisplayHeight = innerHeight;
            }
            GuiSprites.drawSpriteStretched((class_332)drawContext, (class_4730)GuiSprites.POWER_BAR_OVERLAY, (int)bounds.x, (int)(bounds.y + innerHeight - innerDisplayHeight), (int)(width - 2), (int)innerDisplayHeight, (int)12, (int)48);
        }

        @Nullable
        public Tooltip getTooltip(TooltipContext context) {
            return this.tooltipBuilder.apply(context);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public record EntryAnimation(EntryAnimationType animationType, long duration) {
        public static EntryAnimation upwards(long duration) {
            return new EntryAnimation(EntryAnimationType.UPWARDS, duration);
        }

        public static EntryAnimation downwards(long duration) {
            return new EntryAnimation(EntryAnimationType.DOWNWARDS, duration);
        }

        public static EntryAnimation none() {
            return new EntryAnimation(EntryAnimationType.NONE, 0L);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private record FluidStackRenderer(EntryAnimation animation, EntryRenderer<FluidStack> parent) implements EntryRenderer<FluidStack>
    {
        public void render(EntryStack<FluidStack> entry, class_332 drawContext, Rectangle bounds, int mouseX, int mouseY, float delta) {
            int innerDisplayHeight;
            int width = bounds.width;
            int height = bounds.height;
            GuiSprites.drawSpriteStretched((class_332)drawContext, (class_4730)GuiSprites.TANK_BACKGROUND, (int)(bounds.x - 4), (int)(bounds.y - 4), (int)22, (int)56);
            if (this.animation.animationType != EntryAnimationType.NONE) {
                innerDisplayHeight = class_3532.method_15384((double)((double)System.currentTimeMillis() / ((double)Math.round((double)this.animation.duration * 1000.0 / (double)height) / 1000.0) % (double)height));
                if (this.animation.animationType == EntryAnimationType.DOWNWARDS) {
                    innerDisplayHeight = height - innerDisplayHeight;
                }
            } else {
                innerDisplayHeight = height;
            }
            this.drawFluid(drawContext, ((FluidStack)entry.getValue()).getFluid(), innerDisplayHeight, bounds.x, bounds.y, width, height);
            GuiSprites.drawSpriteStretched((class_332)drawContext, (class_4730)GuiSprites.TANK_FOREGROUND, (int)(bounds.x - 1), (int)(bounds.y - 1), (int)16, (int)50);
        }

        public void drawFluid(class_332 drawContext, class_3611 fluid, int drawHeight, int x, int y, int width, int height) {
            y += height - drawHeight;
            FluidRenderHandler handler = FluidRenderHandlerRegistry.INSTANCE.get(fluid);
            if (handler == null) {
                return;
            }
            class_1058 sprite = handler.getFluidSprites((class_1920)class_310.method_1551().field_1687, class_2338.field_10980, fluid.method_15785())[0];
            int color = FluidRenderHandlerRegistry.INSTANCE.get(fluid).getFluidColor((class_1920)class_310.method_1551().field_1687, class_2338.field_10980, fluid.method_15785());
            int shaderColor = color | 0xFF000000;
            int count = drawHeight / width;
            int remainder = drawHeight % width;
            for (int i = 0; i < count; ++i) {
                drawContext.method_52710(class_10799.field_56883, sprite, x, y, width, width, shaderColor);
                y += width;
            }
            if (remainder != 0) {
                drawContext.method_44379(x, y, x + width, y + remainder);
                drawContext.method_52710(class_10799.field_56883, sprite, x, y, width, width, shaderColor);
                drawContext.method_44380();
            }
        }

        @Nullable
        public Tooltip getTooltip(EntryStack<FluidStack> entry, TooltipContext context) {
            return this.parent.getTooltip(entry, context);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static enum EntryAnimationType {
        UPWARDS,
        DOWNWARDS,
        NONE;

    }
}

